/*
 * Decompiled with CFR 0.152.
 */
package org.birncommunity.sample.gridftp.tar;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.birncommunity.gridftp.tar.TarI;
import org.birncommunity.gridftp.tar.TarToPipeRunnable;
import org.birncommunity.gridftp.tar.TwoPartyTarClientFactoryI;
import org.birncommunity.gridftp.tar.TwoPartyTarClientFactoryImpl;
import org.birncommunity.gridftp.tar.TwoPartyTarTransfer;
import org.birncommunity.gridftp.tar.UntarFromPipeRunnable;
import org.birncommunity.gridftp.tar.UntarI;
import org.birncommunity.gridftp.tar.impl.compress.CompressTar;
import org.birncommunity.gridftp.tar.impl.compress.CompressUntar;
import org.birncommunity.sample.proxy.LocalCredentialHelper;
import org.birncommunity.util.FileNameUtil;
import org.birncommunity.util.MethodParameterChecker;
import org.globus.ftp.GridFTPClient;
import org.ietf.jgss.GSSCredential;

public class TarTransfer {
    private static Log log = LogFactory.getLog(TarTransfer.class);
    private String host;
    private int port;
    private String sourceDir;
    private String destDir;
    private String direction;

    public static void main(String[] args) throws Exception {
        if (args.length != 5 || args[0].equals("-h") || args[0].equals("--help")) {
            log.error((Object)("Usage: java " + TarTransfer.class.getName() + " <host> <port> <direction> <sourceDir> <destDir>"));
            log.error((Object)"host: GridFTP server hostname");
            log.error((Object)"port: GridFTP server port");
            log.error((Object)"direction: \"download\" || \"upload\"");
            log.error((Object)"sourceDir: source directory to be transfered");
            log.error((Object)"destDir: destination directory where the source directory will be stored to");
            log.error((Object)"");
            log.error((Object)"A user proxy certificate needs to be in place in /tmp");
            log.error((Object)"");
            log.error((Object)("Example: java " + TarTransfer.class.getName() + " chi-vm-4.isi.edu 2811 download /tmp/testdir /tmp/testdir"));
            log.error((Object)"This will transfer chi-vm-4.isi.edu/tmp/testdir into /tmp/testdir");
            log.error((Object)"Note: The path to the directory on the GridFTP server must be give in UNIX style");
            System.exit(1);
        }
        String host = args[0];
        int port = new Integer(args[1]);
        String direction = args[2];
        String sourceDir = args[3];
        String destDir = args[4];
        TarTransfer tt = new TarTransfer(host, port, sourceDir, destDir, direction);
        tt.doTransfer();
    }

    public TarTransfer(String host, int port, String sourceDir, String destDir, String direction) {
        new MethodParameterChecker().verifyNotNull(new Object[]{host, port, sourceDir, destDir, direction});
        if (!direction.equals("download") && !direction.equals("upload")) {
            throw new IllegalArgumentException("Invalid direction: \"download\" || \"upload\"");
        }
        this.host = host;
        this.port = port;
        this.sourceDir = sourceDir;
        this.destDir = destDir;
        this.direction = direction;
    }

    private void checkRemoteDirectory(String destDir) throws Exception {
        GridFTPClient client = null;
        try {
            FileNameUtil fnu = new FileNameUtil();
            String tmpDir = destDir;
            LinkedList<String> dirs = new LinkedList<String>();
            client = new GridFTPClient(this.host, this.port);
            client.authenticate(new LocalCredentialHelper().getDefaultCredential());
            dirs.add(tmpDir);
            while ((tmpDir = fnu.getUNIXParentDirName(tmpDir)) != null) {
                dirs.add(tmpDir);
            }
            for (int i = dirs.size() - 1; i > -1; --i) {
                if (client.exists((String)dirs.get(i))) continue;
                client.makeDir((String)dirs.get(i));
            }
        }
        catch (Exception e) {
            throw new Exception("Cannot create remote destination directory.", e);
        }
        finally {
            try {
                if (client != null) {
                    client.close(true);
                }
            }
            catch (Exception e) {
                log.error((Object)"Can't close connection.", (Throwable)e);
            }
        }
    }

    private void checkLocalDirectory(String destDir) throws Exception {
        File f = new File(destDir);
        if (!f.exists() && !f.mkdirs()) {
            throw new Exception("Cannot create local destination directory " + destDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTransfer() throws Exception {
        PipedOutputStream pipeOut = new PipedOutputStream();
        PipedInputStream pipeIn = new PipedInputStream(pipeOut);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            GSSCredential credential = new LocalCredentialHelper().getDefaultCredential();
            TwoPartyTarClientFactoryImpl clientFactory = new TwoPartyTarClientFactoryImpl();
            TwoPartyTarTransfer tptt = new TwoPartyTarTransfer((TwoPartyTarClientFactoryI)clientFactory, this.host, this.port, credential);
            if (tptt.isPopenDriverSupported()) {
                if (this.direction.equals("download")) {
                    this.checkLocalDirectory(this.destDir);
                    executorService.execute((Runnable)new UntarFromPipeRunnable((InputStream)pipeIn, this.destDir, (UntarI)new CompressUntar()));
                    tptt.downloadTarToPipe(this.sourceDir, (OutputStream)pipeOut);
                } else {
                    this.checkRemoteDirectory(this.destDir);
                    executorService.execute((Runnable)new TarToPipeRunnable(this.sourceDir, (OutputStream)pipeOut, (TarI)new CompressTar()));
                    tptt.uploadTarFromPipe(this.destDir, (InputStream)pipeIn, (OutputStream)pipeOut);
                }
            } else {
                log.error((Object)("Popen driver is not supported by the GridFTP server " + this.host + ":" + this.port));
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }
}

