/*
 * Decompiled with CFR 0.152.
 */
package org.birncommunity.gridftp.tar.impl.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.birncommunity.gridftp.tar.UntarI;
import org.birncommunity.util.MethodParameterChecker;

public class CompressUntar
implements UntarI {
    private Log log = LogFactory.getLog(CompressUntar.class);

    public static void main(String[] args) throws Exception {
        CompressUntar cut = new CompressUntar();
        cut.untarFromFile(new File("/tmp/testfile.tar"), new File("/tmp/testdir2"));
    }

    public void untarFromStream(InputStream is, File destDir) throws IOException {
        new MethodParameterChecker().verifyNotNull(new Object[]{is, destDir});
        this.checkDirectory(destDir);
        TarArchiveInputStream tais = new TarArchiveInputStream(is);
        TarArchiveEntry tae = null;
        try {
            while ((tae = tais.getNextTarEntry()) != null) {
                if (tae.isDirectory()) {
                    this.handleDirectoryEntry(tae, destDir);
                    continue;
                }
                this.handleFileEntry(tais, destDir, tae);
            }
            byte[] buff = new byte[512];
            while (is.read(buff) >= 0) {
            }
            tais.close();
        }
        catch (IOException e) {
            try {
                is.close();
            }
            catch (Exception e2) {
                this.log.warn((Object)"Failed to close input stream after previous error.", (Throwable)e2);
            }
            throw e;
        }
    }

    public void untarFromFile(File tarFile, File destDir) throws IOException {
        new MethodParameterChecker().verifyNotNull(new Object[]{tarFile, destDir});
        FileInputStream fis = new FileInputStream(tarFile);
        this.untarFromStream(fis, destDir);
    }

    private void handleDirectoryEntry(TarArchiveEntry tae, File destDir) throws IOException {
        File dir;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("processing tar entry " + tae.getName()));
        }
        if (!(dir = new File(destDir, tae.getName())).exists() && !dir.mkdirs()) {
            throw new IOException("Can't create " + dir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFileEntry(TarArchiveInputStream tais, File destDir, TarArchiveEntry tae) throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(destDir, tae.getName()));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("processing tar entry " + tae.getName()));
        }
        try {
            long entryLength = tae.getSize();
            int numRead = 0;
            long totalNumWritten = 0L;
            byte[] buffer = new byte[512];
            while ((numRead = tais.read(buffer)) >= 0) {
                fos.write(buffer, 0, numRead);
                totalNumWritten += (long)numRead;
            }
            if (totalNumWritten != entryLength) {
                throw new IOException("Unable to write file " + tae.getName() + " completely");
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    private void checkDirectory(File dir) throws IOException {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new IOException(dir.getAbsolutePath() + " is not a directory.");
            }
            if (!dir.canWrite()) {
                throw new IOException(dir.getAbsolutePath() + " cannot be written.");
            }
        } else {
            throw new IOException(dir.getAbsolutePath() + " does not exist.");
        }
    }
}

