/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirn.utilities.db;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nbirn.fbirn.utilities.db.LogStatement;

public class LogPreparedStatement
extends LogStatement
implements PreparedStatement {
    private Logger _logger;
    private PreparedStatement _stmt;
    private String _ID;
    private String _sql;
    private List<List<Object>> _paramBatches;

    public LogPreparedStatement(String sql, PreparedStatement stmt, String ID, Logger logger) {
        super(stmt, ID, logger);
        this._sql = sql;
        this._stmt = stmt;
        this._ID = ID;
        this._logger = logger;
        this._paramBatches = new ArrayList<List<Object>>();
        this._paramBatches.add(new ArrayList());
    }

    private void setParam(int parameterIndex, Object obj) {
        int numParams;
        List<Object> _params = this._paramBatches.get(this._paramBatches.size() - 1);
        for (int i = numParams = _params.size(); i < parameterIndex - 1; ++i) {
            _params.add(null);
            ++numParams;
        }
        if (numParams == parameterIndex - 1) {
            _params.add(obj);
        } else {
            _params.set(parameterIndex - 1, obj);
        }
    }

    private void logInterpolatedStatement(String methodName) throws SQLException {
        ParameterMetaData meta = this._stmt.getParameterMetaData();
        int numParams = meta.getParameterCount();
        StringBuilder sb = new StringBuilder("[" + this._ID + "] ");
        for (List<Object> params : this._paramBatches) {
            if (numParams != params.size()) {
                this._logger.log(Level.WARNING, "Number of logged params does not match that in prepared statement -- not logging interpolated query for: {0}", this._sql);
                return;
            }
            int curind = 0;
            for (int i = 0; i < numParams; ++i) {
                int qind = this._sql.indexOf(63, curind);
                if (qind == -1) {
                    this._logger.log(Level.WARNING, "Can''t find placeholder for param {0} in query.  Not logging interpolated query for: {1}", new Object[]{i + 1, this._sql});
                    return;
                }
                sb.append(this._sql.substring(curind, qind));
                Object param = params.get(i);
                if (param == null) {
                    sb.append("<null>");
                } else if (param instanceof String) {
                    sb.append("'").append(((String)param).replace("'", "\\'")).append("'");
                } else {
                    sb.append(param.toString());
                }
                curind = qind + 1;
            }
            sb.append(this._sql.substring(curind));
            this._logger.log(Level.FINE, "{0}: {1}", new Object[]{methodName, sb.toString()});
        }
    }

    public ResultSet executeQuery() throws SQLException {
        this.logInterpolatedStatement("executeQuery");
        return this._stmt.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        this.logInterpolatedStatement("executeUpdate");
        return this._stmt.executeUpdate();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParam(parameterIndex, new NullObj(sqlType));
        this._stmt.setNull(parameterIndex, sqlType);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setByte(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setShort(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setLong(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParam(parameterIndex, Float.valueOf(x));
        this._stmt.setFloat(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setDouble(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setBigDecimal(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setString(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setBytes(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setTimestamp(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setAsciiStream(parameterIndex, x, length);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setUnicodeStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setBinaryStream(parameterIndex, x, length);
    }

    public void clearParameters() throws SQLException {
        this._paramBatches.clear();
        this._stmt.clearParameters();
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setObject(parameterIndex, x);
    }

    public boolean execute() throws SQLException {
        this.logInterpolatedStatement("execute");
        return this._stmt.execute();
    }

    public void addBatch() throws SQLException {
        this._paramBatches.add(new ArrayList());
        this._stmt.addBatch();
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setParam(parameterIndex, reader);
        this._stmt.setCharacterStream(parameterIndex, reader, length);
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setRef(parameterIndex, x);
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setBlob(parameterIndex, x);
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setClob(parameterIndex, x);
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setArray(parameterIndex, x);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this._stmt.getMetaData();
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setDate(parameterIndex, x, cal);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setTimestamp(parameterIndex, x, cal);
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParam(parameterIndex, new NullObj(sqlType));
        this._stmt.setNull(parameterIndex, sqlType, typeName);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setURL(parameterIndex, x);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this._stmt.getParameterMetaData();
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setRowId(parameterIndex, x);
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setParam(parameterIndex, value);
        this._stmt.setNString(parameterIndex, value);
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setParam(parameterIndex, value);
        this._stmt.setNCharacterStream(parameterIndex, value, length);
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setParam(parameterIndex, value);
        this._stmt.setNClob(parameterIndex, value);
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setParam(parameterIndex, reader);
        this._stmt.setClob(parameterIndex, reader, length);
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setParam(parameterIndex, inputStream);
        this._stmt.setBlob(parameterIndex, inputStream, length);
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setParam(parameterIndex, reader);
        this._stmt.setNClob(parameterIndex, reader, length);
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.setParam(parameterIndex, xmlObject);
        this._stmt.setSQLXML(parameterIndex, xmlObject);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setAsciiStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setBinaryStream(parameterIndex, x, length);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setParam(parameterIndex, reader);
        this._stmt.setCharacterStream(parameterIndex, reader, length);
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setAsciiStream(parameterIndex, x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setParam(parameterIndex, x);
        this._stmt.setBinaryStream(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setParam(parameterIndex, reader);
        this._stmt.setCharacterStream(parameterIndex, reader);
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setParam(parameterIndex, value);
        this._stmt.setNCharacterStream(parameterIndex, value);
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setParam(parameterIndex, reader);
        this._stmt.setClob(parameterIndex, reader);
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setParam(parameterIndex, inputStream);
        this._stmt.setBlob(parameterIndex, inputStream);
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setParam(parameterIndex, reader);
        this._stmt.setNClob(parameterIndex, reader);
    }

    private class NullObj {
        private final int sqlType;

        NullObj(int sqlType_) {
            this.sqlType = sqlType_;
        }

        public String toString() {
            return "NullObj{sqlType=" + this.sqlType + '}';
        }
    }
}

