/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirn.utilities.download;

import java.awt.Component;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.nbirn.fbirn.utilities.CanceledException;
import org.nbirn.fbirn.utilities.CredentialManager;
import org.nbirn.fbirn.utilities.download.DownloadException;
import org.nbirn.fbirn.utilities.download.WorkerDownload;
import org.nbirn.fbirn.xcede2.catalog.Catalog;

public class WorkerDownloadFromURL
extends WorkerDownload {
    private static final Logger logger = Logger.getLogger(WorkerDownloadFromURL.class.getName());
    private Catalog _topcatalog = null;
    private URI _url = null;
    private File _destFile = null;
    private OutputStream _destStream = null;
    private Component _parent = null;
    private CredentialManager _credman = null;
    private boolean _updateonly = false;
    private TimeZone _timezone = null;
    private int _timeStampCheckDepth = 0;

    public WorkerDownloadFromURL(URI url, File destFile, CredentialManager credman) {
        super(false);
        this._url = url;
        this._destFile = destFile;
        this._credman = credman;
        this._updateonly = false;
        this._timezone = null;
        this._timeStampCheckDepth = 0;
    }

    public WorkerDownloadFromURL(URI url, File destFile, CredentialManager credman, boolean updateonly, boolean dryRun, TimeZone remoteTimeZone, int timeStampCheckDepth) {
        super(dryRun);
        this._url = url;
        this._destFile = destFile;
        this._credman = credman;
        this._updateonly = updateonly;
        this._timezone = remoteTimeZone;
        this._timeStampCheckDepth = timeStampCheckDepth;
    }

    public WorkerDownloadFromURL(URI url, OutputStream destStream, CredentialManager credman) {
        super(false);
        this._url = url;
        this._destStream = destStream;
        this._credman = credman;
        this._updateonly = false;
        this._timezone = null;
        this._timeStampCheckDepth = 0;
    }

    public WorkerDownloadFromURL(URI url, OutputStream destStream, CredentialManager credman, boolean updateonly, boolean dryRun, TimeZone remoteTimeZone, int timeStampCheckDepth) {
        super(dryRun);
        this._url = url;
        this._destStream = destStream;
        this._credman = credman;
        this._updateonly = updateonly;
        this._timezone = remoteTimeZone;
        this._timeStampCheckDepth = timeStampCheckDepth;
    }

    public Void doInBackground() throws CanceledException, DownloadException {
        this.setProgress(0);
        if (this._url.getScheme() != null && this._url.getScheme().equals("gsiftp")) {
            if (this._destFile != null) {
                this.downloadURLGSIFTP(this._url, this._destFile, this._credman, this._updateonly, this._timezone, this._timeStampCheckDepth);
            } else {
                this.downloadURLGSIFTP(this._url, this._destStream, this._credman, this._updateonly, this._timezone, this._timeStampCheckDepth);
            }
        } else if (this._destFile != null) {
            this.downloadURLDefault(this._url, this._destFile);
        } else {
            this.downloadURLDefault(this._url, this._destStream);
        }
        return null;
    }

    public void done() {
        this.cleanup(false);
    }
}

