/*
 * Decompiled with CFR 0.152.
 */
package backend;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.TagFromName;
import java.util.HashMap;
import java.util.Map;

public class DICOMFileHandling {
    private DicomDictionary myLocalDictionary;
    private AttributeList listS = new AttributeList();
    private Map<String, Integer> studyHash = new HashMap<String, Integer>();
    private int studyHashNumber = 0;
    private String[] orderedStudy = new String[5];
    private String[] studyDescription = new String[5];
    private String[] studyDate = new String[5];
    private Map<String, Integer> seriesHash = new HashMap<String, Integer>();
    private int seriesHashNumber = 0;
    private int[] seriesNumberInStudy = new int[]{0, 0, 0, 0, 0};
    private String[] orderedSeries = new String[30];
    private String[] seriesDescription = new String[30];
    private String[] seriesDate = new String[30];
    private int[][] seriesFileNumber = new int[5][30];
    private String[][][][] orderedFile = new String[5][30][64][500];
    private Map<String, Integer> parameterHash = new HashMap<String, Integer>();
    private int[][] paramHashNumber = new int[5][30];
    private int[][][] parameterFileNumber = new int[5][30][64];
    private Integer[][][] flipAngle = new Integer[5][30][64];
    private Integer[][][] excitationTime = new Integer[5][30][64];
    private Integer[][][] repititionTime = new Integer[5][30][64];
    private String[] dicom;
    private int dicomNumber = 0;

    public DICOMFileHandling(String[] dicomFileName, int no_of_files) {
        this.dicom = dicomFileName;
        this.dicomNumber = no_of_files;
        this.SortbyStudyNSeries();
    }

    public void SortbyStudyNSeries() {
        try {
            for (int i = 0; i < this.dicomNumber; ++i) {
                String[] temp;
                Integer studyNo = new Integer(-1);
                Integer seriesNo = new Integer(-1);
                Integer parameterNo = new Integer(-1);
                this.listS.read(this.dicom[i]);
                String studyUID = Attribute.getDelimitedStringValuesOrEmptyString(this.listS, TagFromName.StudyInstanceUID);
                if (this.studyHash.containsKey(studyUID)) {
                    studyNo = new Integer(this.studyHash.get(studyUID).toString());
                } else {
                    studyNo = new Integer(this.studyHashNumber++);
                    this.studyHash.put(studyUID, studyNo);
                    this.InsertinOrder(studyUID, this.orderedStudy, this.studyHashNumber - 2);
                    this.studyDescription[studyNo.intValue()] = Attribute.getDelimitedStringValuesOrEmptyString(this.listS, TagFromName.StudyDescription);
                    this.studyDate[studyNo.intValue()] = Attribute.getDelimitedStringValuesOrEmptyString(this.listS, TagFromName.StudyDate);
                }
                String seriesUID = Attribute.getDelimitedStringValuesOrEmptyString(this.listS, TagFromName.SeriesInstanceUID);
                if (this.seriesHash.containsKey(seriesUID)) {
                    seriesNo = new Integer(this.seriesHash.get(seriesUID).toString());
                } else {
                    int n = studyNo;
                    this.seriesNumberInStudy[n] = this.seriesNumberInStudy[n] + 1;
                    seriesNo = new Integer(this.seriesHashNumber++);
                    this.seriesDescription[seriesNo.intValue()] = Attribute.getDelimitedStringValuesOrEmptyString(this.listS, TagFromName.SeriesDescription);
                    this.seriesDate[seriesNo.intValue()] = Attribute.getDelimitedStringValuesOrEmptyString(this.listS, TagFromName.SeriesDate);
                    this.seriesHash.put(seriesUID, seriesNo);
                    this.InsertinOrder(seriesUID, this.orderedSeries, this.seriesHashNumber - 2);
                }
                AttributeTag flipA = new AttributeTag(24, 4884);
                AttributeTag ET = new AttributeTag(24, 128);
                AttributeTag RT = new AttributeTag(24, 129);
                String param = "" + Attribute.getSingleIntegerValueOrDefault(this.listS, flipA, -1) + " " + Attribute.getSingleIntegerValueOrDefault(this.listS, ET, -1) + " " + Attribute.getSingleIntegerValueOrDefault(this.listS, RT, -1);
                if (this.parameterHash.containsKey(param)) {
                    parameterNo = new Integer(this.parameterHash.get(param).toString());
                    if (this.flipAngle[studyNo][seriesNo][parameterNo] == null) {
                        temp = param.split(" ");
                        this.flipAngle[studyNo.intValue()][seriesNo.intValue()][parameterNo.intValue()] = new Integer(temp[0]);
                        this.excitationTime[studyNo.intValue()][seriesNo.intValue()][parameterNo.intValue()] = new Integer(temp[1]);
                        this.repititionTime[studyNo.intValue()][seriesNo.intValue()][parameterNo.intValue()] = new Integer(temp[2]);
                    }
                } else {
                    int[] nArray = this.paramHashNumber[studyNo];
                    int n = seriesNo;
                    int n2 = nArray[n];
                    nArray[n] = n2 + 1;
                    parameterNo = new Integer(n2);
                    this.parameterHash.put(param, parameterNo);
                    temp = param.split(" ");
                    this.flipAngle[studyNo.intValue()][seriesNo.intValue()][parameterNo.intValue()] = new Integer(temp[0]);
                    this.excitationTime[studyNo.intValue()][seriesNo.intValue()][parameterNo.intValue()] = new Integer(temp[1]);
                    this.repititionTime[studyNo.intValue()][seriesNo.intValue()][parameterNo.intValue()] = new Integer(temp[2]);
                }
                int[] nArray = this.seriesFileNumber[studyNo];
                int n = seriesNo;
                nArray[n] = nArray[n] + 1;
                int[] nArray2 = this.parameterFileNumber[studyNo][seriesNo];
                int n3 = parameterNo;
                nArray2[n3] = nArray2[n3] + 1;
                temp = this.dicom[i].split("/");
                this.InsertinOrder(temp[temp.length - 1], this.orderedFile[studyNo][seriesNo][parameterNo], this.parameterFileNumber[studyNo][seriesNo][parameterNo] - 2);
            }
        }
        catch (Exception e) {
            System.out.println("* Error in SortbyStudyNSeries::" + this.dicom[0] + "::" + e);
        }
    }

    void InsertinOrder(String key, String[] target, int i) {
        try {
            if (target[0] == null) {
                target[0] = key;
            } else {
                while (i > -1 && this.CompareString(key, target[i])) {
                    target[i + 1] = target[i];
                    --i;
                }
                target[i + 1] = key;
            }
        }
        catch (Exception e) {
            System.out.println("* Error with InsertinOrder with " + key + " :: " + e);
        }
    }

    public void Print_orderedResult() {
        try {
            int a = 0;
            System.out.println("Number of Studies::" + this.studyHashNumber);
            System.out.println("*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*");
            while (this.orderedStudy[a] != null) {
                int b = 0;
                System.out.println("Study::" + this.orderedStudy[a]);
                System.out.print("(StudyDescription:\"" + this.studyDescription[a]);
                System.out.print("\" Study date: " + this.studyDate[a].substring(0, 4) + "-" + this.studyDate[a].substring(4, 6) + "-" + this.studyDate[a].substring(6));
                System.out.println(" Number of Series:" + this.seriesNumberInStudy[a] + ")");
                Integer study = new Integer(this.studyHash.get(this.orderedStudy[a]).toString());
                while (this.orderedSeries[b] != null) {
                    int param = 0;
                    Integer series = new Integer(this.seriesHash.get(this.orderedSeries[b]).toString());
                    System.out.println("-------Series::" + this.orderedSeries[b]);
                    System.out.print("-------(SereisDescription: \"" + this.seriesDescription[b]);
                    System.out.print("\" Series date: " + this.seriesDate[b].substring(0, 4) + "-" + this.seriesDate[b].substring(4, 6) + "-" + this.seriesDate[b].substring(6));
                    System.out.println(" Number of Files: " + this.seriesFileNumber[study][series] + ")");
                    while (this.excitationTime[study][series][param] != null) {
                        int d = 0;
                        System.out.print("------------Scan Parameter: FlipAngel: " + this.flipAngle[study][series][param]);
                        System.out.print(" Excitation time: " + this.excitationTime[study][series][param]);
                        System.out.println(" Repitition time: " + this.repititionTime[study][series][param]);
                        while (this.orderedFile[study][series][param][d] != null) {
                            System.out.println("---------------------------" + this.orderedFile[study][series][param][d]);
                            ++d;
                        }
                        ++param;
                    }
                    ++b;
                }
                ++a;
            }
        }
        catch (Exception e) {
            System.out.println("* error in Print ::" + e);
        }
    }

    boolean CompareString(String s1, String s2) {
        try {
            if (s1.endsWith("dcm")) {
                Integer s11 = new Integer(s1.substring(8, 12));
                Integer s22 = new Integer(s2.substring(8, 12));
                return s11 <= s22;
            }
            Long s11 = new Long(s1.substring(37));
            Long s22 = new Long(s2.substring(37));
            return s11.intValue() <= s22.intValue();
        }
        catch (Exception e) {
            System.out.println("* Error with CompareString::" + e);
            return true;
        }
    }
}

