/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.SigningPolicy;
import org.globus.gsi.SigningPolicyParserException;
import org.globus.util.I18n;

public class SigningPolicyParser {
    private static I18n i18n = I18n.getI18n("org.globus.gsi.errors", SigningPolicyParser.class.getClassLoader());
    private static Log logger = LogFactory.getLog(SigningPolicyParser.class.getName());
    public static String ACCESS_ID_PREFIX = "access_id_";
    public static String ACCESS_ID_CA = "access_id_CA";
    public static String DEF_AUTH_X509 = "X509";
    public static String DEF_AUTH_GLOBUS = "globus";
    public static String POS_RIGHTS = "pos_rights";
    public static String NEG_RIGHTS = "neg_rights";
    public static String CONDITION_PREFIX = "cond_";
    public static String CONDITION_SUBJECT = "cond_subjects";
    public static String VALUE_CA_SIGN = "CA:sign";
    public static String SINGLE_CHAR = "?";
    public static String WILDCARD = "*";
    public static String SINGLE_PATTERN = "[\\p{Print}\\p{Blank}]";
    public static String WILDCARD_PATTERN = SINGLE_PATTERN + "*";
    private static final char[] EMAIL_KEYWORD_1 = new char[]{'E', '='};
    private static final char[] EMAIL_KEYWORD_2 = new char[]{'E', 'm', 'a', 'i', 'l', '='};
    private static final String EMAIL_KEYWORD = "emailAddress=";

    public static SigningPolicy getPolicy(String fileName, String requiredCaDN) throws SigningPolicyParserException {
        if (fileName == null || fileName.trim().equals("")) {
            throw new IllegalArgumentException();
        }
        logger.debug("Signing policy file name " + fileName + " with CA DN " + requiredCaDN);
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(fileName);
        }
        catch (FileNotFoundException exp) {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw new SigningPolicyParserException(exp.getMessage(), exp);
        }
        SigningPolicy policy = SigningPolicyParser.getPolicy(fileReader, requiredCaDN);
        policy.setFileName(fileName);
        logger.debug("Policy file parsing completed, policy is " + (policy == null));
        return policy;
    }

    public static SigningPolicy getPolicy(Reader reader, String requiredCaDN) throws SigningPolicyParserException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line = bufferedReader.readLine();
            block12: while (line != null) {
                if (!SigningPolicyParser.isValidLine(line = line.trim())) {
                    line = bufferedReader.readLine();
                    continue;
                }
                logger.trace("Line to parse: " + line);
                String caDN = null;
                if (line.startsWith(ACCESS_ID_PREFIX)) {
                    logger.trace("Check if it is CA and get the DN " + line);
                    if (line.startsWith(ACCESS_ID_CA)) {
                        caDN = SigningPolicyParser.getCA(line.substring(ACCESS_ID_CA.length(), line.length()));
                        logger.trace("CA DN is " + caDN);
                    }
                    boolean usefulEntry = false;
                    if (caDN != null && SigningPolicyParser.equalsDN(caDN, requiredCaDN)) {
                        usefulEntry = true;
                        logger.trace("CA DN match " + caDN);
                    }
                    Boolean posNegRights = null;
                    while ((line = bufferedReader.readLine()) != null) {
                        int endIndex;
                        int startIndex;
                        if (!SigningPolicyParser.isValidLine(line)) continue;
                        line = line.trim();
                        logger.trace("Line is " + line);
                        if (line.startsWith(POS_RIGHTS)) {
                            if (Boolean.FALSE.equals(posNegRights)) {
                                String err = i18n.getMessage("invalidPosRights", line);
                                throw new SigningPolicyParserException(err);
                            }
                            posNegRights = Boolean.TRUE;
                            if (!usefulEntry) continue;
                            logger.trace("Parse pos_rights here");
                            startIndex = POS_RIGHTS.length();
                            endIndex = line.length();
                            usefulEntry = SigningPolicyParser.isCASignRight(line.substring(startIndex, endIndex));
                            continue;
                        }
                        if (line.startsWith(NEG_RIGHTS)) {
                            if (Boolean.TRUE.equals(posNegRights)) {
                                String err = i18n.getMessage("invalidNegRights", line);
                                throw new SigningPolicyParserException(err);
                            }
                            posNegRights = Boolean.FALSE;
                            logger.trace("Ignore neg_rights");
                            continue;
                        }
                        if (line.startsWith(CONDITION_PREFIX)) {
                            SigningPolicy policy;
                            if (!Boolean.TRUE.equals(posNegRights)) {
                                String err = i18n.getMessage("invalidRestrictions", line);
                                throw new SigningPolicyParserException(err);
                            }
                            if (!usefulEntry || !line.startsWith(CONDITION_SUBJECT)) continue;
                            logger.trace("Read in subject condition.");
                            startIndex = CONDITION_SUBJECT.length();
                            endIndex = line.length();
                            Vector allowedDNs = SigningPolicyParser.getAllowedDNs(line.substring(startIndex, endIndex), line);
                            SigningPolicy signingPolicy = policy = new SigningPolicy(requiredCaDN, allowedDNs);
                            return signingPolicy;
                        }
                        if (line.startsWith(ACCESS_ID_PREFIX)) continue block12;
                        String err = i18n.getMessage("invalidLine", line);
                        throw new SigningPolicyParserException(err);
                    }
                    continue;
                }
                String err = i18n.getMessage("invalidAccessId", line);
                throw new SigningPolicyParserException(err);
            }
        }
        catch (IOException exp) {
            throw new SigningPolicyParserException("", exp);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exp) {}
        }
        return new SigningPolicy(requiredCaDN);
    }

    private static boolean isValidLine(String line) throws SigningPolicyParserException {
        if ((line = line.trim()).equals("") || line.startsWith("#")) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(line);
        if (tokenizer.countTokens() < 3) {
            String err = i18n.getMessage("invalidTokens", line);
            throw new SigningPolicyParserException(err);
        }
        return true;
    }

    private static Vector getAllowedDNs(String line, String lineForErr) throws SigningPolicyParserException {
        int index = SigningPolicyParser.findIndex(line = line.trim());
        if (index == -1) {
            String err = i18n.getMessage("invalidTokens", line);
            throw new SigningPolicyParserException(err);
        }
        String defAuth = line.substring(0, index);
        if (DEF_AUTH_GLOBUS.equals(defAuth)) {
            String value = line.substring(index + 1, line.length());
            value = value.trim();
            int startIndex = 0;
            int endIndex = value.length();
            if (value.charAt(startIndex) == '\'') {
                int endOfDNIndex;
                if ((endOfDNIndex = value.indexOf(39, ++startIndex)) == -1) {
                    String err = i18n.getMessage("invalidSubjects", lineForErr);
                    throw new SigningPolicyParserException(err);
                }
                endIndex = endOfDNIndex;
            }
            value = value.substring(startIndex, endIndex);
            if ((value = value.trim()).equals("")) {
                String err = i18n.getMessage("emptySubjects", lineForErr);
                throw new SigningPolicyParserException(err);
            }
            Vector<Pattern> vector = new Vector<Pattern>();
            startIndex = 0;
            endIndex = value.length();
            if (value.indexOf("\"") == -1) {
                vector.add(SigningPolicyParser.getPattern(value));
            } else {
                while (startIndex < endIndex) {
                    int quot1 = value.indexOf("\"", startIndex);
                    int quot2 = value.indexOf("\"", quot1 + 1);
                    if (quot2 == -1) {
                        String err = i18n.getMessage("unmatchedQuotes", lineForErr);
                        throw new SigningPolicyParserException(err);
                    }
                    String token = value.substring(quot1 + 1, quot2);
                    vector.add(SigningPolicyParser.getPattern(token));
                    startIndex = quot2 + 1;
                }
            }
            return vector;
        }
        return null;
    }

    private static boolean isCASignRight(String line) throws SigningPolicyParserException {
        int index = SigningPolicyParser.findIndex(line = line.trim());
        if (index == -1) {
            String err = i18n.getMessage("invalidTokens", line);
            throw new SigningPolicyParserException(err);
        }
        String def_auth = line.substring(0, index);
        if (DEF_AUTH_GLOBUS.equals(def_auth)) {
            line = line.substring(index + 1, line.length());
            String value = (line = line.trim()).substring(0, line.length());
            if (VALUE_CA_SIGN.equals(value)) {
                return true;
            }
        }
        return false;
    }

    private static String getCA(String inputLine) throws SigningPolicyParserException {
        String line = inputLine.trim();
        int index = SigningPolicyParser.findIndex(line);
        if (index == -1) {
            String err = i18n.getMessage("invalidTokens", line);
            throw new SigningPolicyParserException(err);
        }
        String defAuth = line.substring(0, index);
        if (DEF_AUTH_X509.equals(defAuth)) {
            line = line.substring(index + 1, line.length());
            line = line.trim();
            String dnString = line.substring(0, line.length());
            String caDN = null;
            int caDNLocation = 0;
            if (line.charAt(caDNLocation) == '\'') {
                int endofDNIndex;
                if ((endofDNIndex = line.indexOf(39, ++caDNLocation + 1)) == -1) {
                    String err = i18n.getMessage("invalidCaDN", inputLine);
                    throw new SigningPolicyParserException(err);
                }
                caDN = line.substring(caDNLocation, endofDNIndex);
            } else {
                caDN = line.substring(caDNLocation, line.length() - 1);
            }
            caDN = caDN.trim();
            return caDN;
        }
        return null;
    }

    public static Pattern getPattern(String patternStr) {
        String preStr;
        if (patternStr == null) {
            throw new IllegalArgumentException();
        }
        int startIndex = 0;
        int endIndex = patternStr.length();
        StringBuffer buffer = new StringBuffer("");
        while (startIndex < endIndex) {
            int star = patternStr.indexOf(WILDCARD, startIndex);
            if (star == -1) {
                star = endIndex;
                preStr = patternStr.substring(startIndex, star);
                buffer = buffer.append(preStr);
            } else {
                preStr = patternStr.substring(startIndex, star);
                buffer = buffer.append(preStr).append(WILDCARD_PATTERN);
            }
            startIndex = star + 1;
        }
        patternStr = buffer.toString();
        startIndex = 0;
        endIndex = patternStr.length();
        buffer = new StringBuffer("");
        while (startIndex < endIndex) {
            int qMark = patternStr.indexOf(SINGLE_CHAR, startIndex);
            if (qMark == -1) {
                qMark = endIndex;
                preStr = patternStr.substring(startIndex, qMark);
                buffer = buffer.append(preStr);
            } else {
                preStr = patternStr.substring(startIndex, qMark);
                buffer = buffer.append(preStr).append(SINGLE_PATTERN);
            }
            startIndex = qMark + 1;
        }
        patternStr = buffer.toString();
        logger.debug("String with replaced pattern is " + patternStr);
        return Pattern.compile(patternStr, 2);
    }

    private static int findIndex(String line) {
        int index = -1;
        if (line == null) {
            return index;
        }
        line = line.trim();
        int spaceIndex = line.indexOf(" ");
        int tabIndex = line.indexOf("\t");
        index = spaceIndex != -1 ? (tabIndex != -1 ? (spaceIndex < tabIndex ? spaceIndex : tabIndex) : spaceIndex) : tabIndex;
        return index;
    }

    public static boolean equalsDN(String dn1, String dn2) {
        if (dn1 == null && dn2 == null) {
            return true;
        }
        if (dn1 == null || dn2 == null) {
            return false;
        }
        return SigningPolicyParser.normalizeDN(dn1).equals(SigningPolicyParser.normalizeDN(dn2));
    }

    private static boolean keyWordPresent(char[] args, int startIndex, char[] keyword) {
        if (startIndex + keyword.length > args.length) {
            return false;
        }
        int i = 0;
        int j = startIndex;
        while (i < keyword.length) {
            if (args[j] != keyword[i]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static String normalizeDN(String globusID) {
        if (globusID == null) {
            return null;
        }
        char[] globusIdChars = globusID.toCharArray();
        StringBuffer normalizedDN = new StringBuffer(globusIdChars.length);
        for (int i = 0; i < globusIdChars.length; ++i) {
            if (globusIdChars[i] == '/') {
                normalizedDN.append("/");
                if (SigningPolicyParser.keyWordPresent(globusIdChars, i + 1, EMAIL_KEYWORD_1)) {
                    normalizedDN.append(EMAIL_KEYWORD);
                    i += EMAIL_KEYWORD_1.length;
                    continue;
                }
                if (!SigningPolicyParser.keyWordPresent(globusIdChars, i + 1, EMAIL_KEYWORD_2)) continue;
                normalizedDN.append(EMAIL_KEYWORD);
                i += EMAIL_KEYWORD_2.length;
                continue;
            }
            normalizedDN.append(globusIdChars[i]);
        }
        return normalizedDN.toString();
    }
}

