/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.net.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.globus.gsi.gssapi.SSLUtil;
import org.globus.gsi.gssapi.net.GssOutputStream;
import org.ietf.jgss.GSSContext;

public class GSIGssOutputStream
extends GssOutputStream {
    protected byte[] header = new byte[4];
    protected int mode;

    public GSIGssOutputStream(OutputStream out, GSSContext context) {
        this(out, context, 1);
    }

    public GSIGssOutputStream(OutputStream out, GSSContext context, int mode) {
        super(out, context);
        this.setWrapMode(mode);
    }

    @Override
    public void flush() throws IOException {
        if (this.index == 0) {
            return;
        }
        this.writeToken(this.wrap());
        this.index = 0;
    }

    public void setWrapMode(int mode) {
        this.mode = mode;
    }

    public int getWrapMode() {
        return this.mode;
    }

    public void writeToken(byte[] token) throws IOException {
        if (this.mode == 2) {
            SSLUtil.writeInt(token.length, this.header, 0);
            this.out.write(this.header);
        }
        this.out.write(token);
        this.out.flush();
    }
}

