import os.path
import shutil
import tempfile
import re
import xml.dom.minidom
import gzip

from UploadClasses import _Constants

class SeriesDataDirectory:
    def __init__(self, path, type=None, example_file=None, ignore_types=[]):
        Constants = _Constants()

        ignore_types_dict = {}
        for typestr in ignore_types:
            ignore_types_dict[typestr] = 1
        
        self.metadata={}
        self.path=path
        self.types = []
        if type != None:
            self.types.append(type)
        self.example_files = []
        if example_file != None:
            self.example_files.append(example_file)
        elif type != None:
            self.example_files.append(None)
        if not os.path.isdir(path):
            raise IOError('"' + path + '" is not a directory!\n')
        if example_file==None:
            filelist = os.listdir(path)
	    filelist.sort()
            for file in filelist:
                if len(filter(lambda x: file[-len(x):]==x, [".dcm",".DCM",".IMA",".ima"]))>0 and Constants.m_DATASPEC_DICOM in self.types and self.example_files[self.types.index(Constants.m_DATASPEC_DICOM)] != None:
                    continue
                fullpath=os.path.join(path,file)
                try:
                    if fullpath[-3:] == ".gz":
                        f=gzip.open(fullpath)
                    else:
                        f=open(fullpath,"r")
                except IOError:
                    continue
                f.seek(128)
                magic=f.read(4)
                if Constants.m_DATASPEC_DICOM not in ignore_types_dict and (magic=="DICM" or len(filter(lambda x: file[-len(x):]==x, [".dcm",".DCM",".IMA",".ima"]))>0):
                    if Constants.m_DATASPEC_DICOM not in self.types:
                        self.types.append(Constants.m_DATASPEC_DICOM)
                        self.example_files.append(None)
                    if Constants.m_DATASPEC_DICOM in self.types:
                        self.example_files[self.types.index(Constants.m_DATASPEC_DICOM)] = file
                        f.close()
                        continue
                f.seek(0)
                magic=f.read(4)
                if Constants.m_DATASPEC_SIGNA5 not in ignore_types_dict and (magic=="IMGF" and file!="SERHDR"):
                    if Constants.m_DATASPEC_SIGNA5 not in self.types:
                        self.types.append(Constants.m_DATASPEC_SIGNA5)
                        self.example_files.append(None)
                    if Constants.m_DATASPEC_SIGNA5 in self.types:
                        self.example_files[self.types.index(Constants.m_DATASPEC_SIGNA5)] = file
                        f.close()
                        continue
                if Constants.m_DATASPEC_MINC not in ignore_types_dict and magic[0:2]=="CDF":
                    if Constants.m_DATASPEC_MINC not in self.types:
                        self.types.append(Constants.m_DATASPEC_MINC)
                        self.example_files.append(None)
                    if Constants.m_DATASPEC_MINC in self.types:
                        self.example_files[self.types.index(Constants.m_DATASPEC_MINC)] = file
                        f.close()
                        continue
                if Constants.m_DATASPEC_ANALYZE not in ignore_types_dict and (file[-4:]==".hdr" and os.path.getsize(fullpath)==348):
                    if ((ord(magic[0]) == 0x00 and ord(magic[1]) == 0x00 and
                         ord(magic[2]) == 0x01 and ord(magic[3]) == 0x5C) or
                        (ord(magic[0]) == 0x5C and ord(magic[1]) == 0x01 and
                         ord(magic[2]) == 0x00 and ord(magic[3]) == 0x00)):
                        if Constants.m_DATASPEC_ANALYZE not in self.types:
                            self.types.append(Constants.m_DATASPEC_ANALYZE)
                            self.example_files.append(None)
                        if Constants.m_DATASPEC_ANALYZE in self.types:
                            self.example_files[self.types.index(Constants.m_DATASPEC_ANALYZE)] = file
                            f.close()
                            continue
                if Constants.m_DATASPEC_NIFTI not in ignore_types_dict and (file[-4:]==".nii" or file[-7:]==".nii.gz"):
                    if ((ord(magic[0]) == 0x00 and ord(magic[1]) == 0x00 and
                         ord(magic[2]) == 0x01 and ord(magic[3]) == 0x5C) or
                        (ord(magic[0]) == 0x5C and ord(magic[1]) == 0x01 and
                         ord(magic[2]) == 0x00 and ord(magic[3]) == 0x00)):
                        if Constants.m_DATASPEC_NIFTI not in self.types:
                            self.types.append(Constants.m_DATASPEC_NIFTI)
                            self.example_files.append(None)
                        if Constants.m_DATASPEC_NIFTI in self.types:
                            self.example_files[self.types.index(Constants.m_DATASPEC_NIFTI)] = file
                            f.close()
                            continue
                if Constants.m_DATASPEC_PFILE not in ignore_types_dict and (file[0:3]=='pfh' or file[-4:]==".pfh" or file[-3:]=="PFH" or re.match("^P.*\.7$", file) != None):
                    if Constants.m_DATASPEC_PFILE not in self.types:
                        self.types.append(Constants.m_DATASPEC_PFILE)
                        self.example_files.append(None)
                    if Constants.m_DATASPEC_PFILE in self.types:
                        self.example_files[self.types.index(Constants.m_DATASPEC_PFILE)] = file
                        f.close()
                        continue
                if Constants.m_DATASPEC_FFILE not in ignore_types_dict and re.match("^F.*\.7$", file) != None:
                    if Constants.m_DATASPEC_FFILE not in self.types:
                        self.types.append(Constants.m_DATASPEC_FFILE)
                        self.example_files.append(None)
                    if Constants.m_DATASPEC_FFILE in self.types:
                        self.example_files[self.types.index(Constants.m_DATASPEC_FFILE)] = file
                        f.close()
                        continue
                if Constants.m_DATASPEC_XCEDE not in ignore_types_dict and file[-4:]==".xml":
                    dom=xml.dom.minidom.parse(fullpath)
                    if dom.documentElement.localName=="serieslevel":
                        if Constants.m_DATASPEC_XCEDE not in self.types:
                            self.types.append(Constants.m_DATASPEC_XCEDE)
                            self.example_files.append(None)
                        if Constants.m_DATASPEC_XCEDE in self.types:
                            self.example_files[self.types.index(Constants.m_DATASPEC_XCEDE)] = file
                            f.close()
                            continue
                if Constants.m_DATASPEC_BXH not in ignore_types_dict and file[-4:]==".bxh":
                    dom=xml.dom.minidom.parse(fullpath)
                    if dom.documentElement.localName=="bxh":
                        if Constants.m_DATASPEC_BXH not in self.types:
                            self.types.append(Constants.m_DATASPEC_BXH)
                            self.example_files.append(None)
                        if Constants.m_DATASPEC_BXH in self.types:
                            self.example_files[self.types.index(Constants.m_DATASPEC_BXH)] = file
                            f.close()
                            continue
                if Constants.m_DATASPEC_AFNI not in ignore_types_dict and file[-5:]==".HEAD":
                    if Constants.m_DATASPEC_AFNI not in self.types:
                        self.types.append(Constants.m_DATASPEC_AFNI)
                        self.example_files.append(None)
                    if Constants.m_DATASPEC_AFNI in self.types:
                        self.example_files[self.types.index(Constants.m_DATASPEC_AFNI)] = file
                        f.close()
                        continue
                f.close()
        return
                
    def extract_data(self, type_order=[]):
        Constants = _Constants()

        if len(self.example_files) == 0:
            return
        (head,tail)=os.path.split(self.path)
        if len(tail)==0 and len(head)!=0:
            (head,tail)=os.path.split(head)
        self.metadata = {
            "nameLocal": tail,
            "nameStandard": None,
            "ID": None,
            "seriesDate": None,
            "seriesTime": None,
            "seriesNumber": None,
            "description": None,
            "type": None,
            "paradigm": None,
            "paradigmVersion": None,
            "number": None,
            "sliceorder": None,
            "discardAcq": None }
        # go through types in order listed by type_order
        typeindlist = []
        for type in type_order:
            try:
                typeind = self.types.index(type)
                typeindlist.append(typeind)
            except:
                pass
        # add any other types that weren't listed in type_order
        for typeind in range(len(self.types)):
            try:
                typeindlist.index(typeind)
            except:
                typeindlist.append(typeind)
        for typeind in typeindlist:
            type = self.types[typeind]
            example_file = self.example_files[typeind]
            tmpdir=tempfile.mkdtemp()
            tmpfile=os.path.join(tmpdir,"tmp.xml")
            retval=None
            p=None
            fullpath=os.path.join(self.path,example_file)
            executable=None
            if type==Constants.m_DATASPEC_DICOM:
                executable='dicom2bxh --xcede'
            elif type==Constants.m_DATASPEC_PFILE:
                executable='pfile2bxh --xcede'
            elif type==Constants.m_DATASPEC_FFILE:
                executable='ffile2bxh --xcede'
            elif type==Constants.m_DATASPEC_XCEDE:
                shutil.copy(fullpath, tmpfile)
            elif type==Constants.m_DATASPEC_ANALYZE:
                executable='analyze2bxh --xcede'
            elif type==Constants.m_DATASPEC_MINC:
                executable='minc2bxh --xcede'
            elif type==Constants.m_DATASPEC_SIGNA5:
                executable='signafive2bxh --xcede'
            elif type==Constants.m_DATASPEC_AFNI:
                executable='afni2bxh --xcede'
            elif type==Constants.m_DATASPEC_BXH:
                executable='bxh2bxh --xcede'
            elif type==Constants.m_DATASPEC_NIFTI:
                executable='analyze2bxh --xcede'
            else:
                raise ValueError('"' + self.type + '" is not a supported type!\n')
            if executable!=None:
                cmd=executable+' "'+fullpath+'" "'+tmpfile+'"'
                p=os.popen(cmd)
                retval=p.close()
                if retval!=None:
                    raise RuntimeError('Command failed: '+cmd+'\n')
            if not os.path.exists(tmpfile):
                continue
            dom=xml.dom.minidom.parse(tmpfile)
            os.unlink(tmpfile)
            os.rmdir(tmpdir)
            queue=[dom.documentElement]
            while len(queue)>0:
                curnode=queue[0]
                queue[0:1]=[]
                if curnode.nodeType==curnode.ELEMENT_NODE:
                    if curnode.localName=="acqParam":
                        nodevalue=''
                        curchildnode=curnode.firstChild
                        while curchildnode!=None:
                            if curchildnode.nodeType==curchildnode.TEXT_NODE:
                                nodevalue=nodevalue+curchildnode.nodeValue
                            curchildnode=curchildnode.nextSibling
                        if curnode.getAttribute("name")=="scandate":
                            self.metadata["seriesDate"]=nodevalue
                        if curnode.getAttribute("name")=="scantime":
                            self.metadata["seriesTime"]=nodevalue
                        if curnode.getAttribute("name")=="sliceorder":
                            self.metadata["sliceorder"]=nodevalue
                        if curnode.getAttribute("name")=="seriesnumber":
                            self.metadata["seriesNumber"]=nodevalue
                    curchildnode=curnode.firstChild
                    while curchildnode!=None:
                        if curchildnode.nodeType==curchildnode.ELEMENT_NODE:
                            queue.append(curchildnode)
                        curchildnode=curchildnode.nextSibling
