#!/usr/bin/python2
# Helper functions for Upload.py

import logging
import math
import os
import re
import shutil
import stat
import string
import sys
import tempfile
import time
import xml
import xml.dom.ext.Printer
import xml.xpath
from xml.dom.ext.reader import Sax2
#from StringIO import StringIO

################################################################################
# Similar to the unix dirname command.
################################################################################
def dirname(path):
  if os.path.isfile(path):
    return os.path.dirname(path)
  else:
    return os.path.dirname(path+"/")
  

################################################################################
# Execute a shell command and return both the ret value and the output.
################################################################################
def run_cmd(command, quiet=False):
  if not quiet:
    logging.info("Running: " + command)
  p = os.popen(command)
  data = p.read()
  ret = 999
  try:
    ret = p.close()
  except IOError:
    pass
  if ret == None:
    ret = 0
  return ret, data


################################################################################
# Like the unix grep command, except always uses regex.
################################################################################
def grep(file, string):
  fp = open(file,"r")
  lines = fp.readlines()
  ret = []
  for line in lines:
    if re.match(string, line):
      ret.append(line)
  return ret


################################################################################
# Like the unix which command.
################################################################################
def which(e):
  path = os.environ["PATH"]
  dirs = path.split(":")
  for dir in dirs:
    files = []
    try:
      files = os.listdir(dir)
    except OSError:
      pass
    for file in files:
      if e == file:
        if os.path.isfile(dir + "/" + file):
          return dir + "/" + file
  return None


###############################################################################
# Splits a string into tokens, respecting quotes.
###############################################################################
def tokenize_string(s):
  pattern = re.compile(r'"(.*?)"|(\S+)')
  return [b or a for a, b in pattern.findall(s)]          


###############################################################################
# Splits a string into tokens, respecting quotes and converting types.
###############################################################################
def tokenize_string2(s):
  pattern = re.compile(r'(".*?")|(\S+)')
  ret = [b or a for a, b in pattern.findall(s)]
  ret2 = []
  for entry in ret:
    if entry[0] == '"' and entry[-1] == '"':
      ret2.append(entry[1:-1])
    elif entry.find(".") != -1:
      ret2.append(string.atof(entry))
    else:
      ret2.append(string.atoi(entry))
  return ret2


################################################################################
# Checks for a yes or no answer to a prompt.
################################################################################
def read_yn(str = None, default = None):
  if str != None:
    print str,
  yn = None
  while yn == None or yn == '\n':
    try:
      yn=sys.stdin.readline()
    except IOError, e:
      if default != None:
        yn = default
	print "(using default: " + default + ")"
        break
      else:
        raise e
  if yn == None or len(yn) == 0:
    if default == None:
      raise StandardError("No input received!")
    else:
      yn = default
      print "(using default: " + default + ")"
  response = yn.upper()[0:1]
  if response == "Y":
    return True
  else:
    return False

################################################################################
# Read and return one line of input (without newline), and raise exception
# if no input
################################################################################
def read_one_line(str = None, default = None):
  retval=sys.stdin.readline()
  if len(retval) == 0:
    raise StandardError("No input received!")
  return retval[:-1]

################################################################################
# Read input from a temporary file
################################################################################
def read_line_from_tempfile(msg):
  (tfh, tfname) = tempfile.mkstemp()
  os.close(tfh)
  statinfo = os.stat(tfname)
  lastmtime = statinfo.st_mtime
  print msg
  print "Please put input in the following file: " + tfname
  retval = None
  while True:
    time.sleep(10)
    statinfo = os.stat(tfname)
    mtime = statinfo.st_mtime
    if mtime != lastmtime:
      tfh = open(tfname)
      retval = tfh.readline()[:-1]
      tfh.close()
      break
  os.unlink(tfname)
  return retval

################################################################################
# Like the unix find command, except the pattern is a regular expression.
################################################################################
def find(path, pattern=".*", allowdirs=0):

# print os.getcwd()

  try:
    listing = os.listdir(path)
  except OSError:
    print "OSError: " + path
    return []

  dirs=[]
  files=[]

  #Figure out what every non-hidden entry in the directory is (a file or directory)
# print listing
  for entry in listing:
    cur_entry = os.path.join(path,entry)
    if entry[0] == '.':
      continue
    elif os.path.isdir(cur_entry):
      dirs.append(cur_entry)
    else:
      files.append(cur_entry)

  #Recurse through directories
  ret = []
  for dir in dirs:
    ret += find(dir, pattern, allowdirs)

  #Add all files from the current directory that match the pattern to the results
  matchlist = files
  if allowdirs:
    matchlist += dirs
  for file in matchlist:
    if file[-1] == "/":
      file = file[0:-1]
    bn = os.path.basename(file)
    if re.match(pattern, bn):
      ret.append(file)
  
  return ret


################################################################################
# Like the unix ls command
################################################################################
def ls(path, pattern=".*"):
  try:
    listing = os.listdir(path)
  except OSError:
    print "OSError: "+path
    return []

  files = []

  # Find all files in the current directory.
  for entry in listing:
    cur_entry = os.path.join(path,entry)
#    cur_entry = os.path.realpath(cur_entry)
    if entry[0] == '.':
      continue
    elif os.path.isfile(cur_entry):
      files.append(cur_entry)

  #Figure out which ones match the pattern
  ret = []
  for file in files:
    if re.match(pattern, file):
      ret.append(file)
    
  return ret


################################################################################
# list all the returned results, skipping by twos
################################################################################
def listall(result):
  for i in range(len(result)):
    print i+1, result[i]


################################################################################
# check if the variable number is a decimal 
################################################################################
def to_decimal(number):
  try:
    val = string.atoi(number)
    return val
  except ValueError:
    return None


################################################################################
# select one number from the list
################################################################################
def selectone(sstr, count):
  value = None
  while value == None or value > count:
    print "Please select the "+sstr+":(1,2,3,...) "
    number = sys.stdin.readline()[:-1]
    if number=="":
      break
    value = to_decimal(number)
  return value
  

################################################################################
# Has the user select a scanner from a list.
################################################################################
def select_scanner(scanner_files):
  print
  print "The following scanner files are found."
  print 
  for j in range(len(scanner_files)):
    print "    %d. %s" % (j+1, scanner_files[j])
  print
  print "Please select one: ",
  ret = sys.stdin.readline()[:-1]
  try:
    return string.atoi(ret)
  except:
    return None


################################################################################
# Extract and concatenate the first three words in a phrase by space
################################################################################
def concat_three(count):
  split=phrase.split(" ")
  split = split[:3]
  
  cont = ""
  for i in split:
    cont += i

  return cont


################################################################################
# Count the selected items
################################################################################
def count_selection(flagLoc):
  flagcount=0
  for i in range(len(flagLoc)):
    flagcount += flagLoc[i]

  return flagcount


################################################################################
# Extract the part of a phrase before a column, and check if it is all upper case letters and numbers
# If it is then use it, otherwise use the first letter of every word to make a new word
################################################################################
def makeseriesdir(cur, namestr):
  #check if it is all upper case letters and numbers
  if re.match("[A-Z0-9]*",namestr):
    return cur.split('"')[1]
  else:
    ret=""
    cur=cur.split('"')[1]
    for str in cur:
      if str.isalpha() == 1:
        ret=ret+str[0]
      else:
           ret=ret+str

    return ret


###############################################################################
# Helper function to pretty print XML nodes
# Borrowed from minidom.py
# Added canonicalize option (which is only as canonical as we need).
###############################################################################
def xml2string(node, canonicalize=False):
  from StringIO import StringIO
  writer = StringIO()
  xml2string_aux(node, writer, canonicalize=canonicalize)
  return writer.getvalue()
  
def xml2string_aux(node, writer, indent="", addindent="", newl="", parentnsmap={}, canonicalize=False):
  # indent = current indentation
  # addindent = indentation to add to higher levels
  # newl = newline string
  nodeType = node.nodeType
  if nodeType == xml.dom.Node.TEXT_NODE or nodeType == xml.dom.Node.CDATA_SECTION_NODE:
    if canonicalize:
      if node.parentNode == node.ownerDocument:
        return
      if node.nodeValue.isspace():
        return
    writer.write(node.nodeValue)
    return
  elif not canonicalize and nodeType == xml.dom.Node.COMMENT_NODE:
    writer.write(indent+"<!-- "+node.nodeValue+"-->"+newl)
    return

  writer.write(indent+"<" + node.nodeName)

  attrentries = []
  nsentries = []
  nsmap = parentnsmap.copy()
  attrs = node._get_attributes()
  if attrs != None and len(attrs.keys()) > 0:
    sortedkeys = sorted(attrs.keys())
    if sortedkeys[0] != "xmlns":
      if "" in parentnsmap:
        writer.write(' xmlns=""')
    for key in sortedkeys:
      attr = attrs[key]
      localname = attr.localName
      value = attr.nodeValue
      if key.startswith("xmlns") and (len(key) == 5 or key[5] == ':'):
        nsmap[localname] = value
        if localname not in parentnsmap or parentnsmap[localname] != value:
          if localname == '':
            nsentries.append(('xmlns', value))
          else:
            nsentries.append(('xmlns:' + localname, value))
      else:
        attrentries.append((attr.nodeName, value))

  for (name, value) in attrentries + nsentries:
    writer.write(" %s\"" % name)
    writer.write(value.replace("&","&amp;").replace("<","&lt;").replace("\"","&quot;").replace(">","&gt;").replace("\x09", "&#09;").replace("\x0A", "&#0A;").replace("\x0D", "&#0D;"))
    writer.write("\"")

  writer.write(">%s"%(newl))
  if node.childNodes:
    for child in node.childNodes:
      xml2string_aux(child,writer,indent+addindent,addindent,newl,nsmap,canonicalize)
  writer.write("%s</%s>%s" % (indent,node.nodeName,newl))

################################################################################
# Evaluate a single XPath statement.
################################################################################
def XPathEval(str, doc):
  retval=[]
  results=xml.xpath.Evaluate(str, doc)
#  print doc
#  print str, results
  for i in results:
    if i.firstChild != None:
      retval.append(i.firstChild.nodeValue)
  return retval


################################################################################
# Replace a value in the location of an xml file that is evaluated by an XPath statement.
################################################################################
def XPathReplace(str, val, doc):
  for i in xml.xpath.Evaluate(str, doc):
    i.firstChild.nodeValue = val


################################################################################
# Remove an entire xml node if it matches an XPath statement.
################################################################################
def XPathRemove(str, doc):
  for node in xml.xpath.Evaluate(str, doc):
    node.parentNode.removeChild(node)

  
################################################################################
# Save a modified xml document
################################################################################
def SaveXML(filename, doc):
  fp=open(filename, "w")
  printer = xml.dom.ext.PrettyPrint(doc, fp, 'UTF-8')
#  printer.visit(doc)
  fp.close()


################################################################################
# This function detects if PATH is a pseudo-link, i.e. if
# the path doesn't exist but PATH.lnk exists, and if it is a regular file.
# If so, it returns the contents of the pseudo-link (interpreted relative
# to the directory containing PATH.lnk).
################################################################################
def ResolvePseudoLink(path):
  if not os.path.exists(path) and os.path.exists(path + '.lnk') and os.path.isfile(path + '.lnk'):
    f = open(path + '.lnk')
    redirect = f.read()
    f.close()
    newlinepos = redirect.find("\n")
    if redirect.count("\n") > 1 or (newlinepos != -1 and newlinepos != len(redirect) - 1):
      logging.error("Malformed pseudo-link '" + path + ".lnk'!  Contents:\n" + redirect)
      return None
    else:
      if newlinepos != -1:
        redirect = redirect[0:newlinepos]
      (pathhead, pathtail) = os.path.split(path)
      return os.path.join(pathhead, redirect)
  else:
    return None

################################################################################
# This function updates RLS given experiment, subject, and visit/component info
################################################################################
def UpdateRLS(Database, SiteInfo, experimentname=None, experimentid=None, subjectid=None, visitid=None):
  from UploadClasses import _RLS
  if experimentname == None and experimentid == None:
    logging.error("UpdateRLS: one of experimentname or experimentid must be specified!")
    return 0
  if subjectid == None:
    logging.error("UpdateRLS: subjectid must be specified!")
    return 0
  if visitid == None:
    logging.error("UpdateRLS: visitid must be specified!")
    return 0

  query = "select value from nc_conf_params where name='globus.rls.server.url.primary'"
  Database.execute(query)
  result = Database.fetchone()
  if len(result) != 1:
    logging.error("Could not get single value for query:\n" + query + "\nResult:\n" + str(result))
    return 0
  rlsurl = result[0]
  RLS = _RLS(rlsurl, SiteInfo)

  if experimentid == None:
    query = "select uniqueid from nc_experiment where name = '" + experimentname + "'"
    Database.execute(query)
    result = Database.fetchone()
    if len(result) != 1:
      logging.error("Could not get single value for query:\n" + query + "\nResult:\n" + str(result))
      return 0
    experimentid = result[0]
  
  query = "select storagetype from nc_experiment where uniqueid = %d" % experimentid
  Database.execute(query)
  result = Database.fetchall()
  if len(result) != 1:
    logging.error("Could not get single value for query:\n" + query + "\nResult:\n" + str(result))
    return 0
  scheme = result[0][0]

  if scheme == 'gridftp':
    scheme = 'gsiftp'
  
  query = "select datauri from nc_rawdata where nc_experiment_uniqueid=%d and subjectid='%s' and componentid=%d" % (int(experimentid), subjectid, int(visitid))
  Database.execute(query)
  result = Database.fetchall()
  if len(result) == 0:
    logging.error("No matches to query:\n" + query)
    return 0
  pairs = []
  for entry in result:
    # check to see if this logical name exists in RLS
    if len(RLS.query(entry[0])) > 0:
      # if it does, nuke all entries for this logical name -- this will be
      # the new canonical entry
      RLS.deleteall(entry[0]);
    logging.info("Creating RLS entry for " + scheme + "://" + SiteInfo.get_GridFTPHost() + entry[0])
    RLS.create(entry[0], scheme + "://" + SiteInfo.get_GridFTPHost() + entry[0])
  return 1

###############################################################################
# Read a timestamp file
###############################################################################
def ReadTimestampFile(filename):
  logging.info("Reading timestamp file " + filename)
  reader = Sax2.Reader()
  doc = reader.fromUri(filename)
  filenodes = xml.xpath.Evaluate('/vsync/file', doc)
  ret = {}
  for filenode in filenodes:
    filename = xml.xpath.Evaluate('string(name)', filenode)
    filedate = xml.xpath.Evaluate('string(date)', filenode)
    filetime = xml.xpath.Evaluate('string(time)', filenode)
    datere = re.compile('^[0-9]{8,}$')
    if not datere.match(filedate):
      logging.warn("File date " + filedate + " in timestamp file " + filename + " is invalid.")
      continue
    timere = re.compile('^[0-9]{6}$')
    if not timere.match(filetime):
      logging.warn("File time " + filetime + " in timestamp file " + filename + " is invalid.")
      continue
    timeStamp = time.mktime((int(filedate[:-4]), int(filedate[-4:-2]), int(filedate[-2:]), int(filetime[0:2]), int(filetime[2:4]), int(filetime[4:6]), -1, -1, -1))
    ret[filename] = {'timeStamp': timeStamp}
  return ret

###############################################################################
# Write a timestamp file
###############################################################################
def WriteTimestampFile(timestampStruct, filename):
  logging.info("Writing timestamp file " + filename)
  fp = open(filename, 'w')
  fp.write("<vsync>\n")
  for key in timestampStruct:
    timestruct = time.localtime(timestampStruct[key]['timeStamp'])
    fp.write(" <file>\n  <name>%s</name>\n  <date>%04d%02d%02d</date>\n  <time>%02d%02d%02d</time>\n </file>\n" % (key, timestruct.tm_year, timestruct.tm_mon, timestruct.tm_mday, timestruct.tm_hour, timestruct.tm_min, timestruct.tm_sec))
  fp.write("</vsync>\n")
  fp.close()

###############################################################################
# Determine the maximum modification time of the input paths.
# queue is a list of two-element sequences: (testpath, testtop, recursive)
# If recursive is True, then any paths contained within will be tested
# recursively.
# If testpath is a directory and testtop is False, then the modification time
# of testpath itself will not be tested (but any files/paths contained within
# testpath will be tested recursively if recursive is True).
###############################################################################
def MaxMTime(queue):
  retval = None
  logging.debug("Checking max modification time of:\n " + "\n ".join(map(lambda x: x[0] + ('', ' (no root)')[not x[1]] + (' (recurse)', '')[not x[2]], queue)))
  while len(queue) > 0:
    (path, checkmtime, recursive) = queue.pop()
    statobj = os.stat(path)
    if recursive and stat.S_ISDIR(statobj[stat.ST_MODE]):
      queue.extend(map(lambda x: (os.path.join(path, x), True, True), os.listdir(path)))
    if not checkmtime:
      continue
    mtime = statobj[stat.ST_MTIME]
    if retval == None or mtime > retval:
      logging.debug(" New max modification time of " + path + ": " + time.ctime(mtime))
      retval = mtime
  if retval != None:
    logging.debug(" Returning max = " + time.ctime(retval))
  return retval
  
