#!/usr/bin/env python

from SeriesDataDirectory import SeriesDataDirectory
from UploadFunctions import *
from UploadClasses import _Constants
from UploadClasses import _Schematron
from xml.dom.ext.reader import Sax2
import xml.xpath
from Tkinter import  *
import tkFileDialog
import tkMessageBox
import tkFont
import xml.dom.minidom
import sys
import os
import os.path
import md5
import dlgCalendar
import time
import string
import re
import logging

import Tkdnd

# ===PROLOG START===
print "This script won't run as is -- it must be installed into another\ndirectory using Install.sh."
sys.exit(1)
# ===PROLOG END===

# this class is used to help us generate an object hierarchy
# of Tkinter objects without polluting their attribute/method
# namespace.  To access the actual Tkinter object, just use .OBJ
class tkwrapper:
    def __init__(self, obj):
        self.OBJ = obj

class labelentry(tkwrapper):
    def __init__(self, parent, label, width, textvariable=None, orient=HORIZONTAL):
        newframe = Frame(parent)
        newframe.pack(fill=X, expand=1)
        self.label = Label(newframe, text=label)
        if orient==VERTICAL:
            self.label.pack(side=TOP, fill=X, expand=1)
            self.label.config(anchor=NW)
        else:
            self.label.pack(side=LEFT)
        self.entry = Entry(newframe, width=width, background='white')
        if textvariable != None:
            self.attachVar(textvariable)
        if orient==VERTICAL:
            self.entry.pack(side=BOTTOM)
        else:
            self.entry.pack(side=RIGHT)
        tkwrapper.__init__(self, newframe)

    def attachVar(self, textvariable):
        self.entry['textvariable'] = textvariable

    def detachVar(self):
        self.entry['textvariable'] = None
        self.entry.delete(0, END)

    def getLabel(self):
        return self.label

    def getEntry(self):
        return self.entry


## the following by Scott David Daniels, found here:
##  http://aspn.activestate.com/ASPN/Cookbook/Python/Recipe/52549
import new
def curry(*args, **kwargs):
    function, args = args[0], args[1:]
    if args and kwargs:
        def result(*rest, **kwrest):
            combined = kwargs.copy()
            combined.update(kwrest)
            return function(*args + rest, **combined)
    elif args:
        if len(args) > 1 or args[0] != None:
            def result(*rest, **kwrest):
                return function(*args + rest, **kwrest)
        else:
            # Special magic: make a bound object method on the arg
            return new.instancemethod(function, args[0], object)
    elif kwargs:
        def result(*rest, **kwrest):
            if kwrest:
                combined = kwargs.copy()
                combined.update(kwrest)
            else:
                combined = kwargs
            return function(*rest, **combined)
    else:
        return function
    return result


# This class encapsulates a TK-wrapped variable and the link from
# that variable to a region in a Text object.  If the region is
# set (using setTextMarks()), and the encapsulated variable changes
# (either from a call to setValue() or otherwise), the text region
# is also updated.
# The variable can also be linked to a Listbox object, in which
# case this object will take care of polling it for updates
# (since a Listbox does not have callback-on-update functionality).
# Also supports changing the "text" attribute of an object updatetextobj
# whenever the variable changes (e.g. a label that changes its text).
# createmissing is a tuple (insertmark, tagname, indent, commentstr) that,
# if the value is changed, and if the missing attribute is True, specifies
# where (insertmark) in the XML text box to insert a new element (with tag
# name tagname), and an optional comment with content specified by commentstr.
# Both new element and comment are indented with the string specified by
# indent.
class varobject:
    def __init__(self, var, textwrapper=None, markbegin=None, markend=None, listbox=None, updatetextinobj=None, missing=False, createmissing=None):
        self.var = var
        self.textwrapper = textwrapper
        self.markbegin = markbegin
        self.markend = markend
        self.listbox = listbox
        self.lastListboxValue = None
        self.updatetextinobj = updatetextinobj
        self.missing = missing
        self.createmissing = createmissing
        if self.listbox != None:
            self.pollListbox()
        self.tracer = None
        self.collectUpdates = False
    def setUpdateTextInObj(self, updatetextinobj = None):
        self.updatetextinobj = updatetextinobj
    def setCreateMissing(self, createmissing):
        self.createmissing = createmissing
    def setMissing(self, missing = True):
        self.missing = missing
    def getVar(self):
        return self.var
    def setTextMarks(self, textwrapper, markbegin, markend):
        self.textwrapper = textwrapper
        self.markbegin = markbegin
        self.markend = markend
        self.setWriteTrace(self.replaceText)
    def getTextMarks(self):
        return (textwrapper, markbegin, markend)
    def getValue(self):
        return self.var.get()
    def setValue(self, text):
        self.var.set(text)
        if self.listbox:
            for index in range(self.listbox.size()):
                if text == self.listbox.get(index):
                    self.listbox.selection_clear(0,END)
                    self.listbox.selection_set(index)
                    self.lastListboxValue = index
                    break
    def setWriteTrace(self,func):
        if self.tracer != None:
            self.var.trace_vdelete("w", self.tracer)
        if func == None:
            self.tracer = None
        else:
            self.tracer = self.var.trace("w", func)
    def replaceText(self, *args):
        if self.textwrapper != None and self.markbegin != None and self.markend != None:
            if self.missing and self.createmissing != None:
                insertmark = self.createmissing[0]
                tagname = self.createmissing[1]
                indent = self.createmissing[2]
                commentstr = None
                if len(self.createmissing) > 3:
                    commentstr = self.createmissing[3]
                xsavestate = self.textwrapper.OBJ['state']
                self.textwrapper.OBJ['state'] = NORMAL
                self.textwrapper.OBJ.mark_set(INSERT, insertmark)
                if commentstr != None:
                    self.textwrapper.OBJ.insert(INSERT, indent + '<!-- ' + commentstr.replace('--', ' - - ') + ' -->\n')
                self.textwrapper.OBJ.insert(INSERT, indent + '<' + tagname + '>')
                self.textwrapper.OBJ.mark_set(self.markbegin, INSERT)
                self.textwrapper.OBJ.mark_gravity(self.markbegin, LEFT)
                self.textwrapper.OBJ.mark_set(self.markend, INSERT)
                self.textwrapper.OBJ.mark_gravity(self.markend, LEFT)
                self.textwrapper.OBJ.insert(INSERT, '</' + tagname + '>\n')
                self.textwrapper.OBJ.mark_gravity(self.markend, RIGHT)
                self.textwrapper.OBJ['state'] = xsavestate
                self.setMissing(False)
            xsavestate = self.textwrapper.OBJ['state']
            self.textwrapper.OBJ.config(state=NORMAL)
            self.textwrapper.OBJ.delete(self.markbegin, self.markend)
            self.textwrapper.OBJ.insert(self.markbegin, self.getValue())
            if not self.textwrapper.collectUpdates:
                self.textwrapper.OBJ.tag_remove('curupdate', '1.0', END)
            self.textwrapper.OBJ.tag_add('curupdate', self.markbegin, self.markend)
            self.textwrapper.OBJ['state'] = xsavestate
        if self.updatetextinobj != None:
            self.updatetextinobj.OBJ['text'] = self.getValue()
    def pollListbox(self, reschedule=1):
        items = map(int, self.listbox.curselection())
        item = None
        if len(items) != 0:
            item = items[0]
        if self.lastListboxValue != item:
            val = ''
            if item != None:
                val = self.listbox.get(item)
            self.setValue(val)
            self.lastListboxValue = item
        if reschedule:
            self.listbox.after(250, self.pollListbox)

# This class stores XML "path" information -- i.e. it represents a location
# in an XML file.  The location is specified as a mutable list of
# namespace-ignorant path components starting at the root element of the
# document down to the relevant element.
# Each path component is a two-element tuple consisting of a
# (local) tag name, and either a numeric index (to distinguish this element
# from any siblings with the same tag, where 1 is the first in document order)
# or a tuple containing an object and a list containing the object, its position
# in the list determining the index.
# The path component list is available through the getPath() method.
# If the "resolveIndex" argument to getPath() is True, then the indices of
# any components that are specified using lists are resolved and converted
# to a numeric index.  If the current object does not exist in the list,
# a LookupError is thrown.
# This list can uniquely identify an element in an XML document, and could
# trivially be converted to XPath if needed.
class xmlpath:
    def __init__(self, initpath=None):
        self.path = []
        if initpath:
            self.path = initpath
    def clone(self):
        return xmlpath(self.path[:])
    def addComponent(self, tagname, indexOrTuple):
        self.path.append((tagname, indexOrTuple))
    def getPath(self, resolveIndex=False):
        if not resolveIndex:
            return self.path
        newpath = []
        for (tagname, indexOrTuple) in self.path:
            if isinstance(indexOrTuple, tuple):
                (theobj, thelist) = indexOrTuple
                index = -1
                for i in range(len(thelist)):
                    if thelist[i] is theobj:
                        index = i + 1
                if index == -1:
                    raise LookupError(tagname + " object " + str(theobj) + " not found in list")
                newpath.append((tagname, index))
            else:
                newpath.append((tagname, indexOrTuple))
        return newpath
    def getXPath(self):
        newpath = self.getPath(True)
        xpathlist = []
        for (tagname, index) in newpath:
            xpathlist.append("%s[%d]" % (tagname, index))
        return '/' + '/'.join(xpathlist)

class DndSeriesTarget:
    def __init__(self, dndobj, gui, position):
        self.__dndobj = dndobj
        self.__defaultbg = self['background']
        self.__gui = gui
        self.__position = position
        self.__issource = 0

    def set_issource(self):
        self.__issource = 1

    def unset_issource(self):
        self.__issource = 0

    def dnd_accept(self, source, event):
        return self

    def dnd_enter(self, source, event):
        if not self.__issource:
            self['background'] = 'yellow'
    
    def dnd_leave(self, source, event):
        if not self.__issource:
            self['background'] = self.__defaultbg
    
    def dnd_motion(self, source, event):
        pass

    def dnd_commit(self, source, event):
        if not self.__issource:
            self['background'] = self.__defaultbg
        if source is self.__dndobj:
            source.gui.chooseSeries(source, True, event)
        else:
            self.__gui.moveSeries(source, self.__position, self.__dndobj)

class DndSeriesTargetLabel(DndSeriesTarget,Label):
    def __init__(self, parent, dndobj, gui, position, **kwargs):
        Label.__init__(self, parent, **kwargs)
        DndSeriesTarget.__init__(self, dndobj, gui, position)

class DndSeriesTargetFrame(DndSeriesTarget,Frame):
    def __init__(self, parent, dndobj, gui, position, **kwargs):
        Frame.__init__(self, parent, **kwargs)
        DndSeriesTarget.__init__(self, dndobj, gui, position)

class SeriesDataContainer(tkwrapper):
    curident = 0
    def __init__(self, parent, gui):
        tkwrapper.__init__(self, Frame(parent))
        self.defaultbg = self.OBJ['background']
        self.dirname = None   # local subdirectory name
        self.sdd = None       # SeriesDataDirectory object
        self.selector = None  # GUI selector "button" (actually a Label)
        self.close = None     # GUI close button
        self.space = None
        self.gui = gui        # XMLUploadGUI instance
        self.ident = str(SeriesDataContainer.curident)
        self.xpobjs = []      # xmlpath objects associated with this series

        # these are spacers for drag-and-drop
        self.spacer_before = None
        self.spacer_after = None

        SeriesDataContainer.curident = SeriesDataContainer.curident + 1

    def getIdent(self):
        return self.ident

    def setDirName(self, dirname):
        self.dirname = dirname
        if self.selector != None:
            self.selector.OBJ['text'] = self.dirname

    def getDirName(self):
        return self.dirname

    def addSeriesDataFromDirectory(self, fullsdpath):
        # ignore BXH and XCEDE the first time
        self.sdd = SeriesDataDirectory(fullsdpath)
        self.sdd.extract_data(type_order=[_Constants.m_DATASPEC_DICOM,_Constants.m_DATASPEC_PFILE,_Constants.m_DATASPEC_SIGNA5,_Constants.m_DATASPEC_IOWASIGNA5,_Constants.m_DATASPEC_FFILE,_Constants.m_DATASPEC_UCIRAW,_Constants.m_DATASPEC_MINC,_Constants.m_DATASPEC_NIFTI,_Constants.m_DATASPEC_AFNI,_Constants.m_DATASPEC_ANALYZE,_Constants.m_DATASPEC_XCEDE,_Constants.m_DATASPEC_BXH])

    def setSeriesData(self, sdd):
        self.sdd = sdd

    def getSeriesData(self):
        return self.sdd

    def addSelector(self):
        if self.selector != None:
            self.removeSelector()
        self.selector = tkwrapper(DndSeriesTargetLabel(self.OBJ, self, gui, 'before', text=self.dirname, relief=RAISED))
        self.selector.OBJ.grid(row=0, column=0, rowspan=2, sticky=N+S+E+W)
        self.selector.defaultbg = self.selector.OBJ.cget('background')
        self.selector.curbg = self.selector.defaultbg
        self.selector.drag_bind_id = self.selector.OBJ.bind('<ButtonPress>', self.startDrag)
        self.closer = tkwrapper(Label(self.OBJ, text='DEL', font=tkFont.Font(family='Helvetica', size=6, weight=tkFont.BOLD), bd=1, relief=GROOVE))
        self.closer.OBJ.grid(row=0, column=1, sticky=N+E)
        self.closer.bind_id = self.closer.OBJ.bind('<Button>', curry(self.gui.removeSeries, self))
        self.space = tkwrapper(Frame(self.OBJ, width=10))
        self.space.OBJ.grid(row=0, column=2, sticky=N+S+E+W)
        self.OBJ.grid_columnconfigure(0, weight=1)

    def getSpacerBefore(self):
        if self.spacer_before == None:
            self.spacer_before = DndSeriesTargetFrame(self.OBJ.master, self, self.gui, 'before', height=5)
        return self.spacer_before

    def getSpacerAfter(self):
        if self.spacer_after == None:
            self.spacer_after = DndSeriesTargetFrame(self.OBJ.master, self, self.gui, 'after', height=5)
        return self.spacer_after

    def removeSpacerBefore(self):
        self.spacer_before = None

    def removeSpacerAfter(self):
        self.spacer_after = None

    def startDrag(self, event):
        self.gui.chooseSeries(self, True, event)
        self.selector.OBJ.set_issource()
        self.selector.OBJ['background'] = 'yellow'
        Tkdnd.dnd_start(self, event)

    def dnd_end(self, target, event):
        self.selector.OBJ.unset_issource()
        self.selector.OBJ['background'] = self.selector.curbg

    def removeSelector(self):
        self.selector.OBJ.unbind('<ButtonPress>', self.selector.drag_bind_id)
        self.selector.drag_bind_id = None
#        self.selector.OBJ.unbind('<ButtonRelease>', self.selector.bind_id)
#        self.selector.bind_id = None
        self.selector = None

    def removeCloser(self):
        self.closer.OBJ.unbind('<Button>', self.closer.bind_id)
        self.closer.bind_id = None
        self.closer = None

    def kill(self):
        self.removeSelector()
        self.removeCloser()
        self.spacer_before = None
        self.spacer_after = None
        self.OBJ.destroy()


class XMLUploadGUI:
    def __init__(self):
        # add the 'bin' directory to the path
        pathname = os.path.dirname(__file__)
        fullpathname = os.path.abspath(pathname)
        pathenv = os.environ['PATH']
        os.environ['PATH'] = pathenv + ':' + fullpathname + '/bin'
        
        # the subdirectory "labelentry" objects when a subdirectory is chosen
        # indexed by variable name
        self.sdles = {}

        # variable objects, indexed by variable name. storing the StringVar
        # objects, positions in the XML text object corresponding to this
        # variable, and the observer (trace object name) that links them
        self.sdvos = {}

        # a map of XML paths (identifying XML elements) to ranges in the
        # XML text object, specified as begin and end marks
        self.xmlpathtotext = {}

        self.root = tkwrapper(Tk())
        # We will put all children of root at the top-level
        # of our object hierarchy for convenience.

        # cm_f: common stuff
        self.cm_f = tkwrapper(LabelFrame(self.root.OBJ))
        self.cm_f.OBJ.grid(row=0, column=0, sticky=N+W)
        # birnid_t: BIRN ID entry
        self.createLabelEntry(name='BIRNID', parent=self.cm_f.OBJ, label='BIRN ID', width=12)
        # acqid_t: Acquisition site ID entry
        self.createLabelEntry(name='acquisitionSiteID', parent=self.cm_f.OBJ, label='Acquisition site ID', width=4)
        # subjgroup_t: Subject group entry
        self.createLabelEntry(name='subjectGroup', parent=self.cm_f.OBJ, label='Subject Group', width=24)
        # scannerid_t: Scanner ID entry
        self.createLabelEntry(name='scannerID', parent=self.cm_f.OBJ, label='Scanner ID', width=8)
        # scannermanufacturer_t: Scanner manufacturer entry
        self.createLabelEntry(name='scannerManufacturer', parent=self.cm_f.OBJ, label='Scanner Manufacturer', width=8)
        for name in ( 'BIRNID', 'acquisitionSiteID', 'subjectGroup', 'scannerID', 'scannerManufacturer' ):
            self.sdvos[name].setCreateMissing( ( 'FIPSContentEndsHere', name, '  ' ) )

        # p_f: project stuff
        self.p_f = tkwrapper(LabelFrame(self.root.OBJ, text='Project'))
        self.p_f.OBJ.grid(row=0, column=1, sticky=N+W)
        # p_f.name_e: project name entry
        self.createLabelEntry(name='project/name', parent=self.p_f.OBJ, label='Name', width=16)
        # p_f.id_e: project ID entry
        self.createLabelEntry(name='project/ID', parent=self.p_f.OBJ, label='ID', width=4)
        for name in ( 'name', 'ID' ):
            self.sdvos['project/' + name].setCreateMissing( ( 'ProjectContentEndsHere', name, '    ' ) )

        # v_f: visit stuff
        self.v_f = tkwrapper(LabelFrame(self.root.OBJ, text='Visit'))
        self.v_f.OBJ.grid(row=1, column=0, sticky=N+W)
        # v_f.name_e: visit name entry
        self.createLabelEntry(name='visit/name', parent=self.v_f.OBJ, label='Name', width=16)
        # v_f.id_e: visit ID entry
        self.createLabelEntry(name='visit/ID', parent=self.v_f.OBJ, label='ID', width=4)
        # v_f.date_e: visit date entry
        self.createLabelEntry(name='visit/visitDate', parent=self.v_f.OBJ, label='Date', width=10)
        calbut = Button(self.sdles['visit/visitDate'].OBJ, text="CAL", font=tkFont.Font(family='Helvetica', size=6, weight=tkFont.BOLD), command=curry(self.showCalendar, varname='visit/visitDate'))
        calbut.pack(side=RIGHT)
        # v_f.desc_e: visit description entry
        self.createLabelEntry(name='visit/description', parent=self.v_f.OBJ, label='Description', width=40, orient=VERTICAL)
        for name in ( 'name', 'ID', 'visitDate' ):
            self.sdvos['visit/' + name].setCreateMissing( ( 'VisitContentEndsHere', name, '    ' ) )

        # s_f: study stuff
        self.s_f = tkwrapper(LabelFrame(self.root.OBJ, text='Study'))
        self.s_f.OBJ.grid(row=1, column=1, sticky=N+W)
        # s_f.name_e: study name entry
        self.createLabelEntry(name='study/name', parent=self.s_f.OBJ, label='Name', width=16)
        # s_f.id_e: study ID entry
        self.createLabelEntry(name='study/ID', parent=self.s_f.OBJ, label='ID', width=4)
        # s_f.time_e: study time entry
        self.createLabelEntry(name='study/studyTime', parent=self.s_f.OBJ, label='Time', width=10)
        # s_f.desc_e: study description entry
        self.createLabelEntry(name='study/description', parent=self.s_f.OBJ, label='Description', width=40, orient=VERTICAL)
        for name in ( 'name', 'ID', 'studyTime' ):
            self.sdvos['study/' + name].setCreateMissing( ( 'StudyContentEndsHere', name, '    ' ) )

        # fs_f: file system listbox frame
        self.fs_f = tkwrapper(Frame(self.root.OBJ))
        self.fs_f.label_l = tkwrapper(Label(self.fs_f.OBJ, text='Upload type'))
        self.fs_f.label_l.OBJ.pack(side=LEFT)
        self.fs_f.listbox_lb = tkwrapper(Listbox(self.fs_f.OBJ, width=9, height=3, background='white', exportselection=0))
        self.fs_f.listbox_lb.OBJ.pack(side=RIGHT)
        self.fs_f.listbox_lb.OBJ.insert(END, 'Local')
        self.fs_f.listbox_lb.OBJ.insert(END, 'Remote')
        self.fs_f.listbox_lb.OBJ.insert(END, 'Local-Remote')
        self.fs_f.OBJ.grid(row=2, column=0, columnspan=2, sticky=N+W)
        self.sdvos['FileSystem'] = varobject(StringVar(), listbox=self.fs_f.listbox_lb.OBJ, createmissing=('FIPSContentEndsHere', 'FileSystem', '  '))

        # sd_f: subdirectory frame
        self.sd_f = tkwrapper(Frame(self.root.OBJ))
        self.sd_f.OBJ.grid(row=3, column=0, sticky=N+S+E+W)
        # sd_f.choose_b: button to choose base dir
        self.sd_f.choose_b = tkwrapper(Button(self.sd_f.OBJ, text='Add/merge series from base directory'))
        self.sd_f.choose_b.OBJ.pack(side=TOP)
        self.sd_f.choose_b.OBJ['command']=self.chooseBaseDir
        # sd_f.dir_t: the text widget holding the actual pathname
        self.sd_f.dir_t = tkwrapper(Label(self.sd_f.OBJ, width=0, wraplength=200, height=0))
        self.sd_f.dir_t.OBJ.pack()
        # sd_f.sl_f: subdirectory selection frame
        self.sd_f.sl_f = tkwrapper(Frame(self.sd_f.OBJ))
        self.sd_f.sl_f.OBJ.pack(fill=BOTH, expand=1)
        self.sd_f.sl_f.sdlist = []
        # sd_f.add_b: button to add series
        self.sd_f.add_b = tkwrapper(Button(self.sd_f.OBJ, text='Add new series'))
        self.sd_f.add_b.OBJ.pack(side=BOTTOM)
        self.sd_f.add_b.OBJ['command']=self.newSeries

        # ed_f: series info editing frame
        self.ed_f = tkwrapper(LabelFrame(self.root.OBJ, text='Series'))
        self.ed_f.OBJ.grid(row=3, column=1, sticky=N+W)
        self.ed_f.lenames = [
            ('nameLocal', 'Local naming convention'),
            ('nameStandard', 'nameStandard is the "remote" location and standard naming convention'),
            ('ID', 'This ID linked to segmentID in nc_expSegment table of HID; this element can be left blank for automatic numbering'),
            ('seriesTime', 'seriesTime is the time when the series starts, in HH:MM:SS format where HH is between 00 and 23'),
            ('description', 'any notes about the series'),
            ('type', 'type describes the scan type as functional, structural, or exclude'),
            ('paradigm', 'paradigm describes the type of stimulus the participant is engaged in'),
            ('number', 'the Nth run for that task within this Study, can be left blank if only one is ever expected'),
            ('sliceorder', 'slice order must be of the form X1,X2,X3,,...,XN with as many entries as there are slices in each volume.  Slice indices start at 1.  The first number in the list is the index of the slice that was acquired first.  For sequential data, this is most likely 1,2,3,4,5,...,numslices'),
            ('skipInitialVols', 'If your scanner acquires AND STORES volumes at the beginning of the acquisition that need to be ignored for analysis, AND you are uploading these volumes, please enter the number of volumes here.  i.e. this should only be non-zero if you are uploading data with more volumes than is expected for this paradigm')
            ]
        for (lename, comment) in self.ed_f.lenames:
            sdle = self.createLabelEntry(name=lename, parent=self.ed_f.OBJ, label=lename, width=20)
            sdle.getEntry()['state'] = DISABLED
            self.sdles[lename] = sdle

        # xd_f: XML display frame
        self.xd_f = tkwrapper(Frame(self.root.OBJ, bd=2, relief=SUNKEN))
        self.xd_f.OBJ.grid(row=0, column=2, rowspan=4, sticky=N+S+E+W)
        self.xd_f.OBJ.grid_rowconfigure(1, weight=1)
        self.xd_f.OBJ.grid_columnconfigure(0, weight=1)
        # xd_f.xml_t: XML text display
        self.xd_f.xml_t = tkwrapper(Text(self.xd_f.OBJ, wrap=NONE, bd=0, width=80, state=DISABLED))
        self.xd_f.xml_t.collectUpdates = False
        # xd_f.y_sb: X scrollbar
        self.xd_f.x_sb = tkwrapper(Scrollbar(self.xd_f.OBJ, orient=HORIZONTAL))
        # xd_f.y_sb: Y scrollbar
        self.xd_f.y_sb = tkwrapper(Scrollbar(self.xd_f.OBJ))
        # xd_f.v_f: validation frame
        self.xd_f.v_f = tkwrapper(Frame(self.xd_f.OBJ, bd=2, relief=RIDGE))
        self.xd_f.v_f.defaultbg = self.xd_f.v_f.OBJ['background']
        self.xd_f.v_f.OBJ.grid_columnconfigure(1, weight=1)
        # xd_f.b_f: load/save/exit button frame
        self.xd_f.b_f = tkwrapper(Frame(self.xd_f.OBJ))
        self.xd_f.xml_t.OBJ.grid(row=1, column=0, sticky=N+S)
        self.xd_f.x_sb.OBJ.grid(row=2, column=0, sticky=E+W)
        self.xd_f.y_sb.OBJ.grid(row=1, column=1, sticky=N+S)
        self.xd_f.xml_t.OBJ["xscrollcommand"] = self.xd_f.x_sb.OBJ.set
        self.xd_f.xml_t.OBJ["yscrollcommand"] = self.xd_f.y_sb.OBJ.set
        self.xd_f.x_sb.OBJ["command"] = self.xd_f.xml_t.OBJ.xview
        self.xd_f.y_sb.OBJ["command"] = self.xd_f.xml_t.OBJ.yview
        self.xd_f.v_f.OBJ.grid(row=0, columnspan=2, sticky=N+S+E+W)
        self.xd_f.b_f.OBJ.grid(row=3, columnspan=2, sticky=N+S+E+W)
        self.xd_f.b_f.load_b = tkwrapper(Button(self.xd_f.b_f.OBJ, text="Load", command=self.loadAskFile))
        self.xd_f.b_f.save_b = tkwrapper(Button(self.xd_f.b_f.OBJ, text="Save", command=self.saveFile))
        self.xd_f.b_f.exit_b = tkwrapper(Button(self.xd_f.b_f.OBJ, text="Exit", command=self.exit))
        self.xd_f.b_f.load_b.OBJ.grid(row=0, column=0)
        self.xd_f.b_f.save_b.OBJ.grid(row=0, column=1)
        self.xd_f.b_f.exit_b.OBJ.grid(row=0, column=2)
        # validate frame has two rows.  First has "Validate" button and primary
        # message bar.  Second row is for displaying errors and contains "Prev"
        # and "Next" error buttons, as well as a message box for displaying
        # an error message.
        self.xd_f.v_f.validate_b = tkwrapper(Button(self.xd_f.v_f.OBJ, text="Validate", command=self.validate))
        self.xd_f.v_f.validate_b.OBJ.grid(row=0, column=0)
        self.xd_f.v_f.primaryvar = StringVar()
        self.xd_f.v_f.primaryvar.set("(no message)")
        self.xd_f.v_f.primary_m = tkwrapper(Label(self.xd_f.v_f.OBJ, bd=1, relief=SUNKEN, textvariable=self.xd_f.v_f.primaryvar, anchor=W, font=("Helvetica", 9, "normal"), justify=LEFT))
        self.xd_f.v_f.primary_m.OBJ.grid(row=0, column=1, sticky=N+S+E+W)
        self.xd_f.v_f.e_f = tkwrapper(Frame(self.xd_f.v_f.OBJ))
        self.xd_f.v_f.e_f.OBJ.grid(row=1, column=0, columnspan=2, sticky=N+S+E+W)
        self.xd_f.v_f.e_f.OBJ.grid_columnconfigure(1, weight=1)
        self.xd_f.v_f.e_f.errors = []
        self.xd_f.v_f.e_f.curErrorNum = -1
        self.xd_f.v_f.e_f.prev_b = tkwrapper(Button(self.xd_f.v_f.e_f.OBJ, text="PREV", command=self.prevError, font=("Helvetica", 7, "bold")))
        self.xd_f.v_f.e_f.next_b = tkwrapper(Button(self.xd_f.v_f.e_f.OBJ, text="NEXT", command=self.nextError, font=("Helvetica", 7, "bold")))
        self.xd_f.v_f.e_f.prev_b.OBJ.grid(row=0, column=0, sticky=N+W)
        self.xd_f.v_f.e_f.next_b.OBJ.grid(row=1, column=0, sticky=N+W)
        self.xd_f.v_f.e_f.dummy_f = tkwrapper(Frame(self.xd_f.v_f.e_f.OBJ))
        self.xd_f.v_f.e_f.OBJ.grid_rowconfigure(2, weight=1)
        self.xd_f.v_f.e_f.em_f = tkwrapper(Frame(self.xd_f.v_f.e_f.OBJ, bd=1, relief=SUNKEN))
        self.xd_f.v_f.e_f.em_f.OBJ.grid(row=0, column=1, rowspan=3, sticky=N+S+E+W)
        self.xd_f.v_f.e_f.em_f.OBJ.grid_columnconfigure(0, weight=1)
        self.xd_f.v_f.e_f.em_f.errorvar1 = StringVar()
        self.xd_f.v_f.e_f.em_f.errorvar2 = StringVar()
        self.xd_f.v_f.e_f.em_f.errorvar1.set("")
        self.xd_f.v_f.e_f.em_f.errorvar2.set("")
        self.xd_f.v_f.e_f.em_f.error1_m = tkwrapper(Message(self.xd_f.v_f.e_f.em_f.OBJ, textvariable=self.xd_f.v_f.e_f.em_f.errorvar1, bd=0, width=500, font=('Helvetica', 9, 'bold'), anchor=W, justify=LEFT))
        self.xd_f.v_f.e_f.em_f.error2_m = tkwrapper(Message(self.xd_f.v_f.e_f.em_f.OBJ, textvariable=self.xd_f.v_f.e_f.em_f.errorvar2, bd=0, width=500, font=('Helvetica', 9, 'normal'), anchor=W, justify=LEFT))
        self.xd_f.v_f.e_f.em_f.error1_m.OBJ.grid(row=0, column=0, sticky=N+S+E+W)
        self.xd_f.v_f.e_f.em_f.error2_m.OBJ.grid(row=1, column=0, sticky=N+S+E+W)
        self.xd_f.v_f.e_f.OBJ.grid_remove()

        self.xd_f.lastfn = None # saved filename from previous file dialog

        # make sure XML editing frame will stretch if resized
        self.root.OBJ.grid_rowconfigure(3, weight=1)
        self.root.OBJ.grid_columnconfigure(2, weight=1)

        self.initXMLText()
        self.initTags()

        self.basedir = None

        # this will flag whether to give a "save" prompt on exiting or reloading
        self.saved_signature = self.calcSignature()

    def showCalendar(self, varname):
        var = self.sdvos[varname].var
        value = var.get()
        fields = value.split('-')
        t = time.localtime()
        year = t[0]
        month = t[1]
        day = t[2]
        if len(fields) == 3:
            (year, month, day) = fields
        tmpvar = StringVar()
        tmpvar.trace("w", curry(self.updateDate, tmpvar=tmpvar, var=var))
        dlgCalendar.tkCalendar(self.sdles[varname].entry, year, month, day, tmpvar)

    def updateDate(self, arg1, arg2, arg3, tmpvar, var):
        fields = tmpvar.get().split("/")
        if len(fields) != 3:
            return
        (year, month, day) = fields
        newstr = '%04d-%02d-%02d' % (int(year), int(month), int(day))
        var.set(newstr)

    def calcSignature(self):
        return md5.md5(self.xd_f.xml_t.OBJ.get('1.0', END)).digest()

    def loadAskFile(self):
        if self.saved_signature != self.calcSignature():
            response = tkMessageBox._show(title='Save file?', message='If you load a new file,\nany current edits will be deleted.\nDo you want to save the file first?', type=tkMessageBox.YESNOCANCEL, default=tkMessageBox.YES)
            if response == 'yes':
                if not self.saveFile():
                    # said they wanted to save, but save failed, so don't exit
                    return None
            elif response == 'no':
                pass
            else:
                return None
        if self.xd_f.lastfn:
            fn = tkFileDialog.askopenfilename(initialdir=os.path.dirname(self.xd_f.lastfn))
        else:
            fn = tkFileDialog.askopenfilename()
        if not fn:
            return None
	self.loadFile(fn)

    def loadFile(self, fn):
        x = self.xd_f.xml_t.OBJ
        xsavestate = x['state']
        x['state'] = NORMAL
        x.delete('1.0', END)
        self.destroySeriesData()
        for varname in self.sdvos:
            self.sdvos[varname].setMissing(True)
        self.sd_f.dir_t.OBJ['text'] = '<no base dir>'
        dom = xml.dom.minidom.parse(fn)
        queue = [ ( '', xmlpath(), dom, False ) ]
        x.insert(INSERT, '<?xml version="1.0"?>\n')
        ATTEND = 1
        ELEMEND = 2
        fields = [ ('', [ 'FileSystem', 'BIRNID', 'acquisitionSiteID', 'subjectGroup', 'scannerID', 'scannerManufacturer' ]),
                   ('project', [ 'name', 'ID' ]),
                   ('visit', [ 'name', 'ID', 'visitDate', 'description' ]),
                   ('study', [ 'name', 'ID', 'studyTime', 'description' ]),
                   ('series', [ 'nameLocal', 'nameStandard', 'ID', 'seriesTime', 'description', 'type', 'paradigm', 'number', 'sliceorder', 'skipInitialVols' ]) ]
        seriesnum = -1
        seriesNameLocal = None
        lastnewlineind = -1
        sdcontainer = None
        grabtextafterseries = False
        while len(queue) > 0:
            (path, xp, node, parentisdocument) = queue.pop()
            if node == ATTEND:
                x.insert(INSERT, '>')
                continue
            elif node == ELEMEND:
                numlevels = path.count('/')
                lastslash = path.rfind('/')
                if path == '/FIPS':
                    markend = 'FIPSContentEndsHere'
                    if lastnewlineind != -1:
                        x.mark_set(markend, lastnewlineind)
                    else:
                        x.mark_set(markend, INSERT)
                    x.mark_gravity(markend, LEFT)
                elif path == '/FIPS/series':
                    markend = 'Series'+sdcontainer.getIdent()+'InsertNewContentHere'
                    if lastnewlineind != -1:
                        x.mark_set(markend, lastnewlineind)
                    else:
                        x.mark_set(markend, INSERT)
                    x.mark_gravity(markend, LEFT)
                elif path == '/FIPS/visit':
                    markend = 'VisitContentEndsHere'
                    if lastnewlineind != -1:
                        x.mark_set(markend, lastnewlineind)
                    else:
                        x.mark_set(markend, INSERT)
                    x.mark_gravity(markend, LEFT)
                elif path == '/FIPS/study':
                    markend = 'StudyContentEndsHere'
                    if lastnewlineind != -1:
                        x.mark_set(markend, lastnewlineind)
                    else:
                        x.mark_set(markend, INSERT)
                    x.mark_gravity(markend, LEFT)
                x.insert(INSERT, '</' + path[lastslash+1:] + '>')
                if path == '/FIPS/series':
                    sdcontainer = self.sd_f.sl_f.sdlist[seriesnum]
                    sdcontainer.setDirName(seriesNameLocal)
                    sdcontainer.addSelector()
                    nameLocalVarName = 'series_'+sdcontainer.getIdent()+'/nameLocal'
                    if self.sdvos.has_key(nameLocalVarName):
                        self.sdvos[nameLocalVarName].setUpdateTextInObj(sdcontainer.selector)
                    markbegin ='Series'+sdcontainer.getIdent()+'BeginsHere'
                    markend ='Series'+sdcontainer.getIdent()+'EndsHere'
                    x.mark_set(markend, INSERT)
                    x.mark_gravity(markend, LEFT)
                    seriesendpos = x.index(INSERT)
                    tagname = 'Series'+sdcontainer.getIdent()
                    x.tag_config(tagname)
                    x.tag_add(tagname, markbegin, markend)
                    x.tag_bind(tagname, '<Button-1>', curry(self.chooseSeries, sdcontainer, False))
                    self.xmlpathtotext[xp] = (markbegin, markend)
                    sdcontainer.xpobjs.append(xp)
                    grabtextafterseries = True
                continue
            if node.nodeType == node.ELEMENT_NODE:
                grabtextafterseries = False
                found = 0
                if path == '/FIPS/series':
                    seriesnum = seriesnum + 1
                    if seriesnum == 0:
                        x.mark_set('SeriesGoHere_begin', INSERT)
                        x.mark_gravity('SeriesGoHere_begin', LEFT)
                    sdcontainer = SeriesDataContainer(self.sd_f.sl_f.OBJ, self)
                    self.sd_f.sl_f.sdlist.append(sdcontainer)
                    markbegin ='Series'+sdcontainer.getIdent()+'BeginsHere'
                    if lastnewlineind != -1:
                        x.mark_set(markbegin, lastnewlineind)
                    else:
                        x.mark_set(markbegin, INSERT)
                    x.mark_gravity(markbegin, LEFT)
                    # update series xmlpath component to include object/list,
                    # so it gets an automatic index when needed.
                    xplist = xp.getPath()
                    lastcomp = xplist[-1]
                    del xplist[-1]
                    xp = xmlpath(xplist + [('series',(sdcontainer, self.sd_f.sl_f.sdlist))])
                lastnewlineind = -1
                if path == '/FIPS/series/nameLocal':
                    seriesNameLocal = self.getXMLContent(node)
                for (level, fieldlist) in fields:
                    testlevelname = '/FIPS'
                    if level != '':
                        testlevelname = testlevelname + '/' + level
                    if path[0:path.rfind('/')] != testlevelname:
                        continue
                    for field in fieldlist:
                        if path == testlevelname + '/' + field:
                            if level == '':
                                self.insertXMLTag(field, text=self.getXMLContent(node), indent=None, nonewline=1, xp=xp)
                            elif level == 'series':
                                varname = 'series_'+self.sd_f.sl_f.sdlist[seriesnum].getIdent()+'/'+field
                                self.sdvos[varname] = varobject(StringVar())
                                self.insertXMLTag(field, text=self.getXMLContent(node), varname=varname, indent=None, nonewline=1, xp=xp, container=sdcontainer)
                            else:
                                self.insertXMLTag(field, text=self.getXMLContent(node), varname=level+'/'+field, indent=None, nonewline=1, xp=xp)
                            found = 1
                            break
                    if found:
                        break
                if found:
                    continue
                x.insert(INSERT, '<' + node.localName)
            elif node.nodeType == node.ATTRIBUTE_NODE:
                x.insert(INSERT, ' ' + node.nodeName + '=' + node.nodeValue) 
            elif node.nodeType == node.TEXT_NODE:
                newlinepos = node.nodeValue.find('\n')
                lastnewlineind = -1
                if newlinepos != -1:
                    x.insert(INSERT, node.nodeValue[0:newlinepos+1])
                    if sdcontainer != None and grabtextafterseries:
                        markend ='Series'+sdcontainer.getIdent()+'EndsHere'
                        x.mark_set(markend, INSERT)
                        x.mark_gravity(markend, LEFT)
                    seriesendpos = x.index(INSERT)
                    lastnewlineind = seriesendpos
                    x.insert(INSERT, node.nodeValue[newlinepos+1:])
                else:
                    x.insert(INSERT, node.nodeValue)
            elif node.nodeType == node.CDATA_SECTION_NODE:
                x.insert(INSERT, node.nodeValue)
            elif node.nodeType == node.COMMENT_NODE:
                x.insert(INSERT, '<!--' + node.nodeValue + '-->')
                if parentisdocument:
                    x.insert(INSERT, '\n')

            if node.nodeType == node.ELEMENT_NODE or node.nodeType == node.DOCUMENT_NODE:
                nodeisdoc = node.nodeType == node.DOCUMENT_NODE
                if node.nodeType == node.ELEMENT_NODE:
                    queue.append( (path, xp.clone(), ELEMEND, False) )
                child = node.lastChild
                while child != None:
                    if child.nodeType == child.ATTRIBUTE_NODE:
                        pass
                    elif child.nodeType == child.ELEMENT_NODE:
                        newxp = xp.clone()
                        newxp.addComponent(child.localName, 1)
                        queue.append( (path + '/' + child.localName, newxp, child, nodeisdoc) )
                    else:
                        newxp = xp.clone()
                        newxp.addComponent('?', 1)
                        queue.append( (path + '/?', newxp, child, nodeisdoc) )
                    child = child.previousSibling

            if node.nodeType == node.ELEMENT_NODE:
                queue.append( (path, xp, ATTEND, False) )
                nnm = node.attributes
                for nnmind in range(nnm.length):
                    att = nnm.item(nnmind)
                    queue.append( (path + '/@' + att.localName, xp, att, False) )
#        x.tag_remove('curupdate', '1.0', END) # remove tag that may have been set by varUpdate()
        x['state'] = xsavestate
        dom.unlink()
        x.mark_set('SeriesGoHere_end', seriesendpos)
        x.mark_gravity('SeriesGoHere_end', RIGHT)
        self.fixSeriesVarObjs()
        self.positionSubDirSelectors(10)
        self.saved_signature = self.calcSignature()
        self.xd_f.lastfn = fn

    # Make sure all series-level variables are populated and have text marks.
    # Any known missing fields are given varobjects here with instructions
    # on how to create them in the XML file if they are ever given a value
    def fixSeriesVarObjs(self):
        for sdcontainer in self.sd_f.sl_f.sdlist:
            ident = sdcontainer.getIdent()
            for (lename, comment) in self.ed_f.lenames:
                varname = 'series_'+ident+'/'+lename
                if varname not in self.sdvos:
                    self.sdvos[varname] = varobject(StringVar(), textwrapper=self.xd_f.xml_t, missing=True)
                    self.sdvos[varname].setCreateMissing( ( 'Series'+sdcontainer.getIdent()+'InsertNewContentHere', lename, '    ', comment ) )
                self.sdvos[varname].setTextMarks(self.xd_f.xml_t, varname + '_begin', varname + '_end')
        x = self.xd_f.xml_t.OBJ
        for markname in x.mark_names():
            if markname.startswith('Series') and markname.endswith('InsertNewContentHere'):
                x.mark_gravity(markname, RIGHT)
            
    def saveFile(self):
        x = self.xd_f.xml_t.OBJ
        content = x.get('1.0', END)
        if self.xd_f.lastfn:
            fn = tkFileDialog.asksaveasfilename(initialdir=os.path.dirname(self.xd_f.lastfn))
        else:
            fn = tkFileDialog.asksaveasfilename()
        if not fn:
            return 0
        fp = open(fn, 'w')
        try:
            fp.write(content)
            fp.flush()
            fp.close()
        except IOError, e:
            tkMessageBox.showerror(parent=self.root.OBJ, title='I/O Error', message="Error writing to file:\n" + e)
            return 0
        self.saved_signature = self.calcSignature()
        self.xd_f.lastfn = fn
        return 1

    def updateError(self):
        x = self.xd_f.xml_t.OBJ
        x.tag_remove('curprotocolerror', '1.0', END)
        ef = self.xd_f.v_f.e_f
        numerrors = len(ef.errors)
        errornum = ef.curErrorNum
        self.xd_f.v_f.primaryvar.set("Error #%d (of %d)." % (ef.curErrorNum + 1, numerrors))
        if numerrors == 0:
            ef.prev_b.OBJ.config(state=DISABLED)
            ef.next_b.OBJ.config(state=DISABLED)
        if errornum == 0:
            ef.prev_b.OBJ.config(state=DISABLED)
        else:
            ef.prev_b.OBJ.config(state=NORMAL)
        if errornum == numerrors - 1:
            ef.next_b.OBJ.config(state=DISABLED)
        else:
            ef.next_b.OBJ.config(state=NORMAL)
        [errMsg, nodes, markbegin, markend] = self.xd_f.v_f.e_f.errors[errornum]
        ev1 = ef.em_f.errorvar1
        ev2 = ef.em_f.errorvar2
        errMsgLines = errMsg.splitlines(False)
        if len(errMsgLines) > 0:
            ev1.set(errMsgLines[0])
            ev2.set('\n'.join(errMsgLines[1:]))
        if markbegin and markend:
            foundbegin = False
            foundend = False
            for markname in  x.mark_names():
                if not foundbegin and markname == markbegin:
                    foundbegin = True
                if not foundend and markname == markend:
                    foundend = True
                if foundbegin and foundend:
                    break
            if foundbegin and foundend:
                x.tag_add('curprotocolerror', markbegin, markend)
                # move viewport to this error
                [begline, begcol] = x.index(markbegin).split('.')
                [endline, endcol] = x.index(markend).split('.')
                if begline != endline:
                    x.see('%d.%d' % (int(endline), 0))
                if begcol < 70:
                    x.see('%d.%d' % (int(begline), 0))
                else:
                    x.see(markbegin)
            else:
                self.xd_f.v_f.e_f.errors[errornum] = ['(location where this error occurred has been deleted)', [], None, None]
                self.updateError()

    def prevError(self):
        if self.xd_f.v_f.e_f.curErrorNum > 0:
            self.xd_f.v_f.e_f.curErrorNum = self.xd_f.v_f.e_f.curErrorNum - 1
        self.updateError()
        return 1

    def nextError(self):
        if self.xd_f.v_f.e_f.curErrorNum < len(self.xd_f.v_f.e_f.errors) - 1:
            self.xd_f.v_f.e_f.curErrorNum = self.xd_f.v_f.e_f.curErrorNum + 1
        self.updateError()
        return 1

    def validate(self):
        # hide validation error frame
        self.xd_f.v_f.e_f.OBJ.grid_remove()
        # remove all previous error tags from text
        self.xd_f.xml_t.OBJ.tag_remove('protocolerror', '1.0', END)
        self.xd_f.xml_t.OBJ.tag_remove('curprotocolerror', '1.0', END)
        # reset validation error frame background color
        self.xd_f.v_f.OBJ.config(background=self.xd_f.v_f.defaultbg)
        # look for schematron file based on project name
        protocolfile = None
        projectname = None
        message = ''
        if self.sdvos['project/name']:
            projectname = self.sdvos['project/name'].getValue()
            protocolfile = os.path.dirname(__file__) + '/protocols/' + projectname + '.schematron'
            if not os.path.isfile(protocolfile):
                message = 'Could not find protocol validation (schematron) file for project ' + projectname + '.  '
                protocolfile = None
        if protocolfile:
            if not tkMessageBox.askyesno(title='Validate?', message='Found schematron file: ' + protocolfile + '\nValidate with that file?  (select "No" to choose another file)'):
                message = ''
                protocolfile = None
        if not protocolfile:
            protocolfile = tkFileDialog.askopenfilename(title="Choose schematron protocol file", initialdir=os.path.dirname(__file__)+'/protocols')
        if not protocolfile:
            return 1

        # do validation
        schematron = _Schematron(protocolfile)
        reader = Sax2.Reader()
        doc = reader.fromString(self.xd_f.xml_t.OBJ.get('1.0', END))
        scannermanufacturer = self.sdvos['scannerManufacturer'].getValue()
        protocolErrs = []
        numProtocolErrs = 0
        for phase in [ "FIPS", "FIPS (%s)" % scannermanufacturer, "FIPS GUI", "FIPS GUI (%s)" % scannermanufacturer ]:
            [numerrs, errorMsgs] = schematron.applyToDoc(doc, '<internal>', phase)
            if numerrs < 0:
                tkMessageBox.showerror(parent=self.root.OBJ, title='Schematron Error', message="Error applying Schematron file.")
                return -1
            numProtocolErrs += numerrs
            protocolErrs.extend(errorMsgs)
        self.xd_f.v_f.e_f.errors = map(lambda x: [x[0], x[1], None, None], protocolErrs)
        if numProtocolErrs == 0:
            self.xd_f.v_f.primaryvar.set("No errors.")
        else:
            self.xd_f.v_f.OBJ.config(background='#FF0000')
            self.xd_f.v_f.e_f.OBJ.grid()
            xp2t = {}
            for (xp,marks) in self.xmlpathtotext.iteritems():
                xp2t[xp.getXPath()] = marks
            for errorentry in self.xd_f.v_f.e_f.errors:
                [errMsg, contextnodes, markbegin, markend] = errorentry
                if contextnodes == None:
                    continue
                for contextnode in contextnodes:
                    xpath = ''
                    while contextnode and contextnode.parentNode:
                        localname = contextnode.localName
                        index = xml.xpath.Evaluate('count(preceding-sibling::%s)' % localname, contextnode) + 1
                        xpath = ("/%s[%d]" % (localname, index)) + xpath
                        contextnode = contextnode.parentNode
                    if xp2t.has_key(xpath):
                        (markbegin, markend) = xp2t[xpath]
                        self.xd_f.xml_t.OBJ.tag_add('protocolerror', markbegin, markend)
                        errorentry[2] = markbegin
                        errorentry[3] = markend
            self.xd_f.v_f.e_f.curErrorNum = 0
            self.prevError()
        return 1

    def exit(self):
        if self.saved_signature != self.calcSignature():
            if tkMessageBox.askyesno(title='Save file?', message='Do you wish to save the current file before exiting?'):
                if not self.saveFile():
                    # said they wanted to save, but save failed, so don't exit
                    return
#        for (xp,(markbegin,markend)) in self.xmlpathtotext.iteritems():
#            print "%s => (%s, %s)" % (xp.getXPath(), markbegin, markend)
        sys.exit(0)

    def createLabelEntry(self, name, parent, label, width, orient=HORIZONTAL):
        var = None
        if self.sdvos.has_key(name):
            var = self.sdvos[name].getVar()
        else:
            var = StringVar()
            self.sdvos[name] = varobject(var)
        sdle = labelentry(parent, label=label, width=width, textvariable=var, orient=orient)
        sdle.OBJ.pack(side=TOP)
        self.sdles[name] = sdle
        return sdle

    def attachLabelEntry(self, lename, varname):
        var = None
        if self.sdvos.has_key(varname):
            var = self.sdvos[varname].getVar()
        else:
            var = StringVar()
            self.sdvos[varname] = varobject(var)
        sdle = self.sdles[lename]
        sdle.attachVar(var)
        sdle.entry['state'] = NORMAL

    def detachLabelEntry(self, lename):
        if self.sdles.has_key(lename):
            sdle = self.sdles[lename]
            sdle.detachVar()
            sdle.entry['state'] = DISABLED

    def destroySeriesData(self):
        for sdcont in self.sd_f.sl_f.sdlist:
            ident = sdcont.getIdent()
            for (lename, comment) in self.ed_f.lenames:
                varname = 'series_' + ident + '/' + lename
                if self.sdvos.has_key(varname):
                    self.sdvos[varname].setWriteTrace(None)
                    del self.sdvos[varname]
            sdcont.OBJ.destroy()
        self.sd_f.sl_f.sdlist = []
        for (lename, comment) in self.ed_f.lenames:
            self.detachLabelEntry(lename)

    def chooseBaseDir(self):
        if self.saved_signature != self.calcSignature():
            # file has been modified since last save
            response = tkMessageBox._show(title='Save file?', message='If you select a new base directory,\nthis may overwrite fields you have edited.\nDo you want to save the file first?', type=tkMessageBox.YESNOCANCEL, default=tkMessageBox.YES)
            if response == 'yes':
                if not self.saveFile():
                    # said they wanted to save, but save failed, so don't exit
                    return None
            elif response == 'no':
                pass
            else:
                return None
        else:
            # file has been saved since last modification
            response = tkMessageBox._show(title='Overwrite fields?', message='If you select a new base directory,\nthis may overwrite fields you have edited.\nDo you want to do this?', type=tkMessageBox.YESNO, default=tkMessageBox.NO)
            if response == 'yes':
                pass
            else:
                return None
#        x = self.xd_f.xml_t.OBJ
#        xsavestate = x['state']
#        x['state'] = NORMAL
#        x.delete('SeriesGoHere_begin', 'SeriesGoHere_end')
#        x['state'] = xsavestate
#        self.destroySeriesData()
        if self.xd_f.lastfn:
            self.basedir = tkFileDialog.askdirectory(parent=self.root.OBJ, title='Please choose a base directory', initialdir=os.path.dirname(self.xd_f.lastfn))
        else:
            self.basedir = tkFileDialog.askdirectory(parent=self.root.OBJ, title='Please choose a base directory')
        if len(self.basedir) == 0:
            return None
        self.sd_f.dir_t.OBJ['text'] = self.basedir
        # cache current local names in list
        oldLocalNames = []
        for sdcontainer in self.sd_f.sl_f.sdlist:
            ident = sdcontainer.getIdent()
            nameLocalVarName = 'series_'+sdcontainer.getIdent()+'/nameLocal'
            if self.sdvos.has_key(nameLocalVarName):
                oldLocalNames.append(self.sdvos[nameLocalVarName].getValue())
            else:
                oldLocalNames.append(None)
        earliestDate = None
        earliestTime = None
        self.xd_f.xml_t.OBJ.tag_remove('curupdate', '1.0', END)
        self.xd_f.xml_t.collectUpdates = True
        for file in os.listdir(self.basedir):
            fullpath=os.path.join(self.basedir,file)
            if os.path.isfile(fullpath) and len(fullpath) > 4 and fullpath[-4:] == '.lnk':
                newfullpath = ResolvePseudoLink(fullpath[:-4])
                if newfullpath == None:
                    logging.warn("Skipping malformed pseudo-link '" + fullpath + "'\n")
                    continue
                fullpath = newfullpath
                file = file[:-4]
            if os.path.isdir(fullpath):
                sdcontainer = SeriesDataContainer(self.sd_f.sl_f.OBJ, self)
                sdcontainer.setDirName(file)
                selectorcolor = None
                try:
                    sdcontainer.addSeriesDataFromDirectory(fullpath)
                except IOError, e:
                    tkMessageBox.showerror(parent=self.root.OBJ, title='Error', message=e)
                except ValueError, e:
                    tkMessageBox.showerror(parent=self.root.OBJ, title='Error', message=e)
                except RuntimeError, e:
                    tkMessageBox.showerror(parent=self.root.OBJ, title='Error', message=e)
                if not sdcontainer.sdd.types:
                    continue
                updated = 0
                if sdcontainer.getSeriesData() != None:
                    # see if we already have a series data container with
                    # the same local directory name
                    found = None
                    for index in range(len(oldLocalNames)):
                        if oldLocalNames[index] == file:
                            found = index
                    newmd = sdcontainer.getSeriesData().metadata
                    seriesDate = None
                    seriesTime = None
                    if newmd.has_key("seriesDate"):
                        seriesDate = newmd["seriesDate"]
                    if newmd.has_key("seriesTime"):
                        seriesTime = newmd["seriesTime"]
                    if seriesDate != None and seriesTime != None:
                        if earliestDate == None or earliestTime == None:
                            earliestDate = seriesDate
                            earliestTime = seriesTime
                        else:
                            if seriesDate < earliestDate:
                                earliestDate = seriesDate
                                earliestTime = seriesTime
                            if seriesDate == earliestDate and seriesTime < earliestTime:
                                earliestTime = seriesTime
                    if found != None:
                        # found an existing matching container
                        # so just modify old container with new metadata
                        sdcontainer = self.sd_f.sl_f.sdlist[found]
                        ident = sdcontainer.getIdent()
                        for key in newmd.keys():
                            if key != 'nameLocal' and newmd[key] != None:
                                updated = 1
                                varName = 'series_'+ident + '/' + key
                                if self.sdvos.has_key(varName) and self.sdvos[varName].getValue() != newmd[key]:
                                    self.sdvos[varName].setValue(newmd[key])
                    else:
                        # didn't find an existing matching container
                        # add the directory as a new series
                        updated = 1
                        sdcontainer.addSelector()
                        self.initXMLSeries(sdcontainer)
                        nameLocalVarName = 'series_'+sdcontainer.getIdent()+'/nameLocal'
                        if not self.sdvos.has_key(nameLocalVarName):
                            self.sdvos[nameLocalVarName] = varobject(StringVar())
                        self.sdvos[nameLocalVarName].setUpdateTextInObj(sdcontainer.selector)
                        self.sd_f.sl_f.sdlist.append(sdcontainer)
                if updated:
                    selectorcolor = 'yellow'
                if sdcontainer.selector != None:
                    if selectorcolor == None:
                        selectorcolor = sdcontainer.selector.defaultbg
                    sdcontainer.selector.curbg = selectorcolor
                    sdcontainer.selector.OBJ['background'] = selectorcolor

        if self.sdvos.has_key("visit/visitDate") and self.sdvos.has_key("study/studyTime") and earliestDate != None and earliestTime != None:
            response = tkMessageBox._show(title='Overwrite visitDate and studyTime?', message='Do you want to overwrite visitDate and studyTime with\nthe earliest date/time found?\n(i.e. ' + earliestDate + ' ' + earliestTime + ')', type=tkMessageBox.YESNO, default=tkMessageBox.NO)
            if response == 'yes':
                self.sdvos["visit/visitDate"].setValue(earliestDate)
                self.sdvos["study/studyTime"].setValue(earliestTime)

        self.positionSubDirSelectors(10)

        self.xd_f.xml_t.collectUpdates = False

        return None

    def positionSubDirSelectors(self, maxrows):
        sdlist = self.sd_f.sl_f.sdlist
        numsds = len(sdlist)
        if numsds == 0:
            return
        realmaxrows = (maxrows * 2)
        rownum = 0
        colnum = 0
        for sdnum in range(numsds):
            if rownum >= realmaxrows:
                rownum = 0
                colnum = colnum + 1
            sdlist[sdnum].getSpacerBefore().grid(row=rownum, column=colnum, sticky=N+S+E+W)
            sdlist[sdnum].OBJ.grid(row=rownum+1, column=colnum, sticky=N+S+E+W)
            sdlist[sdnum].removeSpacerAfter()
            rownum = rownum + 2
        sdlist[numsds-1].getSpacerAfter().grid(row=rownum, column=colnum, sticky=N+S+E+W)

    def newSeries(self):
        sdcontainer = SeriesDataContainer(self.sd_f.sl_f.OBJ, self)
        sdcontainer.setDirName("NEWDIR")
        self.sd_f.sl_f.sdlist.append(sdcontainer)
        sdcontainer.addSelector()
        self.initXMLSeries(sdcontainer, metadata={'nameLocal': 'NEWDIR'})
        self.fixSeriesVarObjs()
        nameLocalVarName = 'series_'+sdcontainer.getIdent()+'/nameLocal'
        self.sdvos[nameLocalVarName].setUpdateTextInObj(sdcontainer.selector)
        self.positionSubDirSelectors(10)
        self.chooseSeries(sdcontainer, True, None)

    def getIndex(self, text, index):
        return tuple(map(int, string.split(text.index(index), ".")))

    def moveSeries(self, source, position, target):
        sourceident = source.getIdent()
        targetident = target.getIdent()
        if sourceident == targetident:
            return
        sourcesdnum = 0
        while sourcesdnum < len(self.sd_f.sl_f.sdlist):
            if self.sd_f.sl_f.sdlist[sourcesdnum].getIdent() == sourceident:
                break
            sourcesdnum = sourcesdnum + 1
        if sourcesdnum == len(self.sd_f.sl_f.sdlist):
            return
        targetsdnum = 0
        while targetsdnum < len(self.sd_f.sl_f.sdlist):
            if self.sd_f.sl_f.sdlist[targetsdnum].getIdent() == targetident:
                break
            targetsdnum = targetsdnum + 1
        if targetsdnum == len(self.sd_f.sl_f.sdlist):
            return
        if position == 'before':
            if sourcesdnum < targetsdnum:
                self.sd_f.sl_f.sdlist.insert(targetsdnum, source)
                del self.sd_f.sl_f.sdlist[sourcesdnum]
            elif sourcesdnum > targetsdnum:
                del self.sd_f.sl_f.sdlist[sourcesdnum]
                self.sd_f.sl_f.sdlist.insert(targetsdnum, source)
        elif position == 'after':
            if sourcesdnum < targetsdnum:
                self.sd_f.sl_f.sdlist.insert(targetsdnum+1, source)
                del self.sd_f.sl_f.sdlist[sourcesdnum]
            elif sourcesdnum > targetsdnum:
                del self.sd_f.sl_f.sdlist[sourcesdnum]
                self.sd_f.sl_f.sdlist.insert(targetsdnum+1, source)
        self.positionSubDirSelectors(10)

        markbegin ='Series'+sourceident+'BeginsHere'
        markend ='Series'+sourceident+'EndsHere'
        targetmark = None
        targetgravity = None
        if position == 'before':
            targetmark = 'Series'+targetident+'BeginsHere'
            targetgravity = RIGHT
        else:
            targetmark = 'Series'+targetident+'EndsHere'
            targetgravity = LEFT
        x = self.xd_f.xml_t.OBJ
        xsavestate = x['state']
        x['state'] = NORMAL
        # store original line number for text to be moved
        oldbeginindex = self.getIndex(x, markbegin)
        # store the current mark data (they will get messed up
        # when the text is deleted)
        movemarks = []
        curmark = x.mark_next(markbegin)
        while curmark != markend:
            if curmark.find('/') != -1:
                # only move marks of form series_SERIESNUM/VARNAME
                # otherwise we might accidentally move
                # SeriesXBeingsHere and SeriesXEndsHere marks
                movemarks.append( (curmark, self.getIndex(x, curmark)) )
            curmark = x.mark_next(curmark)
        # move the text
        seriestext = x.get(markbegin, markend)
        x.delete(markbegin, markend)
        x.mark_gravity(targetmark, targetgravity)
        x.mark_set(markbegin, targetmark)
        x.mark_gravity(markbegin, LEFT)
        x.mark_set(INSERT, markbegin)
        x.insert(INSERT, seriestext)
        x.mark_set(markend, INSERT)
        x.mark_gravity(markend, LEFT)
        x.mark_gravity(targetmark, LEFT)
        # find out starting line number where the data was moved and
        # move the marks based on the calculated offset
        newbeginindex = self.getIndex(x, markbegin)
        lineoffset = newbeginindex[0] - oldbeginindex[0]
        for movemark in movemarks:
            markname, oldindex = movemark
            newindexstr = ("%d.%d" % (oldindex[0] + lineoffset, oldindex[1]))
            x.mark_set(markname, newindexstr)
        # fix display to show the moved series in its new location
        x.tag_add('curseries', markbegin, markend)
        x.see('curseries.last')
        x.see('curseries.first')
        x['state'] = xsavestate
        tagname = 'Series' + sourceident
        x.tag_delete(tagname)
        x.tag_config(tagname)
        x.tag_add(tagname, markbegin, markend)
        x.tag_bind(tagname, '<Button-1>', curry(self.chooseSeries, source, False))

    def chooseSeries(self, sdcontainer, move, event):
        ident = sdcontainer.getIdent()
        x = self.xd_f.xml_t.OBJ
        ranges = x.tag_ranges('curseries')
        for i in range(len(ranges))[0:len(ranges):2]:
            x.tag_remove('curseries', ranges[i], ranges[i+1])
        markbegin ='Series'+ident+'BeginsHere'
        markend ='Series'+ident+'EndsHere'
        x.tag_add('curseries', markbegin, markend)
        if move:
            x.see('curseries.last')
            x.see('curseries.first')

        for tmpsdcont in self.sd_f.sl_f.sdlist:
            tmpident = tmpsdcont.ident
            if tmpident == ident:
                tmpsdcont.selector.OBJ['relief'] = SUNKEN
            else:
                tmpsdcont.selector.OBJ['relief'] = RAISED
        
        for (lename, comment) in self.ed_f.lenames:
            varname = 'series_' + ident + '/' + lename
            self.attachLabelEntry(lename, varname)

    def removeSeries(self, sdcontainer, event):
        x = self.xd_f.xml_t.OBJ
        xsavestate = x['state']
        x['state'] = NORMAL
        ident = sdcontainer.getIdent()
        markbegin ='Series'+ident+'BeginsHere'
        markend ='Series'+ident+'EndsHere'
        x.delete(markbegin, markend)
        x.mark_unset(markbegin)
        x.mark_unset(markend)
        x['state'] = xsavestate
        x.tag_delete('Series'+ident)
        sdnum = 0
        while sdnum < len(self.sd_f.sl_f.sdlist):
            if self.sd_f.sl_f.sdlist[sdnum].getIdent() == ident:
                break
            sdnum = sdnum + 1
        if sdnum == len(self.sd_f.sl_f.sdlist):
            return
        for xpobj in sdcontainer.xpobjs:
            del self.xmlpathtotext[xpobj]
        movetosdnum = sdnum
        del self.sd_f.sl_f.sdlist[sdnum]
        if movetosdnum > len(self.sd_f.sl_f.sdlist) - 1:
            movetosdnum = len(self.sd_f.sl_f.sdlist) - 1
        self.positionSubDirSelectors(10)
        if movetosdnum == -1:
            for (lename, comment) in self.ed_f.lenames:
                self.detachLabelEntry(lename)
        else:
            self.chooseSeries(self.sd_f.sl_f.sdlist[movetosdnum], True, None)
        sdcontainer.kill()

    def initTags(self):
        x = self.xd_f.xml_t.OBJ
        x.tag_config('curseries', background='#FFFFFF')
        x.tag_config('curupdate', background='#FFFF88')
        x.tag_config('protocolerror', background='#662222', foreground='white')
        x.tag_config('curprotocolerror', background='#DD0000', foreground='white')

    def initXMLText(self):
        x = self.xd_f.xml_t.OBJ
        xsavestate = x['state']
        x['state'] = NORMAL
        x.mark_set(INSERT, '0.0')
        x.insert(INSERT, '<?xml version="1.0"?>\n')
        x.insert(INSERT, '<!-- This is a configuration file used by the BIRN human upload scripts -->\n')
        x.insert(INSERT, '\n')
        x.insert(INSERT, '<FIPS>\n')
        self.insertXMLTag('FileSystem')
        self.insertXMLTag('BIRNID')
        self.insertXMLTag('acquisitionSiteID')
        self.insertXMLTag('subjectGroup')
        self.insertXMLTag('scannerID')
        self.insertXMLTag('scannerManufacturer')
        x.insert(INSERT, '  <project>\n')
        self.insertXMLTag('name', 'project/name')
        self.insertXMLTag('ID', 'project/ID')
        x.insert(INSERT, '  </project>\n')
        x.insert(INSERT, '  <visit>\n')
        self.insertXMLTag('name', 'visit/name')
        self.insertXMLTag('ID', 'visit/ID')
        self.insertXMLTag('visitDate', 'visit/visitDate')
        self.insertXMLTag('description', 'visit/description')
        x.insert(INSERT, '  </visit>\n')
        x.insert(INSERT, '  <study>\n')
        self.insertXMLTag('name', 'study/name')
        self.insertXMLTag('ID', 'study/ID')
        self.insertXMLTag('studyTime', 'study/studyTime')
        self.insertXMLTag('description', 'study/description')
        x.insert(INSERT, '  </study>\n')
        markbegin = 'SeriesGoHere_begin'
        markend = 'SeriesGoHere_end'
        x.mark_set(markbegin, INSERT)
        x.mark_set(markend, INSERT)
        x.mark_gravity(markbegin, LEFT)
        x.mark_gravity(markend, LEFT)
        x.insert(INSERT, '</FIPS>\n')
        x.mark_gravity(markend, RIGHT)
        x['state'] = xsavestate

    def initXMLSeries(self, sdcont, metadata=None):
        ident = sdcont.getIdent()
        if metadata != None:
            sd = metadata
        elif sdcont.getSeriesData() != None:
            sd = sdcont.getSeriesData().metadata
        else:
            sd = {}
        x = self.xd_f.xml_t.OBJ
        xsavestate = x['state']
        x['state'] = NORMAL
        x.mark_set(INSERT, 'SeriesGoHere_end')
        markbegin ='Series'+ident+'BeginsHere'
        markend ='Series'+ident+'EndsHere'
        x.mark_set(markbegin, INSERT)
        x.mark_gravity(markbegin, LEFT)
        x.insert(INSERT, '  <series>\n')
        for (lename, comment) in self.ed_f.lenames:
            if sd.has_key(lename):
                x.insert(INSERT, '    <!-- ' + comment + '-->\n')
                varname = 'series_' + ident + '/' + lename
                self.sdvos[varname] = varobject(StringVar())
                self.insertXMLTag(lename, varname, text=sd[lename], container=sdcont)
        contentmarkend = 'Series'+ident+'InsertNewContentHere'
        x.mark_set(contentmarkend, INSERT)
        x.mark_gravity(contentmarkend, LEFT)
        x.insert(INSERT, '    <!-- Boiler plate FIPS analysis stuff...nothing needs to be done here -->\n')
        x.insert(INSERT, '    <analysislevel>\n')
        x.insert(INSERT, '      <name>none</name>\n')
        x.insert(INSERT, '      <level>none</level>\n')
        x.insert(INSERT, '    </analysislevel>\n')
        x.insert(INSERT, '  </series>\n')
        x.mark_set(markend, INSERT)
        x.mark_gravity(markend, LEFT)
        x['state'] = xsavestate
        x.tag_config('Series'+ident)
        x.tag_add('Series'+ident, markbegin, markend)
        x.tag_bind('Series'+ident, '<Button-1>', curry(self.chooseSeries, sdcont, False))
        xp = xmlpath([('FIPS', 1), ('series', (sdcont, self.sd_f.sl_f.sdlist))])
        self.xmlpathtotext[xp] = (markbegin, markend)
        sdcont.xpobjs.append(xp)

    def insertXMLTag(self, name, varname=None, text=None, indent='    ', nonewline=0, xp=None, container=None):
        x = self.xd_f.xml_t.OBJ
        if varname == None:
            varname = name
        if indent == None:
            indent = ''
        x.insert(INSERT, indent+'<' + name + '>')
        (markbegin,markend) = self.insertMarks(varname)
        x.insert(INSERT, '</' + name + '>')
        if not nonewline:
            x.insert(INSERT, '\n')
        x.mark_gravity(markend, RIGHT)
        if text != None:
            if self.sdvos.has_key(varname):
                self.sdvos[varname].setMissing(False)
                self.sdvos[varname].setValue(text)
            else:
                x.insert(markbegin, text)
        if not xp:
            xp = xmlpath([('FIPS', 1)])
            for comp in varname.split('/'):
                xp.addComponent(comp, 1)
        self.xmlpathtotext[xp] = (markbegin, markend)
        if container:
            container.xpobjs.append(xp)
        
    def insertMarks(self, name):
        x = self.xd_f.xml_t.OBJ
        markbegin = name + '_begin'
        markend = name + '_end'
        if self.sdvos.has_key(name):
            self.sdvos[name].setTextMarks(self.xd_f.xml_t, markbegin, markend)
        x.mark_set(markbegin, INSERT)
        x.mark_set(markend, INSERT)
        x.mark_gravity(markbegin, LEFT)
        x.mark_gravity(markend, LEFT)
        return (markbegin, markend)
        
    def getXMLContent(self, node):
        retval = ''
        child = node.firstChild
        while child != None:
            if child.nodeType == child.TEXT_NODE:
                retval = retval + child.nodeValue
            child = child.nextSibling
        return retval


#######
# Here is the main procedure that is called if you just
# execute this file

if __name__ == '__main__':
    gui=XMLUploadGUI()
    if len(sys.argv) > 1:
	gui.loadFile(sys.argv[1])
    gui.root.OBJ.mainloop()
