import javax.xml.parsers.*;       // JAXP classes for obtaining a SAX Parser
import org.xml.sax.*;             // The main SAX package
import org.xml.sax.helpers.*;     // SAX helper classes
import java.io.*;                 // For reading the input file
import java.util.*;               // Hashtable, lists, and so on
import java.sql.*;

public class Configure2HID extends org.xml.sax.helpers.DefaultHandler {

    static int exitCode=0;
    StringBuffer accumulator;                   
    String seriesName;
    String seriesTime, studyTime, visitDate, subjectID; 
    String stringName, stringDesc, stringType, stringID;
    int experimentID = -1; 
    int visitID = -1; 
    int studyID = -1; 
    int segmentID = -1; 
    String dbType;

    HashMap segProtocolMap;

    static Statement s = null;
    static Connection conn = null;

    public static void usage() {
       System.err.println("Usage: Configure2HID <xml-file> <user> <pwd> <dbURL-suffix> <[oracle]|postgres>");
       System.exit(-1);
    }

    public static void main(String[] args) 
	throws IOException, SAXException, ParserConfigurationException, SQLException 
    {
        if (args.length != 5) {
           usage();
        }
	SAXParserFactory factory = SAXParserFactory.newInstance();
	factory.setValidating(false);  
	factory.setNamespaceAware(false);
	SAXParser parser = factory.newSAXParser();
        String dbType = args[4]; 
  	String dbURL = "jdbc:oracle:thin:@";
        if (dbType.equalsIgnoreCase("postgres"))
            dbURL = "jdbc:postgresql://";
                
    	dbURL = dbURL + args[3];
        Configure2HID handler = new Configure2HID(dbURL, args[1], args[2], dbType); 
	parser.parse(new File(args[0]), handler);
	System.exit(exitCode);
    }

    Configure2HID(String dbURL, String user, String pwd, String dbType)
    {
        this.dbType = dbType;     
	String driver = "oracle.jdbc.driver.OracleDriver";
        if (dbType.equalsIgnoreCase("postgres"))
            driver = "org.postgresql.Driver";
	segProtocolMap = new HashMap(17);

	segProtocolMap.put("bh", "Breath-Hold (ver100404)");
	segProtocolMap.put("sirp", "SIRP (ver121504)");
	segProtocolMap.put("sm", "Sensory-Motor (ver100404)");
	segProtocolMap.put("AudOdd", "Auditory Oddball (ver110804)");
	segProtocolMap.put("audiosetup", "Audio Setup (ver100404), Phase 1");
	segProtocolMap.put("reactionTime", "Reaction Time (ver100404)");
	segProtocolMap.put("t1", "3D T1 Weighted Scan");
	segProtocolMap.put("t2", "T2 Inplane Scan");
	segProtocolMap.put("B0_mag", "B0 Field Map (Siemens) gre_field_mapping MAGNITUDE");
	segProtocolMap.put("B0_phase", "B0 Field Map Phase (Siemens) gre_field_mapping PHASE");
	segProtocolMap.put("B0_TE1", "B0 Field Map TE1 (GE)");
	segProtocolMap.put("B0_TE2", "B0 Field Map TE2 GE");

        try {
		Class.forName(driver);
		conn = DriverManager.getConnection(dbURL, user, pwd);
        	conn.setAutoCommit(true);
		s = conn.createStatement( );
	}
        catch (Exception e) {
            System.out.println(e);
            if (e instanceof SQLException)
                System.out.println("SQL State: " +
                                   ((SQLException)e).getSQLState( ));
            System.out.println("Usage: java Configure2HID configuration_xml username password db_hoststring");
    	    exitCode=1;
        }

    }

    private int runSql(String sqlStatement, String tName) { 
	boolean status;
  	int rc = -999999;
	
	System.out.println("\n");
	System.out.println(tName + " sql: ");
	System.out.println(sqlStatement);

	try {
	    status = s.execute(sqlStatement);
	    if (status) {
		ResultSet rs = s.getResultSet();  
		if (rs.next()) {
		   rc = rs.getInt(1);
		}
            }
       	}
       	catch (SQLException e) {
               	System.out.println("Configure2HID: " + e.getMessage( )+ ":" +
                               e.getSQLState( ));
    	    exitCode=1;
        }
	return rc;
    }


    // Called at the beginning of parsing.  We use it as an init() method
    public void startDocument() {
	accumulator = new StringBuffer();
    }

    public void characters(char[] buffer, int start, int length) {
	accumulator.append(buffer, start, length);
    }

    public void startElement(String namespaceURL, String localName,
			     String qname, Attributes attributes) {
	accumulator.setLength(0);
	if (qname.equals("ID")) {
		stringID = "-1";
	}
	else if (qname.equals("name")) {
		stringName = "";
	}
	else if (qname.equals("type")) {
		stringType = "";
	}
    }

    protected String getSelectSegmentSql() {
        if (dbType.equalsIgnoreCase("postgres")) {
	     return "select count(*) from nc_expsegment where subjectid = '" + subjectID +
	          "' and nc_experiment_uniqueid = " + experimentID + " and componentid = " + visitID +
		  " and studyid = " +studyID + " and name = '" + seriesName + "'"; 
	} else {
	     return "select count(*) from nc_expsegment where subjectid = '" + subjectID +
	          "' and NC_EXPERIMENT_UNIQUEID = " + experimentID + " and componentid = " + visitID +
		  " and studyid = " +studyID + " and name = '" + seriesName + "'"; 

	}
    }

    protected String getSelectSegmentSql(int segmentID) {
         return "select count(*) from nc_expsegment where subjectid = '" + subjectID +
	         "' and nc_experiment_uniqueid = " + experimentID + " and componentid = " + visitID +
		 " and studyid = " +studyID + " and segmentID = " + segmentID; 
    }

    protected String getMaxSegmentSql() {
        return "select max(segmentid) + 1 from nc_expsegment where subjectid = '" + subjectID +
	       	"' and nc_experiment_uniqueid = " + experimentID + " and componentid = " + visitID +
		" and studyid = " +studyID; 
    }

    protected String getInsertSeriesSql() {
        if (dbType.equalsIgnoreCase("postgres")) {
	        return "insert into nc_expsegment(segmentid, componentid, nc_experiment_uniqueid, subjectid," + 
			"uniqueid, tableid, owner, modtime, moduser, time_stamp, description, " +
			"studyid, protocolversion, protocolid ," +
			"name, timeinterval, istimeinterval, isbad) " +
			"select " + segmentID + ", " + visitID + "," + experimentID + ", '" + subjectID + 
			"', nextval('uid_seq'), tableid, owner, now()," + 
			"moduser, to_timestamp('" + visitDate + " " + seriesTime + "', 'YYYY-MM-DD HH24:MI:SS'),'" +
			stringDesc + "', " + studyID + ", 1, '" + segProtocolMap.get(stringName) + "', '" + seriesName + 
			"', null, 0, 0 from nc_tableid where tablename = 'NC_EXPSEGMENT'";

	} else {
	       return "insert into nc_expSegment(segmentid, COMPONENTID, NC_EXPERIMENT_UNIQUEID, SUBJECTID," + 
			"UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP, DESCRIPTION, " +
			"studyid, protocolversion, protocolid ," +
			"NAME, TIMEINTERVAL, ISTIMEINTERVAL, isbad) " +
			"select " + segmentID + ", " + visitID + "," + experimentID + ", '" + subjectID + 
			"', uid_seq.nextval, tableid, owner, sysdate," + 
			"moduser, to_timestamp('" + visitDate + " " + seriesTime + "', 'YYYY-MM-DD HH24:MI:SS'),'" +
			stringDesc + "', " + studyID + ", 1, '" + segProtocolMap.get(stringName) + "', '" + seriesName + 
			"', null, 0, 0 from nc_tableid where tableName = 'NC_EXPSEGMENT'";
	}
    }

    protected String getInsertVisitSql() {
        if (dbType.equalsIgnoreCase("postgres")) {
	   return "insert into nc_expcomponent(componentid, nc_experiment_uniqueid, subjectid," + 
		"uniqueid, tableid, owner, modtime, moduser, time_stamp, description, visittype," +
		"name, timeinterval, istimeinterval) " +
		"select 1 ," + experimentID + ", '" + subjectID + 
		"', nextval('uid_seq'), tableid, owner, now()," + 
		"moduser, to_timestamp('1900-01-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS'),'" +
		"Please change the date and this description', 'clinical visit', 'clinicalVisit" + 
		"', null, 0 from nc_tableid where tablename = 'NC_EXPCOMPONENT'";

	} else {
	       	return "insert into nc_expComponent(COMPONENTID, NC_EXPERIMENT_UNIQUEID, SUBJECTID," + 
		"UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP, DESCRIPTION, VISITTYPE," +
		"NAME, TIMEINTERVAL, ISTIMEINTERVAL) " +
		"select 1 ," + experimentID + ", '" + subjectID + 
		"', uid_seq.nextval, tableid, owner, sysdate," + 
		"moduser, to_timestamp('1900-01-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS'),'" +
		"Please change the date and this description', 'clinical visit', 'clinicalVisit" + 
		"', null, 0 from nc_tableid where tableName = 'NC_EXPCOMPONENT'";

	}
    }

    protected String getInsertVisitSql2() {
        if (dbType.equalsIgnoreCase("postgres")) {
	      return "insert into nc_expcomponent(componentid, nc_experiment_uniqueid, subjectid," + 
			"uniqueid, tableid, owner, modtime, moduser, time_stamp, description, visittype," +
			"name, timeinterval, istimeinterval) " +
			"select " + visitID + "," + experimentID + ", '" + subjectID + 
			"', nextval('uid_seq'), tableid, owner, now()," + 
			"moduser, to_timestamp('" + visitDate + "', 'YYYY-MM-DD HH24:MI:SS'),'" +
			stringDesc + "', 'scan', '" + stringName + 
			"', null, 0 from nc_tableid where tablename = 'NC_EXPCOMPONENT'";

	} else {
	      return "insert into nc_expComponent(COMPONENTID, NC_EXPERIMENT_UNIQUEID, SUBJECTID," + 
			"UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP, DESCRIPTION, VISITTYPE," +
			"NAME, TIMEINTERVAL, ISTIMEINTERVAL) " +
			"select " + visitID + "," + experimentID + ", '" + subjectID + 
			"', uid_seq.nextval, tableid, owner, sysdate," + 
			"moduser, to_timestamp('" + visitDate + "', 'YYYY-MM-DD HH24:MI:SS'),'" +
			stringDesc + "', 'scan', '" + stringName + 
			"', null, 0 from nc_tableid where tableName = 'NC_EXPCOMPONENT'";
	}
    }


    protected String getInsertStudySql() {
        if (dbType.equalsIgnoreCase("postgres")) {
	        return "insert into nc_expstudy(studyid, componentid, experimentid, subjectid," + 
			"uniqueid, tableid, owner, modtime, moduser, time_stamp, description," +
			"name, timeinterval, istimeinterval) " +
			"select " + studyID + ","  + visitID + "," + experimentID + ", '" + subjectID + 
			"', nextval('uid_seq'), tableid, owner, now()," + 
			"moduser, to_timestamp('" + visitDate + " " + studyTime + "', 'YYYY-MM-DD HH24:MI:SS'),'" +
			stringDesc + "', '" + stringName + 
			"', null, 0 from nc_tableid where tablename = 'NC_EXPSTUDY'";

	} else {
	        return "insert into nc_expStudy(studyid, COMPONENTID, EXPERIMENTID, SUBJECTID," + 
			"UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP, DESCRIPTION," +
			"NAME, TIMEINTERVAL, ISTIMEINTERVAL) " +
			"select " + studyID + ","  + visitID + "," + experimentID + ", '" + subjectID + 
			"', uid_seq.nextval, tableid, owner, sysdate," + 
			"moduser, to_timestamp('" + visitDate + " " + studyTime + "', 'YYYY-MM-DD HH24:MI:SS'),'" +
			stringDesc + "', '" + stringName + 
			"', null, 0 from nc_tableid where tableName = 'NC_EXPSTUDY'";

	}
    }

    protected String getInsertQMSegmentSql() {
        if (dbType.equalsIgnoreCase("postgres")) {
	        return "insert into nc_expsegment(segmentid, componentid, nc_experiment_uniqueid, subjectid," + 
			"uniqueid, tableid, owner, modtime, moduser, time_stamp, description, " +
			"studyid, protocolversion, protocolid ," +
			"name, timeinterval, istimeinterval, isbad) " +
			"select " + segmentID + ", " + visitID + "," + experimentID + ", '" + subjectID + 
			"', nextval('uid_seq'), tableid, owner, now()," + 
			"moduser, to_timestamp('" + visitDate + " " + seriesTime + "', 'YYYY-MM-DD HH24:MI:SS'),'" +
			stringDesc + "', " + studyID + ", 1, 'pre-scan protocol', '" + seriesName + 
			"', null, 0, 0 from nc_tableid where tablename = 'NC_EXPSEGMENT'";

	} else {
	        return "insert into nc_expSegment(segmentid, COMPONENTID, NC_EXPERIMENT_UNIQUEID, SUBJECTID," + 
			"UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP, DESCRIPTION, " +
			"studyid, protocolversion, protocolid ," +
			"NAME, TIMEINTERVAL, ISTIMEINTERVAL, isbad) " +
			"select " + segmentID + ", " + visitID + "," + experimentID + ", '" + subjectID + 
			"', uid_seq.nextval, tableid, owner, sysdate," + 
			"moduser, to_timestamp('" + visitDate + " " + seriesTime + "', 'YYYY-MM-DD HH24:MI:SS'),'" +
			stringDesc + "', " + studyID + ", 1, 'pre-scan protocol', '" + seriesName + 
			"', null, 0, 0 from nc_tableid where tableName = 'NC_EXPSEGMENT'";

	}
    }

    protected String getInsertPostQMSegmentSql() {
        if (dbType.equalsIgnoreCase("postgres")) {
         return "insert into nc_expsegment(segmentid, componentid, nc_experiment_uniqueid, subjectid," + 
		"uniqueid, tableid, owner, modtime, moduser, time_stamp, description, " +
		"studyid, protocolversion, protocolid ," +
		"name, timeinterval, istimeinterval, isbad) " +
		"select " + segmentID + ", " + visitID + "," + experimentID + ", '" + subjectID + 
		"', nextval('uid_seq'), tableid, owner, now()," + 
		"moduser, to_timestamp('" + visitDate + " " + seriesTime + "', 'YYYY-MM-DD HH24:MI:SS'),'" +
		stringDesc + "', " + studyID + ", 1, 'pre-scan protocol', '" + seriesName + 
		"', null, 0, 0 from nc_tableid where tablename = 'NC_EXPSEGMENT'";

	} else {
        return "insert into nc_expSegment(segmentid, COMPONENTID, NC_EXPERIMENT_UNIQUEID, SUBJECTID," + 
		"UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP, DESCRIPTION, " +
		"studyid, protocolversion, protocolid ," +
		"NAME, TIMEINTERVAL, ISTIMEINTERVAL, isbad) " +
		"select " + segmentID + ", " + visitID + "," + experimentID + ", '" + subjectID + 
		"', uid_seq.nextval, tableid, owner, sysdate," + 
		"moduser, to_timestamp('" + visitDate + " " + seriesTime + "', 'YYYY-MM-DD HH24:MI:SS'),'" +
		stringDesc + "', " + studyID + ", 1, 'pre-scan protocol', '" + seriesName + 
		"', null, 0, 0 from nc_tableid where tableName = 'NC_EXPSEGMENT'";

	}
    }


    public void endElement(String namespaceURL, String localName, String qname)
		throws SAXException
    {
	String sql;
	int rowCount = -1; 
	int tempInt = -1; 
        int segmentID = -1; 
	if (qname.equals("series")) {   
	   //only series of these types are added to expsegment
	   if ( stringType.equals("functional") || stringType.equals("behavioral") || stringType.equals("structural")) { 
	        sql = "select count(*) from nc_expsegment where subjectid = '" + subjectID +
	          "' and NC_EXPERIMENT_UNIQUEID = " + experimentID + " and componentid = " + visitID +
		  " and studyid = " +studyID + " and name = '" + seriesName + "'"; 
                sql = getSelectSegmentSql();
    		rowCount = runSql(sql, "series");

		//check if the series is in the database already
		if (rowCount >= 1) {
		   System.out.println("The series, " + seriesName + ", exists in HID for subject-visit-study, " 
			+ subjectID + "-" + visitID + "-" + studyID);
	           throw new SAXException("Series, seriesName,  exists in HID");
		}

		//get segmentID
		try {
			segmentID = Integer.parseInt(stringID);
		}
		catch (NumberFormatException e) {
			segmentID = -1;
		}
	        sql = "select count(*) from nc_expsegment where subjectid = '" + subjectID +
	          	"' and NC_EXPERIMENT_UNIQUEID = " + experimentID + " and componentid = " + visitID +
		  	" and studyid = " +studyID + " and segmentID = " + segmentID; 
		sql = getSelectSegmentSql(segmentID);
		if (runSql(sql, "series") > 0) segmentID = -1;
		if (segmentID < 2) {
	        	sql = "select max(segmentid) + 1 from nc_expsegment where subjectid = '" + subjectID +
	          		"' and NC_EXPERIMENT_UNIQUEID = " + experimentID + " and componentid = " + visitID +
		  		" and studyid = " +studyID; 
                        sql = getMaxSegmentSql();
			segmentID = runSql(sql, "series");
		}

		//get the protocol key
		tempInt = seriesName.length(); 
		//t1 and t2 have just one run
		if (tempInt > 2) tempInt = tempInt - 1;
		stringName = seriesName.substring(0, tempInt);

		//add the serires
	        sql = "insert into nc_expSegment(segmentid, COMPONENTID, NC_EXPERIMENT_UNIQUEID, SUBJECTID," + 
			"UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP, DESCRIPTION, " +
			"studyid, protocolversion, protocolid ," +
			"NAME, TIMEINTERVAL, ISTIMEINTERVAL, isbad) " +
			"select " + segmentID + ", " + visitID + "," + experimentID + ", '" + subjectID + 
			"', uid_seq.nextval, tableid, owner, sysdate," + 
			"moduser, to_timestamp('" + visitDate + " " + seriesTime + "', 'YYYY-MM-DD HH24:MI:SS'),'" +
			stringDesc + "', " + studyID + ", 1, '" + segProtocolMap.get(stringName) + "', '" + seriesName + 
			"', null, 0, 0 from nc_tableid where tableName = 'NC_EXPSEGMENT'";
                sql = getInsertSeriesSql();
    		runSql(sql, "series");
	   }
	}
	else if (qname.equals("type")) {
		stringType = accumulator.toString().trim();
	}
	else if (qname.equals("description")) {
		stringDesc = accumulator.toString().trim();
	}
	if (qname.equals("seriesTime")) {   
		seriesTime = accumulator.toString().trim();
	}
	else if (qname.equals("nameStandard")) {
			seriesName = accumulator.toString().trim();
	}
	else if (qname.equals("BIRNID")) { 
	    	subjectID = accumulator.toString().trim();
	    	sql = "select count(*) from nc_humansubject where subjectid = '" + subjectID + "'";
		if (runSql(sql, "BIRNID") < 1 ) {
		   System.out.println("Cannot find the the subject, "  + subjectID + ", from HID.");
	           throw new SAXException("Incorrect BIRNID, " + subjectID);
		}
	}
	else if (qname.equals("name")) {
		stringName = accumulator.toString().trim();
	}
	else if (qname.equals("studyTime")) {
		studyTime = accumulator.toString().trim();
	}
	else if (qname.equals("visitDate")) {
		visitDate = accumulator.toString().trim();
	}
	else if (qname.equals("ID")) {
		stringID = accumulator.toString().trim();
	}
	else if (qname.equals("project")) { 
	    sql = "select uniqueid from nc_experiment where name = '" + stringName + "__" + stringID + "'";
    		experimentID = runSql(sql, "project");
		if (experimentID < 1) {
		   System.out.println("Cannot find the experiment, "  + stringName + "__" + stringID + ", from HID.");
	           throw new SAXException("The project" + stringName + "__" + stringID + "is not in HID");
		}
	}
	else if (qname.equals("visit")) { 
		//make sure the subject is enrolled to the experiment
	    	sql = "select count(*) from nc_subjexperiment where subjectid = '" + subjectID  +
                  "' and nc_experiment_uniqueid = " + experimentID;
		if (runSql(sql, "visit") < 1 ) {
		   System.out.println("The subject, "  + subjectID + 
                   		", has not been enrolled to the experiment yet");
		   System.out.println("Please use HID web application enroll the subject first");
	           throw new SAXException("Subject is not enrolled to the experiment");
		}
		//validate visitID
		try {
			visitID = Integer.parseInt(stringID);
		}
		catch (NumberFormatException e) {
	             	throw new SAXException("Incorrect visitId, " + stringID);
		}

		if (visitID == 1) {
                   System.out.println("The visit id=1 is reserved for screening visit. Please change the visit id.");
                   throw new SAXException("Incorrect visit");
		}

		//add clinical visit?
		else if ( visitID == 2 ) {
	       		sql = "select count(*) from nc_expcomponent where subjectid = '" + subjectID +
	          	"' and Nc_experiment_uniqueid = " + experimentID + " and componentid = 1"; 
    			rowCount = runSql(sql, "visit");
			if (rowCount < 1) {
				//is the subject enrolled?
	           		sql = "select count(*) from nc_subjexperiment where subjectid = '" + subjectID +
	               		"' and nc_experiment_uniqueid = " + experimentID; 
    		   		rowCount = runSql(sql, "visit");
		   		if (rowCount < 1) throw new SAXException("Subject hasn't been enrolled to the experiment!");

	        		sql = "insert into nc_expComponent(COMPONENTID, NC_EXPERIMENT_UNIQUEID, SUBJECTID," + 
				"UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP, DESCRIPTION, VISITTYPE," +
				"NAME, TIMEINTERVAL, ISTIMEINTERVAL) " +
				"select 1 ," + experimentID + ", '" + subjectID + 
				"', uid_seq.nextval, tableid, owner, sysdate," + 
				"moduser, to_timestamp('1900-01-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS'),'" +
				"Please change the date and this description', 'clinical visit', 'clinicalVisit" + 
				"', null, 0 from nc_tableid where tableName = 'NC_EXPCOMPONENT'";
                                sql =  getInsertVisitSql();
    				rowCount = runSql(sql, "visit 1");
			}
		}

		//does the visit exist?
       		sql = "select count(*) from nc_expcomponent where subjectid = '" + subjectID +
          	"' and nc_experiment_uniqueid = " + experimentID + " and componentid = " + visitID; 
		rowCount = runSql(sql, "visit");
		if (rowCount >= 1) {
               		sql = "select max(componentid) + 1 from nc_expcomponent where subjectid = '" + subjectID +
               		     "' and nc_experiment_uniqueid = " + experimentID;
               		visitID = runSql(sql, "visit");
               		System.out.println("The visit id, " + stringID + ", exists in HID for subject, " + subjectID);
               		System.out.println("The next visitID for this subject is: " + visitID);
               		throw new SAXException("Incorrect visit");
              	}

		//add the visit
	        sql = "insert into nc_expComponent(COMPONENTID, NC_EXPERIMENT_UNIQUEID, SUBJECTID," + 
			"UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP, DESCRIPTION, VISITTYPE," +
			"NAME, TIMEINTERVAL, ISTIMEINTERVAL) " +
			"select " + visitID + "," + experimentID + ", '" + subjectID + 
			"', uid_seq.nextval, tableid, owner, sysdate," + 
			"moduser, to_timestamp('" + visitDate + "', 'YYYY-MM-DD HH24:MI:SS'),'" +
			stringDesc + "', 'scan', '" + stringName + 
			"', null, 0 from nc_tableid where tableName = 'NC_EXPCOMPONENT'";
                sql = getInsertVisitSql2();
    		runSql(sql, "visit");
	}
	else if (qname.equals("study")) { 
		//validate studyID
		try {
			studyID = Integer.parseInt(stringID);
		}
		catch (NumberFormatException e) {
	             	throw new SAXException("Incorrect studyId, " + stringID);
		}

	        sql = "select count(*) from nc_expstudy where subjectid = '" + subjectID +
	          "' and experimentID = " + experimentID + " and componentid = " + visitID +
		  " and studyid = " + studyID; 
    		rowCount = runSql(sql, "study");
		if (rowCount >= 1) {
		   System.out.println("The study id, " + stringID + ", exists in HID for subject-visit, " 
			+ subjectID + "-" + visitID);
	           sql = "select max(studyid) + 1 from nc_expstudy where subjectid = '" + subjectID +
	               "' and experimentid = " + experimentID +
		       " and componentid = " + visitID; 
    		   studyID = runSql(sql, "study");
		   if (studyID < 1) studyID = 1;
		   System.out.println("The next studyID for this subject-visit is: " + studyID);
	           throw new SAXException("Incorrect study ID");
		}
		//add the study
	        sql = "insert into nc_expStudy(studyid, COMPONENTID, EXPERIMENTID, SUBJECTID," + 
			"UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP, DESCRIPTION," +
			"NAME, TIMEINTERVAL, ISTIMEINTERVAL) " +
			"select " + studyID + ","  + visitID + "," + experimentID + ", '" + subjectID + 
			"', uid_seq.nextval, tableid, owner, sysdate," + 
			"moduser, to_timestamp('" + visitDate + " " + studyTime + "', 'YYYY-MM-DD HH24:MI:SS'),'" +
			stringDesc + "', '" + stringName + 
			"', null, 0 from nc_tableid where tableName = 'NC_EXPSTUDY'";
                sql = getInsertStudySql();
    		runSql(sql, "study");

		//add the prescan quickmood serires
		segmentID=1;
		seriesTime="00:00:00";
		seriesName="quickMood1"; 
		stringDesc="Please change the date and this description";
	        sql = "insert into nc_expSegment(segmentid, COMPONENTID, NC_EXPERIMENT_UNIQUEID, SUBJECTID," + 
			"UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP, DESCRIPTION, " +
			"studyid, protocolversion, protocolid ," +
			"NAME, TIMEINTERVAL, ISTIMEINTERVAL, isbad) " +
			"select " + segmentID + ", " + visitID + "," + experimentID + ", '" + subjectID + 
			"', uid_seq.nextval, tableid, owner, sysdate," + 
			"moduser, to_timestamp('" + visitDate + " " + seriesTime + "', 'YYYY-MM-DD HH24:MI:SS'),'" +
			stringDesc + "', " + studyID + ", 1, 'pre-scan protocol', '" + seriesName + 
			"', null, 0, 0 from nc_tableid where tableName = 'NC_EXPSEGMENT'";
                sql = getInsertQMSegmentSql();
    		runSql(sql, "series");
	}
    }

    public void endDocument() {

	String sql;


	//add the postscan quickmood serires
	seriesTime="23:00:00";
	stringDesc="Please change the date and this description";
	sql = "select max(segmentid) + 1 from nc_expsegment where subjectid = '" + subjectID +
		"' and nc_experiment_uniqueid = " + experimentID + " and componentid = " + visitID +
		" and studyid = " +studyID; 
	segmentID = runSql(sql, "quickMood2");
	seriesName="quickMood2"; 
        sql = "insert into nc_expSegment(segmentid, COMPONENTID, NC_EXPERIMENT_UNIQUEID, SUBJECTID," + 
		"UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP, DESCRIPTION, " +
		"studyid, protocolversion, protocolid ," +
		"NAME, TIMEINTERVAL, ISTIMEINTERVAL, isbad) " +
		"select " + segmentID + ", " + visitID + "," + experimentID + ", '" + subjectID + 
		"', uid_seq.nextval, tableid, owner, sysdate," + 
		"moduser, to_timestamp('" + visitDate + " " + seriesTime + "', 'YYYY-MM-DD HH24:MI:SS'),'" +
		stringDesc + "', " + studyID + ", 1, 'pre-scan protocol', '" + seriesName + 
		"', null, 0, 0 from nc_tableid where tableName = 'NC_EXPSEGMENT'";
        sql = getInsertPostQMSegmentSql();
    	runSql(sql, "series");
        System.out.println(segmentID + " series have been added to HID");
        try { s.close( ); } catch (Exception e) {  }
        try { conn.close( ); } catch (Exception e) {  }
    }

    // Issue a warning
    public void warning(SAXParseException exception) {
	System.out.println("WARNING: line " + exception.getLineNumber() + ": "+
			   exception.getMessage());
    }

    // Report a parsing error
    public void error(SAXParseException exception) {
	System.out.println("ERROR: line " + exception.getLineNumber() + ": " +
			   exception.getMessage());
    }

    // Report a non-recoverable error and exit
    public void fatalError(SAXParseException exception) throws SAXException {
	System.out.println("FATAL: line " + exception.getLineNumber() + ": " +
			   exception.getMessage());
	throw(exception);
    }
}
