import java.util.*;
import java.io.*;
import java.sql.*;

public class SqlRunner {

 public static void usage() {
   System.err.println("Usage: SqlRunner <db-url> <user> <pwd> <db-type> <query>");
   System.exit(1);
 }

 public static void main(String[] args) throws Exception {
   int exitCode = 0;
   Connection con = null;
   Statement st = null;
   ResultSet rs = null;
   if (args.length != 5) {
     usage();
   }  
   String query = args[4];
   // query = query.substring(1);
   // query = query.substring(0, query.length() - 1);
   // System.out.println("query="+ query);

   String user = "morph";
   user = args[1];
   String pwd = args[2];
   String dbType = args[3];

   String dbURL = "jdbc:oracle:thin:@"; 
   if (dbType.equalsIgnoreCase("postgres"))
      dbURL = "jdbc:postgresql://";

   dbURL = dbURL + args[0];

   try {
     try {
        String driver = "oracle.jdbc.driver.OracleDriver";
        if (dbType.equalsIgnoreCase("postgres"))
           driver = "org.postgresql.Driver";
        Class.forName(driver);
        con = DriverManager.getConnection(dbURL, user, pwd);
     } catch(Exception ex) {
        exitCode = 1;
        throw ex;
     }
     con.setAutoCommit(false);
     st = con.createStatement();
     String str = query.trim().toLowerCase();
     boolean selectQuery = true;
     if (str.startsWith("delete") || str.startsWith("insert") || str.startsWith("update") ) {
         selectQuery = false;
     }
     if (selectQuery) {
        rs = st.executeQuery(query);
        try {
          ResultSetMetaData rsmt =  rs.getMetaData(); 
          int noCols = rsmt.getColumnCount();
          while( rs.next() ) {
            for(int i=1; i <= noCols; ++i) {
              if (rs.getObject(i) == null) {
                System.out.print("NULL ");
              } else if ((rsmt.getColumnType(i) == java.sql.Types.DECIMAL) || 
                      (rsmt.getColumnType(i) == java.sql.Types.BIT) ||
                      (rsmt.getColumnType(i) == java.sql.Types.TINYINT) ||
                      (rsmt.getColumnType(i) == java.sql.Types.SMALLINT) ||
                      (rsmt.getColumnType(i) == java.sql.Types.INTEGER) ||
                      (rsmt.getColumnType(i) == java.sql.Types.BIGINT) ||
                      (rsmt.getColumnType(i) == java.sql.Types.REAL) ||
                      (rsmt.getColumnType(i) == java.sql.Types.NUMERIC) ||
                      (rsmt.getColumnType(i) == java.sql.Types.DOUBLE)) {
                String valueStr = rs.getObject(i).toString();
                System.out.print(valueStr + " ");
              } else {
                String valueStr = rs.getObject(i).toString();
                System.out.print("\""+ valueStr + "\" ");
              }
            } // for
            System.out.println();
          } //while
        } catch (Exception ex) {
          System.err.println("No results: " + query);
        }
      } else {
         int rc = st.executeUpdate(query);
         System.out.println(rc);
      }
      if (con != null) 
        con.commit();
   } catch(Exception ex) {
      if (con != null) 
         con.rollback();
      ex.printStackTrace();
      exitCode = 2;
      throw ex;
   } finally {
     if (st != null)
       try { st.close(); } catch(Exception x) {}
     if (con != null)
       try { con.close(); } catch(Exception x) {}
   }
   System.exit(exitCode);
 }
}
