/** validate dates in formats: MMDDYYYY or MM*DD*YYYY where * is one of these [-,/,...]
*/
public class Validator
{

	public Validator()
	{
	}

	public static boolean isNumeric (char c)
	{
		if ( !(c > 47 && c < 58)) return false;
		return true;
	}

	public static boolean isAlpha (char c)
	{
		if ( !((c > 64 && c < 91) || (c > 96 && c < 123 ))) return false;
		return true;
	}

	public static boolean isAlphaNumeric (char c)
	{
		if ( isAlpha(c) || isNumeric(c) ) return true;
		return false;
	}

	public static boolean isEmpty(String s)
	{
		if(s == null || s.length() < 1) return true;
		return false;
	}

	public static boolean isNumeric(String s)
	{
		if ( isEmpty(s) ) return false;
		for (int i=0; i < s.length(); i++)
		{
			char c = s.charAt(i);
			if ( !isNumeric(c) ) return false;
		}
		return true;
	}
			
	public static boolean isAlpha(String s)
	{
		if ( isEmpty(s) ) return false;
		for (int i=0; i < s.length(); i++)
		{
			char c = s.charAt(i);
			if ( !isAlpha(c) ) return false;
		}
		return true;
	}
			
	public static boolean isAlphaNumeric(String s)
	{
		if ( isEmpty(s) ) return false;
		for (int i=0; i < s.length(); i++)
		{
			char c = s.charAt(i);
			if ( !isAlphaNumeric(c) ) return false;
		}
		return true;
	}
			
	public static boolean isStringLength(String s, int len)
	{
		if ( s == null ) return false;
		if ( s.length() == len ) return true;
		return false;
	}

	public static boolean isValidDate (String date)
	{
		return isValidDate(date, "MMDDYYYY");
	}
			
	public static boolean isValidDate (String date, String f)
	{
		if(isEmpty(date)) return false;
		date = formatDate(date, f);
		if (!isStringLength(date, 8)) return false;
		if (!isNumeric(date)) return false;
		int m = Integer.parseInt(date.substring(0,2));
		int d = Integer.parseInt(date.substring(2,4));
		int y = Integer.parseInt(date.substring(4,8)); 

		if ( m < 1 || m > 12 ) return false;
		if ( d < 1 || d > 31 ) return false;
		if ( d > 30 && ( m == 2 || m == 4 || m == 6 || m == 9 || m == 11)) return false;
		if ( m == 2 )
		{
			if ( d > 29 ) return false;
			if ( d > 28 )
			{
				if ( y % 100 == 0 )
					if ( y % 400 > 0 ) return false;
				else
					if ( y % 4 > 0 ) return false;
			}
		}
		return true;	
	}

	//format to MMDDYYYY, format string f use MM for month, DD for date, and YYYY for year
	private static String formatDate (String d, String f)
	{
		int fLength = f.length();
		if (fLength < 8 || d.length() != fLength) 
		{
			return d;
		}

		String mm="", dd="", yyyy="";
		String newDate = "";
		char c;

		for (int i=0; i<fLength; i++)
		{
			c=f.charAt(i);
			if ( c == 'M' ) mm = mm + d.charAt(i);
			else if ( c == 'D' ) dd = dd + d.charAt(i);
			else if ( c == 'Y' ) yyyy = yyyy + d.charAt(i);
		}
		fLength = mm.length();
		if ( fLength < 1 || fLength > 2 ) mm = "mm";
		fLength = dd.length();
		if ( fLength < 1 || fLength > 2 ) dd = "dd";
		fLength = yyyy.length();
		if ( fLength < 1 || fLength > 4 ) yyyy = "yyyy";
		if ( fLength == 1 ) mm = "0" + mm;
		if ( fLength == 1 ) dd = "0" + dd;
		if ( fLength == 2 ) yyyy  = "20" + yyyy;
		return mm + dd + yyyy;
	}
 
	public static boolean isValidTime (String date)
	{
		return isValidTime(date, "hhmmss");
	}
			
	//time is hhmmss
	public static boolean isValidTime (String date, String f)
	{
		if(isEmpty(date)) return false;
		date = formatTime(date, f);
		if (!isStringLength(date, 6)) return false;
		if (!isNumeric(date)) return false;
		int h = Integer.parseInt(date.substring(0,2));
		int m = Integer.parseInt(date.substring(2,4));
		int s = Integer.parseInt(date.substring(4,6)); 
		//int f = Integer.parseInt(date.substring(6,date.length())); 

		if ( h < 0 || h > 23 ) return false;
		if ( m < 0 || m > 59 ) return false;
		if ( s < 0 || s > 59 ) return false;
		return true;	
	}

	//format to MMDDYYYY, format string f use MM for month, DD for date, and YYYY for year
	private static String formatTime (String d, String f)
	{
		int fLength = f.length();
		if (fLength < 6 || d.length() != fLength) 
		{
			return d;
		}

		String m="", h="", s="";
		char c;

		for (int i=0; i<fLength; i++)
		{
			c=f.charAt(i);
			if ( c == 'm' ) m = m + d.charAt(i);
			else if ( c == 'h' ) h = h + d.charAt(i);
			else if ( c == 's' ) s = s + d.charAt(i);
		}
		fLength = m.length();
		if ( fLength < 1 || fLength > 2 ) m = "mm";
		fLength = h.length();
		if ( fLength < 1 || fLength > 2 ) h = "dd";
		fLength = s.length();
		if ( fLength < 1 || fLength > 2 ) s = "yy";
		if ( fLength == 1 ) m = "0" + m;
		if ( fLength == 1 ) h = "0" + h;
		if ( fLength == 1 ) s  = "0" + s;
		return h + m + s;
	}
}
