#!/bin/sh

for project in JIV2008 ; do
  if [ ! -d "${project}" ] ; then
    continue
  fi
  for scanner in GE Siemens ; do
    for visit in scanbl scanwk4 scanwk8_dti scanwk8_t1 ; do
      outputfile="${project}_${scanner}_${visit}.xml"
      visitid=${visit}
      extra=
      if [ "${visit}" = 'scanwk8_dti' ] ; then
        visitid=scanwk8
        extra=dti
      elif [ "${visit}" = 'scanwk8_t1' ] ; then
        visitid=scanwk8
        extra=t1
      fi
      rm -f "${outputfile}"
      touch "${outputfile}"
      echo -n "${outputfile}:"
      for fragnum in {0,1,2,3,4,5,6,7,8,9}{0,1,2,3,4,5,6,7,8,9} ; do
	for fragfile in ${project}/frag${fragnum}{_${scanner},}{_${visitid},}{_${extra},} ; do
	  if [ -f ${fragfile} ] ; then
            echo -n " ${fragfile}"
	    cat "${fragfile}" >> "${outputfile}"
	  fi
	done
      done
      echo
    done
  done
done
