/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notes;

import java.sql.Connection;
import java.util.List;
import org.nbirn.fbirn.utilities.ExternalProgressUpdater;

/**
 * Objects implementing this interface define a model for converting paths
 * to/from {@link ExperimentHierarchyItem}s, for filling in incomplete
 * {@link ExperimentHierarchyItem}s based on info in a database, or
 * transferring {@link Note}s to/from the database.
 *
 * @author gadde
 */
public interface ExperimentHierarchyModel {
    
    public URIWithType itemToPath(ExperimentHierarchyItem item);

    public ExperimentHierarchyItem pathToItem(URIWithType path) throws NoteException;

    /**
     * Fill in all available item fields that are unset based on data in the database, if enough info is specified in the other fields.
     * 
     * @param item
     * @param conn
     * @throws NoteException 
     */
    public void fillInItemIDs(ExperimentHierarchyItem item, Connection conn) throws NoteException;

    /**
     * Fill in only item fields that are necessary to insert a note into the database, based on data in the database, if enough info is specified in the other fields.
     * 
     * @param item
     * @param conn
     * @throws NoteException 
     */
    public void fillInItemInsertIDs(ExperimentHierarchyItem item, Connection conn) throws NoteException;

    /**
     * Put notes to the database.
     * @param noteList the list of notes to add to  the database
     * @param conn a {@link Connection} to the database
     * @param createItems if true, create items that don't exist in database.
     * @param updater if not null, an updater to provide progress reports
     * @throws NoteException if any errors occur connecting to or sending/retrieving data from the database.
     */
    public void putNotes(List<? extends Note> noteList, String dbID, Connection conn, boolean createItems, ExternalProgressUpdater updater) throws NoteException;

    /**
     *
     * @param conn a {@link Connection} to the database
     * @param updater if not null, an updater to provide progress reports
     * @return a list of notes from this database.
     * @throws NoteException if any errors occur connecting to or retrieving data from the database.
     */
    public List<Note> getNotes(String dbID, Connection conn, ExternalProgressUpdater updater) throws NoteException;
}
