/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notes;

import java.util.ArrayList;
import java.util.List;
import org.nbirn.fbirn.utilities.ExternalProgressUpdater;
import org.nbirn.fbirn.utilities.ProgressListener;

/**
 *
 * @author gadde
 */
public abstract class NoteSource implements ExternalProgressUpdater {

    ArrayList<ProgressListener> _listeners = null;
    boolean _canceled = false;

    protected NoteSource() {
    }

    public void cancel() {
        _canceled = true;
    }

    public boolean isCanceled() {
        return _canceled;
    }

    public void addProgressListener(ProgressListener listener) {
        if (_listeners == null) {
            _listeners = new ArrayList<ProgressListener>();
        }
        _listeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        if (_listeners == null) {
            return;
        }
        _listeners.remove(listener);
    }

    public void setProgressStart(String msg) {
        if (_listeners == null) {
            return;
        }
        for (ProgressListener listener : _listeners) {
            listener.progressStart(this, msg);
        }
    }

    public void setProgressFinish(String msg) {
        if (_listeners == null) {
            return;
        }
        for (ProgressListener listener : _listeners) {
            listener.progressFinish(this, msg);
        }
    }

    public void setProgress(double progress, String msg) {
        if (_listeners == null) {
            return;
        }
        for (ProgressListener listener : _listeners) {
            listener.progressUpdate(this, progress, msg);
        }
    }

    protected void checkInterrupts() throws NoteException {
        if (Thread.currentThread().isInterrupted()) {
            throw new NoteException("Operation interrupted.");
        }
    }

    /**
     * @return list of all notes provided by this source
     */
    public final List<Note> getNoteList() throws NoteException {
        setProgressStart(null);
        setProgress(0, null);
        try {
            List<Note> retval = getNoteListInternal();
            setProgress(1, null);
            setProgressFinish(null);
            return retval;
        } catch (NoteException e) {
            setProgressFinish("Exception: " + e.getMessage());
            throw e;
        }
    }

    /**
     * @return list of all notes provided by this source
     */
    abstract protected List<Note> getNoteListInternal() throws NoteException;
}
