/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notes;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.nbirn.fbirn.utilities.ProgressListener;
import org.nbirn.fbirn.utilities.ProgressUpdater;
import org.nbirn.fbirn.utilities.ProxyProgressUpdater;

/**
 *
 * @author gadde
 */
public class NoteSourceHID extends NoteSource {

    public static final int SOURCES_UNKNOWN = 0;
    public static final int SOURCES_DESC = 1 << 0;
    public static final int SOURCES_TUPLE = 1 << 1;
    public static final int SOURCES_DESCTUPLE = SOURCES_DESC | SOURCES_TUPLE;
    private static final Logger _logger = Logger.getLogger(NoteSourceHID.class.getName());
    int _sourceTypes = SOURCES_UNKNOWN;
    ExperimentHierarchyModel _model = null;
    String _namespace = null;
    HID _hid = null;

    /**
     * @param namespace namespace to be used for any returned {@link Note}s
     * @param hid {@link HID} object
     */
    public NoteSourceHID(ExperimentHierarchyModel model, String namespace, HID hid, int sourceTypes) {
        _sourceTypes = sourceTypes;
        _model = model;
        _namespace = namespace;
        _hid = hid;
    }

    /**
     * 
     * @return a list of notes from this HID.
     * @throws NoteException if any errors occur reading items from the database.
     */
    @Override
    protected List<Note> getNoteListInternal() throws NoteException {
        ProxyProgressUpdater updater = new ProxyProgressUpdater("HID");
        List<NoteSource> _sources = new ArrayList<NoteSource>();
        if ((_sourceTypes & SOURCES_DESC) != 0) {
            NoteSource source = new NoteSourceHIDDesc(_model, _namespace, _hid);
            _sources.add(source);
            updater.addUpdater(source, "HID from desc");
        }
        if ((_sourceTypes & SOURCES_TUPLE) != 0) {
            NoteSource source = new NoteSourceHIDExtendedTuple(_model, _namespace, _hid);
            _sources.add(source);
            updater.addUpdater(source, "HID from extended tuples");
        }
        updater.addProgressListener(new ProgressListener() {

            @Override
            public void progressStart(ProgressUpdater updater, String msg) {
                setProgressStart(msg);
            }

            @Override
            public void progressUpdate(ProgressUpdater updater, double progress, String msg) {
                setProgress(progress, msg);
            }

            @Override
            public void progressFinish(ProgressUpdater updater, String msg) {
                setProgressFinish(msg);
            }
        });
        List<Note> retval = new ArrayList<Note>();
        for (NoteSource source : _sources) {
            List<Note> sourceRetval = source.getNoteList();
            retval.addAll(sourceRetval);
        }
        return retval;
    }
}
