/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notes;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.nbirn.fbirn.notes.Note;

/**
 *
 * @author gadde
 */
public class NoteTargetFile extends NoteTarget {

    File _file = null;
    boolean _doSort = false;

    public NoteTargetFile(ExperimentHierarchyModel model, File file) {
        super(model);
        _file = file;
    }

    public void setSorted(boolean doSort) {
        _doSort = doSort;
    }

    @Override
    public void putNoteListInternal(List<? extends Note> notelistin) throws NoteException {
        List<? extends Note> notelist = notelistin;
        if (_doSort) {
            List<Note> newNoteList = new ArrayList<Note>(notelist);
            Collections.<Note>sort(newNoteList);
            notelist = newNoteList;
        }
        try {
            FileWriter fw = new FileWriter(_file);
            try {
                BufferedWriter bw = new BufferedWriter(fw);
                try {
                    Iterator<? extends Note> noteiter = notelist.iterator();
                    while (noteiter.hasNext()) {
                        Note note = noteiter.next();
                        String notestr = note.exportToString();
                        bw.write(notestr);
                    }
                } finally {
                    bw.close();
                }
            } finally {
                fw.close();
            }
        } catch (IOException e) {
            throw new NoteException("Error writing notes", e);
        }
    }
}
