/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notes;

import java.util.List;
import java.net.URISyntaxException;
import java.io.File;
import org.nbirn.fbirn.xcede2.catalog.Catalog;
import org.joda.time.DateTimeZone;
import org.joda.time.DateTime;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author gadde
 */
public class NoteSourceCatalogTest {

    private Note _testFieldNote0 = null;
    private Note _testFieldNote1 = null;
    private Note _testFieldNote1wf = null;
    private Note _testFieldNote3 = null;

    public NoteSourceCatalogTest() {
    }

    @Before
    public void setUp() throws URISyntaxException {
        DateTime dt = new DateTime(2011, 1, 31, 8, 30, 45, 100, DateTimeZone.forID("America/New_York"));
        _testFieldNote0 = new Note("testFieldNote0", "testns", "testname", "testvalue", "testcomment", "testauthor", dt, new URIWithType(URIWithType.TYPE_FILE, "file:/my/tmp/file"));
        _testFieldNote1 = new Note("testFieldNote1", "test|ns", "testna|#me", "test|val\\ue", "testcomment", "testauthor", dt, new URIWithType(URIWithType.TYPE_FILE, "file:/my/tmp/file"));
        _testFieldNote1wf = new Note("testFieldNote1", "test|ns", "testna|#me", "test|val\\ue", "testcomment", "testauthor", dt, (URIWithType) null);
        ArrayList<URIWithType> filearray = new ArrayList<URIWithType>();
        filearray.add(new URIWithType(URIWithType.TYPE_DIR, "file:///my/tmp/dir"));
        filearray.add(new URIWithType(URIWithType.TYPE_FILE, "file:///my/tmp/file"));
        _testFieldNote3 = new Note("testFieldNote3", "testns", "testname", "testvalue with </metaField>!*&!'ing XML special characters", "testcomment", "testauthor", dt, filearray);
    }

    @After
    public void tearDown() {
        _testFieldNote0 = null;
        _testFieldNote1 = null;
        _testFieldNote1wf = null;
        _testFieldNote3 = null;
    }

    /**
     * Test of getNoteList method, of class NoteSourceCatalog.
     */
    @Test
    public void testGetNoteList() throws NoteException {
        System.out.println("getNoteList");
        {
            Catalog cat = new Catalog();
            try {
                cat.parseCatalogFile(new File(this.getClass().getResource("testFieldNote0.xml").toURI()));
            } catch (Exception e) {
                fail("Got exception: " + e.getMessage());
            }
            NoteSourceCatalog instance = new NoteSourceCatalog(cat);
            List<Note> expResult = new ArrayList<Note>();
            expResult.add(_testFieldNote0);
            List<Note> result = instance.getNoteList();
            assertEquals(expResult, result);
        }
        {
            Catalog cat = new Catalog();
            try {
                cat.parseCatalogFile(new File(this.getClass().getResource("testFieldNote1.xml").toURI()));
            } catch (Exception e) {
                fail("Got exception: " + e.getMessage());
            }
            NoteSourceCatalog instance = new NoteSourceCatalog(cat);
            List<Note> expResult = new ArrayList<Note>();
            expResult.add(_testFieldNote1);
            List<Note> result = instance.getNoteList();
            assertEquals(expResult, result);
        }
        {
            Catalog cat = new Catalog();
            try {
                cat.parseCatalogFile(new File(this.getClass().getResource("testFieldNote1wf.xml").toURI()));
            } catch (Exception e) {
                fail("Got exception: " + e.getMessage());
            }
            NoteSourceCatalog instance = new NoteSourceCatalog(cat);
            List<Note> expResult = new ArrayList<Note>();
            expResult.add(_testFieldNote1wf);
            List<Note> result = instance.getNoteList();
            assertEquals(expResult, result);
        }
        {
            Catalog cat = new Catalog();
            try {
                cat.parseCatalogFile(new File(this.getClass().getResource("testFieldNote3.xml").toURI()));
            } catch (Exception e) {
                fail("Got exception: " + e.getMessage());
            }
            NoteSourceCatalog instance = new NoteSourceCatalog(cat);
            List<Note> expResult = new ArrayList<Note>();
            expResult.add(_testFieldNote3);
            List<Note> result = instance.getNoteList();
            assertEquals(expResult, result);
        }
        {
            Catalog cat = new Catalog();
            try {
                cat.parseCatalogFile(new File(this.getClass().getResource("testFieldNote-all.xml").toURI()));
            } catch (Exception e) {
                fail("Got exception: " + e.getMessage());
            }
            NoteSourceCatalog instance = new NoteSourceCatalog(cat);
            List<Note> expResult = new ArrayList<Note>();
            expResult.add(_testFieldNote0);
            expResult.add(_testFieldNote1);
            expResult.add(_testFieldNote1wf);
            expResult.add(_testFieldNote3);
            List<Note> result = instance.getNoteList();
            assertEquals(expResult, result);
        }
    }
}
