/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.utilities;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Iterator;

/**
 * This class attempts to address the curious lack of standard (1.4) exception
 * chaining in SQLException.  Wrapping an SQL Exception with this class will
 * mimic standard chaining by translating calls to getCause() to
 * getNextException.
 *
 * @author gadde
 */
public class ChainedSQLException extends SQLException {

    SQLException _e;

    public ChainedSQLException(SQLException e) {
        this(e, e.getCause());
    }

    public ChainedSQLException(SQLException e, Throwable cause) {
        super(cause);
        if (e == null) {
            throw new NullPointerException("Expected a non-null value for exception argument");
        }
        _e = e;
    }

    @Override
    public Throwable getCause() {
        SQLException nexte = _e.getNextException();
        if (nexte != null) {
            return new ChainedSQLException(nexte, super.getCause());
        }
        return super.getCause();
    }

    @Override
    public int getErrorCode() {
        return _e.getErrorCode();
    }

    @Override
    public SQLException getNextException() {
        return _e.getNextException();
    }

    @Override
    public String getSQLState() {
        return _e.getSQLState();
    }

    @Override
    public Iterator<Throwable> iterator() {
        return _e.iterator();
    }

    @Override
    public void setNextException(SQLException ex) {
        _e.setNextException(ex);
    }

    @Override
    public String getLocalizedMessage() {
        return _e.getLocalizedMessage();
    }

    @Override
    public String getMessage() {
        return _e.getMessage();
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return _e.getStackTrace();
    }

    @Override
    public synchronized Throwable initCause(Throwable cause) {
        return _e.initCause(cause);
    }

    @Override
    public void printStackTrace() {
        _e.printStackTrace();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        _e.printStackTrace(s);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        _e.printStackTrace(s);
    }

    @Override
    public void setStackTrace(StackTraceElement[] stackTrace) {
        _e.setStackTrace(stackTrace);
    }

    @Override
    public String toString() {
        return _e.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ChainedSQLException other = (ChainedSQLException) obj;
        return _e.equals(other._e) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return _e.hashCode();
    }
}
