/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.utilities;

import java.util.ArrayList;

/**
 *
 * @author gadde
 */
public class ExceptionCollection extends Exception {

    private ArrayList<Throwable> _list = null;

    public ExceptionCollection() {
        _list = new ArrayList<Throwable>();
    }

    public ArrayList<Throwable> getList() {
        return _list;
    }

    public void add(Throwable e) {
        _list.add(e);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getMessage());
        int numEntries = _list.size();
        for (int i = 0; i < numEntries; i++) {
            Throwable t = _list.get(i);
            if (numEntries > 1) {
                sb.append("\n.---- Error ").append(i + 1).append(": ----------\n");
            }
            String tstr = t.toString();
            tstr = "| " + tstr.substring(0, tstr.length() - 1).replace("\n", "\n| ") + tstr.charAt(tstr.length() - 1);
            sb.append(tstr);
            if (numEntries > 1) {
                sb.append("\n\\______________\n");
            }
        }
        return sb.toString();
    }

    @Override
    public String getMessage() {
        return "" + _list.size() + " error" + ((_list.size() > 1) ? "s" : "");
    }
}
