/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

/**
 *
 * @author gadde
 */
public class PropertySetManager {

    static final Logger _logger = Logger.getLogger(PropertySetManager.class.getName());
    private final int _numsavedprops = 10;
    private Properties _properties = null;
    private Class _refClass = null;
    private String _propBaseName = "app";

    public PropertySetManager() {
        this(PropertySetManager.class);
    }

    /**
     *
     * @param refClass {@link Class} that should be used to determine location of properties file (will be in same directory as the class file corresponding to refClass)
     */
    public PropertySetManager(Class refClass) {
        this(refClass, null);
    }

    public PropertySetManager(Class refClass, String propBaseName) {
        _refClass = refClass;
        if (propBaseName != null) {
            _propBaseName = "app-" + propBaseName;
        }
        try {
            loadProperties();
        } catch (IOException e) {
            // oh well
        }
    }

    public void changeProperty(String name, String value) {
        Vector<String> propset = getPropertySet(name);
        int foundind = propset.indexOf(value);
        if (foundind == 0) {
            // already the most recently used
            return;
        }
        if (foundind != -1) {
            propset.remove(foundind);
        }
        propset.insertElementAt(value, 0);
        try {
            setPropertySet(name, propset);
        } catch (Exception e) {
            // oh well
        }
    }

    public String getProperty(String name) {
        return getProperties().getProperty(name);
    }

    public Vector<String> getPropertySet(String name) {
        Vector<String> retval = new Vector<String>();
        Properties props = getProperties();
        for (int i = 0; i < _numsavedprops; i++) {
            String val = props.getProperty(name + ((i == 0) ? "" : i));
            if (val != null) {
                retval.add(val);
            }
        }
        return retval;
    }

    public void setPropertySet(String name, Vector<String> set) throws IOException {
        Properties props = getProperties();
        for (int i = 0; i < set.size(); i++) {
            props.setProperty(name + ((i == 0) ? "" : i), set.get(i));
        }
        for (int i = set.size(); i < _numsavedprops; i++) {
            props.remove(name + ((i == 0) ? "" : i));
        }
        saveProperties();
    }

    public final Properties getProperties() {
        if (_properties == null) {
            _properties = new Properties();
        }
        return _properties;
    }

    private File getPropertyFile() {
        try {
            File propFile = new File(new File(System.getProperty("user.dir")).getParentFile(), _propBaseName + ".properties");
            return propFile;
        } catch (Exception e) {
            return null;
        }
    }

    private void loadProperties() throws IOException {
        File propFile = getPropertyFile();
        if (propFile != null) {
            _logger.log(Level.INFO, "Loading properties from file ''{0}''", propFile.getPath());
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propFile);
                getProperties().load(fis);
            } catch (Exception e) {
                // don't worry about it
            }
        }
    }

    private void saveProperties() throws IOException {
        File propFile = getPropertyFile();
        if (propFile != null) {
            FileOutputStream fos = new FileOutputStream(propFile);
            getProperties().store(fos, "Written by " + getClass().getName());
        }
    }
}
