/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.utilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 *
 * @author gadde
 */
public class ProxyProgressUpdater extends ProgressListener implements ProgressUpdater {

    List<ProgressListener> _listeners = null;
    List<ProgressUpdater> _updaters = new ArrayList<ProgressUpdater>();
    List<String> _updaterIDs = new ArrayList<String>();
    String _ID = null;
    int _numUpdaters = 0;
    int _numStarted = 0;
    double[] _progressArray = new double[]{};
    boolean[] _startedArray = new boolean[]{};

    public ProxyProgressUpdater() {
        this(null);
    }

    public ProxyProgressUpdater(String ID) {
        super();
        _ID = ID;
    }

    public void addUpdater(ProgressUpdater updater) {
        addUpdater(updater, null);
    }

    public void addUpdater(ProgressUpdater updater, String id) {
        _updaters.add(updater);
        _updaterIDs.add(id);
        _numUpdaters++;
        updater.addProgressListener(this);
        if (_progressArray.length < _numUpdaters) {
            _progressArray = Arrays.copyOf(_progressArray, _updaters.size() * 2); // allocate more to reduce copies
            _startedArray = Arrays.copyOf(_startedArray, _updaters.size() * 2); // allocate more to reduce copies
        }
        _progressArray[_numUpdaters - 1] = 0;
        _startedArray[_numUpdaters - 1] = false;
    }

    public void removeUpdater(ProgressUpdater updater) {
        int ind = _updaters.indexOf(updater);
        if (ind == -1) {
            return;
        }
        if (ind + 1 < _numUpdaters) {
            System.arraycopy(_progressArray, ind + 1, _progressArray, ind, _numUpdaters - (ind + 1));
            System.arraycopy(_startedArray, ind + 1, _startedArray, ind, _numUpdaters - (ind + 1));
        }
        updater.removeProgressListener(this);
        _updaters.remove(ind);
        _updaterIDs.remove(ind);
        _numUpdaters--;
        if (_numUpdaters > 0) {
            reportAggregateProgress(null);
        }
    }

    public void removeAllUpdaters() {
        _updaters.clear();
        _numUpdaters = 0;
        _numStarted = 0;
    }

    // from ProgressUpdater
    public void addProgressListener(ProgressListener listener) {
        if (_listeners == null) {
            _listeners = new ArrayList<ProgressListener>();
        }
        _listeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        if (_listeners == null) {
            return;
        }
        _listeners.remove(listener);
    }

    private String getIDPrefix(int ind) {
        String ID = _updaterIDs.get(ind);
        if (ID == null) {
            if (_numUpdaters > 1) {
                ID = "[" + (ind + 1) + "/" + _numUpdaters + "] ";
            } else {
                ID = "";
            }
        } else {
            ID = "[" + ID + "] ";
        }
        return ID;
    }

    private void reportAggregateProgress(String msg) {
        double sum = 0;
        for (double subProgress : _progressArray) {
            sum += subProgress;
        }
        setProgress(sum / _numUpdaters, msg);
    }

    // from ProgressListener
    @Override
    public void progressStart(ProgressUpdater updater, String msg) {
        int ind = _updaters.indexOf(updater);
        if (ind == -1) {
            return;
        }
        if (msg != null) {
            msg = getIDPrefix(ind) + msg;
        }
        if (_numStarted == 0) {
            setProgressStart(msg);
        } else {
            reportAggregateProgress(msg);
        }
        if (!_startedArray[ind]) {
            _startedArray[ind] = true;
            _numStarted++;
        }
    }

    @Override
    public void progressUpdate(ProgressUpdater updater, double progress, String msg) {
        int ind = _updaters.indexOf(updater);
        if (ind == -1) {
            return;
        }
        if (progress < 0) {
            progress = 0;
        } else if (progress > 1.0) {
            progress = 1.0;
        }
        _progressArray[ind] = progress;
        if (msg != null) {
            msg = getIDPrefix(ind) + msg;
        }
        reportAggregateProgress(msg);
    }

    @Override
    public void progressFinish(ProgressUpdater updater, String msg) {
        int ind = _updaters.indexOf(updater);
        if (ind == -1) {
            return;
        }
        if (_startedArray[ind]) {
            _startedArray[ind] = false;
            _numStarted--;
        }
        if (msg != null) {
            msg = getIDPrefix(ind) + msg;
        }
        if (_numStarted == 0) {
            setProgressFinish(msg);
        } else {
            reportAggregateProgress(msg);
        }
        if (_numStarted == 0 && _ID != null) {
            setProgressFinish("[" + _ID + "] Finished.");
        }
    }

    // publish methods
    protected void setProgressStart(String msg) {
        if (_listeners == null) {
            return;
        }
        for (ProgressListener listener : _listeners) {
            listener.progressStart(this, msg);
        }
    }

    protected void setProgressFinish(String msg) {
        if (_listeners == null) {
            return;
        }
        for (ProgressListener listener : _listeners) {
            listener.progressFinish(this, msg);
        }
    }

    protected void setProgress(double progress, String msg) {
        if (_listeners == null) {
            return;
        }
        for (ProgressListener listener : _listeners) {
            listener.progressUpdate(this, progress, msg);
        }
    }
}
