/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.utilities.download;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

/**
 *
 * @author gadde
 */
public class DownloaderCatalogPanels {
    private JPanel _parentPanel;
    private String _title = null;
    private boolean _hideable;
    private JButton _showButton = null;
    private JButton _hideButton = null;
    private JPanel _subPanel = null;
    private JPanel _hiddenPanel = null;
    private TitledBorder _titledborder = null;
    private boolean _hidden = false;

    public DownloaderCatalogPanels(JPanel parentPanel, String title) throws InterruptedException, InvocationTargetException {
        this(parentPanel, title, true);
    }

    public DownloaderCatalogPanels(JPanel parentPanel, String title, boolean hideable) throws InterruptedException, InvocationTargetException {
        _parentPanel = parentPanel;
        _title = title;
        _hideable = hideable;
        SwingUtilities.invokeAndWait(new Runnable() {

            public void run() {
                GridBagConstraints constraints = new GridBagConstraints();
                JPanel containerPanel = new JPanel(new GridBagLayout());
                constraints.gridx = 0;
                constraints.weightx = 1.0;
                constraints.weighty = 0.0;
                constraints.fill = GridBagConstraints.HORIZONTAL;
                constraints.anchor = GridBagConstraints.NORTH;
                _parentPanel.add(containerPanel, constraints);
                JPanel containerPanel2 = new JPanel(new GridBagLayout());
                _titledborder = BorderFactory.createTitledBorder((_title == null) ? "" : _title);
                containerPanel2.setBorder(_titledborder);
                constraints.gridx = 1;
                constraints.gridy = 0;
                constraints.weightx = 1.0;
                constraints.weighty = 0.0;
                constraints.fill = GridBagConstraints.HORIZONTAL;
                constraints.anchor = GridBagConstraints.NORTH;
                containerPanel.add(containerPanel2, constraints);
                if (_hideable) {
                    constraints.gridx = 0;
                    constraints.gridy = 0;
                    constraints.weightx = 0.0;
                    constraints.weighty = 0.0;
                    constraints.fill = GridBagConstraints.NONE;
                    constraints.anchor = GridBagConstraints.FIRST_LINE_START;
                    ImageIcon showIcon = new ImageIcon(getClass().getResource("/org/nbirn/fbirndownloader/resources/show.png"));
                    _showButton = new JButton(showIcon);
                    _showButton.setPreferredSize(new Dimension(showIcon.getIconWidth(), showIcon.getIconHeight()));
                    containerPanel.add(_showButton, constraints);
                    _showButton.setVisible(false);
                    constraints.gridx = 0;
                    constraints.gridy = 0;
                    constraints.weightx = 0.0;
                    constraints.weighty = 0.0;
                    constraints.fill = GridBagConstraints.NONE;
                    constraints.anchor = GridBagConstraints.FIRST_LINE_START;
                    ImageIcon hideIcon = new ImageIcon(getClass().getResource("/org/nbirn/fbirndownloader/resources/hide.png"));
                    _hideButton = new JButton(hideIcon);
                    _hideButton.setPreferredSize(new Dimension(hideIcon.getIconWidth(), hideIcon.getIconHeight()));
                    containerPanel.add(_hideButton, constraints);
                    _hiddenPanel = new JPanel(new GridBagLayout());
                    constraints.gridx = 1;
                    constraints.gridy = 0;
                    constraints.gridwidth = GridBagConstraints.REMAINDER;
                    constraints.anchor = GridBagConstraints.CENTER;
                    constraints.fill = java.awt.GridBagConstraints.BOTH;
                    constraints.weightx = 1.0;
                    constraints.weighty = 1.0;
                    containerPanel2.add(_hiddenPanel, constraints);
                    _hiddenPanel.setVisible(false);
                }
                _subPanel = new JPanel(new GridBagLayout());
                constraints.gridx = 0;
                constraints.gridy = 0;
                constraints.gridwidth = GridBagConstraints.REMAINDER;
                constraints.anchor = GridBagConstraints.CENTER;
                constraints.fill = java.awt.GridBagConstraints.BOTH;
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                containerPanel2.add(_subPanel, constraints);
                if (_hideable) {
                    updateDisplay();
                    ActionListener _showListener = new ActionListener() {

                        public void actionPerformed(ActionEvent ae) {
                            show();
                        }
                    };
                    _showButton.addActionListener(_showListener);
                    ActionListener _hideListener = new ActionListener() {

                        public void actionPerformed(ActionEvent ae) {
                            hide();
                        }
                    };
                    _hideButton.addActionListener(_hideListener);
                }
            }
        });
    }

    public JPanel getSubPanel() {
        return _subPanel;
    }

    public JPanel getHiddenPanel() {
        return _hiddenPanel;
    }

    public void show() {
        _hidden = false;
        updateDisplay();
    }

    public void hide() {
        _hidden = true;
        updateDisplay();
    }

    private void updateDisplay() {
        if (_hidden) {
            _hideButton.setVisible(false);
            _showButton.setVisible(true);
            _subPanel.setVisible(false);
            _hiddenPanel.setVisible(true);
        } else {
            _showButton.setVisible(false);
            _hideButton.setVisible(true);
            _hiddenPanel.setVisible(false);
            _subPanel.setVisible(true);
        }
    }
    
}
