/*
 */
package org.nbirn.fbirn.utilities.download;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

/**
 *
 * @author gadde
 */
public class ProgressBarListener implements PropertyChangeListener {

    private static final Logger _logger = Logger.getLogger(ProgressBarListener.class.getName());
    JProgressBar _progbar = null;

    public ProgressBarListener(JProgressBar progbar) {
        _progbar = progbar;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("progress".equals(propName)) {
            int val = (Integer) evt.getNewValue();
            _progbar.setIndeterminate(false);
            _progbar.setValue(val);
            _progbar.setString(val + "%");
        } else if ("state".equals(propName) && evt.getNewValue() == SwingWorker.StateValue.DONE) {
            _progbar.setIndeterminate(false);
        }
    }
}

