/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.xcede2.catalog;

import java.io.File;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author gadde
 */
public class DownloadCatalog extends Catalog {

    private static final Logger _logger = Logger.getLogger(DownloadCatalog.class.getName());
    private static final String KEY_DOWNLOAD_STRATEGY = "downloadStrategy";
    private static final String KEY_TIME_ZONE = "timeZone";
    private static final String KEY_TIMESTAMP_CHECK_DEPTH = "timeStampCheckDepth";
    public static final int SOURCE_UNKNOWN = 0;
    public static final int SOURCE_SERIAL = 1;
    public static final int SOURCE_PARALLEL = 2;

    public DownloadCatalog(int downloadtype, String name, File file) throws Exception {
        super(name, file);
    }

    public DownloadCatalog(int downloadtype, String name) {
        super(name);
    }

    public DownloadCatalog() {
        this(SOURCE_UNKNOWN, null);
    }

    @Override
    public DownloadCatalog getCatalog(int index) {
        return (DownloadCatalog) super.getCatalog(index);
    }

    @Override
    public DownloadCatalogEntry getEntry(int index) {
        return (DownloadCatalogEntry) super.getEntry(index);
    }

    public int getDownloadType() {
        return (hasMetaField(KEY_DOWNLOAD_STRATEGY) ? (Integer) getMetaField(KEY_DOWNLOAD_STRATEGY) : SOURCE_UNKNOWN);
    }

    public void setDownloadType(int type) {
        addMetaField(KEY_DOWNLOAD_STRATEGY, new Integer(type));
    }

    public TimeZone getTimeZone() {
        return (hasMetaField(KEY_TIME_ZONE) ? (TimeZone) getMetaField(KEY_TIME_ZONE) : null);
    }

    public void setTimeZone(TimeZone timezone) {
        addMetaField(KEY_TIME_ZONE, timezone);
    }

    public int getTimeStampCheckDepth() {
        return (hasMetaField(KEY_TIMESTAMP_CHECK_DEPTH) ? (Integer) getMetaField(KEY_TIMESTAMP_CHECK_DEPTH) : -1);
    }

    public void setTimeStampCheckDepth(int timeStampCheckDepth) {
        addMetaField(KEY_TIMESTAMP_CHECK_DEPTH, timeStampCheckDepth);
    }

    @Override
    protected CatalogEntry getNewEntry() {
        return new DownloadCatalogEntry();
    }

    @Override
    protected Catalog getNewCatalog() {
        return new DownloadCatalog();
    }

    @Override
    public void addMetaFieldString(String mfname, String mfvalue) {
        if (mfvalue == null) {
            return;
        }
        _logger.log(Level.FINE, "CatalogDownload.addMetaField:     adding name=''{0}'' value=''{1}''", new Object[]{mfname, mfvalue});
        if ("downloadStrategy".equals(mfname)) {
            if (mfvalue.equals("serial")) {
                super.addMetaField(mfname, new Integer(DownloadCatalog.SOURCE_SERIAL));
            } else if (mfvalue.equals("parallel")) {
                super.addMetaField(mfname, new Integer(DownloadCatalog.SOURCE_PARALLEL));
            } else {
                super.addMetaField(mfname, new Integer(DownloadCatalog.SOURCE_UNKNOWN));
            }
        } else if ("timeZone".equals(mfname)) {
            super.addMetaField(mfname, TimeZone.getTimeZone(mfvalue));
        } else if ("timeStampCheckDepth".equals(mfname)) {
            super.addMetaField(mfname, Integer.parseInt(mfvalue));
        }
    }
}
