/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.gui.editor;

import java.util.ArrayList;
import org.nbirn.fbirn.notecollector.nodes.EditorNote;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.chrono.ISOChronology;
import org.nbirn.fbirn.notecollector.nodes.NoteTreePanel;
import org.nbirn.fbirn.notecollector.gui.shared.CredentialKeeper;
import org.nbirn.fbirn.notecollector.gui.shared.GlobalContainer;
import org.nbirn.fbirn.notecollector.nodes.LevelNode;
import org.nbirn.fbirn.notecollector.nodes.NodeByTypeStickyLookup;
import org.nbirn.fbirn.notecollector.nodes.NoteCollectorNode;
import org.nbirn.fbirn.notecollector.nodes.NoteLevel;
import org.nbirn.fbirn.notecollector.nodes.NoteNode;
import org.nbirn.fbirn.notecollector.nodes.hierarchy.HierarchyNoteLevel;
import org.nbirn.fbirn.notecollector.nodes.lists.ForceSelectionNodeList;
import org.nbirn.fbirn.notecollector.nodes.namebased.NameBasedLevels;
import org.nbirn.fbirn.notes.ExperimentHierarchyModel;
import org.nbirn.fbirn.notes.NoteException;
import org.nbirn.fbirn.notes.URIWithType;
import org.nbirn.fbirn.utilities.CanceledException;
import org.nbirn.fbirn.utilities.ExceptionDialog;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
//import org.openide.util.ImageUtilities;
import org.netbeans.api.settings.ConvertAsProperties;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.lookup.ServiceProvider;

/**
 * Top component which displays something.
 */
@ConvertAsProperties(dtd = "-//org.nbirn.fbirn.notecollector.gui.editor//NoteEditor//EN",
autostore = false)
@ServiceProvider(service = NoteEditorTopComponent.class)
public final class NoteEditorTopComponent extends TopComponent implements LookupListener {

    private static NoteEditorTopComponent instance;
    /** path to the icon used by the component and its open action */
//    static final String ICON_PATH = "SET/PATH/TO/ICON/HERE";
    private static final String PREFERRED_ID = "NoteEditorTopComponent";
    private GlobalContainer _gcont = null;
    private Lookup.Result<NoteCollectorNode> _nodeSelectionResult = null;
    private NodeByTypeStickyLookup _nodeSelectionLookup = null;
    private Lookup.Result<NoteTreePanel> _panelResult = null;
    private EditorNote _curNote = null;
    private ForceSelectionNodeList _curNodes = new ForceSelectionNodeList();
    private ExperimentHierarchyModel _model = null;
    private CredentialKeeper _credKeeper = null;
    private boolean _editable = false;
    private boolean _dirty = false;
    private DocumentListener _valueListener = null;

    public NoteEditorTopComponent() {
        initComponents();
        setName(NbBundle.getMessage(NoteEditorTopComponent.class, "CTL_NoteEditorTopComponent"));
        setToolTipText(NbBundle.getMessage(NoteEditorTopComponent.class, "HINT_NoteEditorTopComponent"));
//        setIcon(ImageUtilities.loadImage(ICON_PATH, true));

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        _TopPanel = new javax.swing.JPanel();
        _EditorMessageLabel = new javax.swing.JLabel();
        Path = new javax.swing.JLabel();
        _IDLabel = new javax.swing.JLabel();
        _ID = new javax.swing.JLabel();
        _NamespaceLabel = new javax.swing.JLabel();
        _Namespace = new javax.swing.JTextField();
        _NameLabel = new javax.swing.JLabel();
        _Name = new javax.swing.JTextField();
        _AuthorLabel = new javax.swing.JLabel();
        _Author = new javax.swing.JTextField();
        _DateLabel = new javax.swing.JLabel();
        _Date = new javax.swing.JTextField();
        _TimeLabel = new javax.swing.JLabel();
        _Time = new javax.swing.JTextField();
        _ValueLabel = new javax.swing.JLabel();
        _ValueScrollPane = new javax.swing.JScrollPane();
        _Value = new javax.swing.JTextArea();
        _CommentLabel = new javax.swing.JLabel();
        _CommentScrollPane = new javax.swing.JScrollPane();
        _Comment = new javax.swing.JTextArea();
        _PathsLabel = new javax.swing.JLabel();
        _PathsScrollPane = new javax.swing.JScrollPane();
        _Paths = new javax.swing.JTextPane();
        _ButtonPanel = new javax.swing.JPanel();
        _SaveButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        _TopPanel.setLayout(new java.awt.GridBagLayout());

        _EditorMessageLabel.setForeground(new java.awt.Color(255, 51, 0));
        _EditorMessageLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        org.openide.awt.Mnemonics.setLocalizedText(_EditorMessageLabel, org.openide.util.NbBundle.getMessage(NoteEditorTopComponent.class, "NoteEditorTopComponent._EditorMessageLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TopPanel.add(_EditorMessageLabel, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(Path, org.openide.util.NbBundle.getMessage(NoteEditorTopComponent.class, "NoteEditorTopComponent.Path.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TopPanel.add(Path, gridBagConstraints);

        _IDLabel.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
        _IDLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        org.openide.awt.Mnemonics.setLocalizedText(_IDLabel, org.openide.util.NbBundle.getMessage(NoteEditorTopComponent.class, "NoteEditorTopComponent._IDLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _TopPanel.add(_IDLabel, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TopPanel.add(_ID, gridBagConstraints);

        _NamespaceLabel.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
        _NamespaceLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        org.openide.awt.Mnemonics.setLocalizedText(_NamespaceLabel, org.openide.util.NbBundle.getMessage(NoteEditorTopComponent.class, "NoteEditorTopComponent._NamespaceLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _TopPanel.add(_NamespaceLabel, gridBagConstraints);

        _Namespace.setEditable(false);
        _Namespace.setText(org.openide.util.NbBundle.getMessage(NoteEditorTopComponent.class, "NoteEditorTopComponent._Author.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TopPanel.add(_Namespace, gridBagConstraints);

        _NameLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        _NameLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        org.openide.awt.Mnemonics.setLocalizedText(_NameLabel, org.openide.util.NbBundle.getMessage(NoteEditorTopComponent.class, "NoteEditorTopComponent._NameLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _TopPanel.add(_NameLabel, gridBagConstraints);

        _Name.setEditable(false);
        _Name.setText(org.openide.util.NbBundle.getMessage(NoteEditorTopComponent.class, "NoteEditorTopComponent._Author.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TopPanel.add(_Name, gridBagConstraints);

        _AuthorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        _AuthorLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        org.openide.awt.Mnemonics.setLocalizedText(_AuthorLabel, org.openide.util.NbBundle.getMessage(NoteEditorTopComponent.class, "NoteEditorTopComponent._AuthorLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _TopPanel.add(_AuthorLabel, gridBagConstraints);

        _Author.setEditable(false);
        _Author.setText(org.openide.util.NbBundle.getMessage(NoteEditorTopComponent.class, "NoteEditorTopComponent._Author.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TopPanel.add(_Author, gridBagConstraints);

        _DateLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        _DateLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        org.openide.awt.Mnemonics.setLocalizedText(_DateLabel, org.openide.util.NbBundle.getMessage(NoteEditorTopComponent.class, "NoteEditorTopComponent._DateLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _TopPanel.add(_DateLabel, gridBagConstraints);

        _Date.setEditable(false);
        _Date.setText(org.openide.util.NbBundle.getMessage(NoteEditorTopComponent.class, "NoteEditorTopComponent._Author.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TopPanel.add(_Date, gridBagConstraints);

        _TimeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        _TimeLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        org.openide.awt.Mnemonics.setLocalizedText(_TimeLabel, org.openide.util.NbBundle.getMessage(NoteEditorTopComponent.class, "NoteEditorTopComponent._TimeLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _TopPanel.add(_TimeLabel, gridBagConstraints);

        _Time.setEditable(false);
        _Time.setText(org.openide.util.NbBundle.getMessage(NoteEditorTopComponent.class, "NoteEditorTopComponent._Author.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TopPanel.add(_Time, gridBagConstraints);

        _ValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        _ValueLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        org.openide.awt.Mnemonics.setLocalizedText(_ValueLabel, org.openide.util.NbBundle.getMessage(NoteEditorTopComponent.class, "NoteEditorTopComponent._ValueLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _TopPanel.add(_ValueLabel, gridBagConstraints);

        _Value.setBackground(javax.swing.UIManager.getDefaults().getColor("Label.background"));
        _Value.setColumns(20);
        _Value.setEditable(false);
        _Value.setLineWrap(true);
        _Value.setRows(4);
        _ValueScrollPane.setViewportView(_Value);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TopPanel.add(_ValueScrollPane, gridBagConstraints);

        _CommentLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        _CommentLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        org.openide.awt.Mnemonics.setLocalizedText(_CommentLabel, org.openide.util.NbBundle.getMessage(NoteEditorTopComponent.class, "NoteEditorTopComponent._CommentLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _TopPanel.add(_CommentLabel, gridBagConstraints);

        _Comment.setBackground(javax.swing.UIManager.getDefaults().getColor("Label.background"));
        _Comment.setColumns(20);
        _Comment.setEditable(false);
        _Comment.setLineWrap(true);
        _Comment.setRows(8);
        _Comment.setMinimumSize(new java.awt.Dimension(100, 100));
        _CommentScrollPane.setViewportView(_Comment);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TopPanel.add(_CommentScrollPane, gridBagConstraints);

        _PathsLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        _PathsLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        org.openide.awt.Mnemonics.setLocalizedText(_PathsLabel, org.openide.util.NbBundle.getMessage(NoteEditorTopComponent.class, "NoteEditorTopComponent._PathsLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        _TopPanel.add(_PathsLabel, gridBagConstraints);

        _PathsScrollPane.setBorder(null);

        _Paths.setBackground(javax.swing.UIManager.getDefaults().getColor("Label.background"));
        _Paths.setBorder(null);
        _Paths.setEditable(false);
        _PathsScrollPane.setViewportView(_Paths);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        _TopPanel.add(_PathsScrollPane, gridBagConstraints);

        _ButtonPanel.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(_SaveButton, org.openide.util.NbBundle.getMessage(NoteEditorTopComponent.class, "NoteEditorTopComponent._SaveButton.text")); // NOI18N
        _SaveButton.setEnabled(false);
        _SaveButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                _SaveButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        _ButtonPanel.add(_SaveButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        _TopPanel.add(_ButtonPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.ipady = 100;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(_TopPanel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void _SaveButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event__SaveButtonActionPerformed
        try {
            saveCurrentNote();
        } catch (Exception e) {
            exceptionDialog(e);
        }
    }//GEN-LAST:event__SaveButtonActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel Path;
    private javax.swing.JTextField _Author;
    private javax.swing.JLabel _AuthorLabel;
    private javax.swing.JPanel _ButtonPanel;
    private javax.swing.JTextArea _Comment;
    private javax.swing.JLabel _CommentLabel;
    private javax.swing.JScrollPane _CommentScrollPane;
    private javax.swing.JTextField _Date;
    private javax.swing.JLabel _DateLabel;
    private javax.swing.JLabel _EditorMessageLabel;
    private javax.swing.JLabel _ID;
    private javax.swing.JLabel _IDLabel;
    private javax.swing.JTextField _Name;
    private javax.swing.JLabel _NameLabel;
    private javax.swing.JTextField _Namespace;
    private javax.swing.JLabel _NamespaceLabel;
    private javax.swing.JTextPane _Paths;
    private javax.swing.JLabel _PathsLabel;
    private javax.swing.JScrollPane _PathsScrollPane;
    private javax.swing.JButton _SaveButton;
    private javax.swing.JTextField _Time;
    private javax.swing.JLabel _TimeLabel;
    private javax.swing.JPanel _TopPanel;
    private javax.swing.JTextArea _Value;
    private javax.swing.JLabel _ValueLabel;
    private javax.swing.JScrollPane _ValueScrollPane;
    // End of variables declaration//GEN-END:variables

    /**
     * Gets default instance. Do not use directly: reserved for *.settings files only,
     * i.e. deserialization routines; otherwise you could get a non-deserialized instance.
     * To obtain the singleton instance, use {@link #findInstance}.
     */
    public static synchronized NoteEditorTopComponent getDefault() {
        if (instance == null) {
            instance = new NoteEditorTopComponent();
        }
        return instance;
    }

    /**
     * Obtain the NoteEditorTopComponent instance. Never call {@link #getDefault} directly!
     */
    public static synchronized NoteEditorTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(NoteEditorTopComponent.class.getName()).warning(
                    "Cannot find " + PREFERRED_ID + " component. It will not be located properly in the window system.");
            return getDefault();
        }
        if (win instanceof NoteEditorTopComponent) {
            return (NoteEditorTopComponent) win;
        }
        Logger.getLogger(NoteEditorTopComponent.class.getName()).warning(
                "There seem to be multiple components with the '" + PREFERRED_ID
                + "' ID. That is a potential source of errors and unexpected behavior.");
        return getDefault();
    }

    @Override
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_ALWAYS;
    }

    @Override
    public void componentOpened() {
        _nodeSelectionLookup = new NodeByTypeStickyLookup(Utilities.actionsGlobalContext());
        _nodeSelectionResult = _nodeSelectionLookup.lookupResult(NoteCollectorNode.class);
        _nodeSelectionResult.addLookupListener(this);

        _model = Lookup.getDefault().lookup(ExperimentHierarchyModel.class);
        
        _credKeeper = Lookup.getDefault().lookup(CredentialKeeper.class);

        _gcont = Lookup.getDefault().lookup(GlobalContainer.class);

        _gcont.getContent().add(_nodeSelectionLookup);

        _panelResult = _gcont.getLookup().lookupResult(NoteTreePanel.class);
        _panelResult.addLookupListener(this);
    }

    @Override
    public void componentClosed() {
    }

    private void setDirty(boolean dirty) {
        _dirty = dirty;
        _SaveButton.setEnabled(dirty);
    }

    private void setEditable(boolean editable) {
        _Value.setEditable(editable);
        _Comment.setEditable(editable);
        if (_valueListener != null) {
            // we don't want old listeners hanging around, say, if setEditable(true) is called twice in a row
            _Value.getDocument().removeDocumentListener(_valueListener);
            _Comment.getDocument().removeDocumentListener(_valueListener);
            _valueListener = null;
        }
        if (editable) {
            _Value.setBackground(javax.swing.UIManager.getDefaults().getColor("TextArea.background"));
            _Comment.setBackground(javax.swing.UIManager.getDefaults().getColor("TextArea.background"));
            _valueListener = new DocumentListener() {

                @Override
                public void insertUpdate(DocumentEvent e) {
                    setDirty(true);
                    if (_curNote != null) {
                        _curNote.setDirty(true);
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    setDirty(true);
                    if (_curNote != null) {
                        _curNote.setDirty(true);
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    setDirty(true);
                    if (_curNote != null) {
                        _curNote.setDirty(true);
                    }
                }
            };
            _Value.getDocument().addDocumentListener(_valueListener);
            _Comment.getDocument().addDocumentListener(_valueListener);
        } else {
            _Value.setBackground(javax.swing.UIManager.getDefaults().getColor("Label.background"));
            _Comment.setBackground(javax.swing.UIManager.getDefaults().getColor("Label.background"));
        }
    }

    public void saveCurrentNote() throws NoteException {
        String author = null;
        GSSCredential cred = null;
        try {
            if (_credKeeper != null) {
                cred = _credKeeper.getCredential();
            }
            if (cred != null) {
                author = cred.getName().toString();
            }
        } catch (Exception e) {
            // deal with this below
        }
        if (author == null) {
            throw new NoteException("Error getting current user!\n");
        }
        if (_curNote.getPaths().size() > 1) {
            ArrayList<LevelNode> selectedLevelNodes = new ArrayList<LevelNode>();
            ArrayList<NoteNode> selectedNoteNodes = new ArrayList<NoteNode>();
            Collection c = _nodeSelectionResult.allInstances();
            ArrayList<URIWithType> selectedPaths = new ArrayList<URIWithType>();
            for (Object obj : c) {
                LevelNode levelNode = null;
                if (obj instanceof NoteNode) {
                    levelNode = (LevelNode) ((NoteNode) obj).getParentNode();
                    selectedNoteNodes.add((NoteNode) obj);
                } else if (obj instanceof LevelNode) {
                    levelNode = (LevelNode) obj;
                }
                if (levelNode != null) {
                    NoteLevel level = levelNode.getLevel();
                    if (level instanceof HierarchyNoteLevel) {
                        selectedLevelNodes.add(levelNode);
                        selectedPaths.add(_model.itemToPath(((HierarchyNoteLevel) level).getItem()));
                    } else if (level instanceof NameBasedLevels.Path) {
                        selectedPaths.add(((NameBasedLevels.Path) level).getPath());
                    }
                }
            }
            JTextPane textPane = new JTextPane();
            StyledDocument doc = textPane.getStyledDocument();
            SimpleAttributeSet boldattrs = new SimpleAttributeSet();
            StyleConstants.setBold(boldattrs, true);
            try {
                if (!selectedPaths.isEmpty() && selectedPaths.size() != _curNote.getPaths().size()) {
                    doc.insertString(doc.getLength(), "This note corresponds to several items.  You can save the note to all items, or to just the ", null);
                    doc.insertString(doc.getLength(), "selected ", boldattrs);
                    doc.insertString(doc.getLength(), "items:\n", null);
                } else {
                    doc.insertString(doc.getLength(), "This note corresponds to several items:\n", null);
                }
            } catch (BadLocationException e) {
                // oh well
            }
            StringBuilder pathText = new StringBuilder();
            for (URIWithType path : _curNote.getPaths()) {
                pathText.append(path.toString());
                try {
                    doc.insertString(doc.getLength(), "  " + path.toString() + "\n", (selectedPaths.contains(path) ? boldattrs : null));
                } catch (BadLocationException e) {
                    // oh well
                }
            }
            try {
                if (!selectedPaths.isEmpty()) {
                    doc.insertString(doc.getLength(), "What would you like to do?", null);
                } else {
                    doc.insertString(doc.getLength(), "Is it OK to save this note to all items?", null);
                }
            } catch (BadLocationException e) {
                // oh well
            }
            boolean saveToAll = false;
            boolean saveToSelection = false;
            boolean cancel = false;
            if (!selectedPaths.isEmpty() && selectedPaths.size() != _curNote.getPaths().size()) {
                Object[] options = {"Save to all", "Save to current selection", "Discard edits"};
                int retval = JOptionPane.showOptionDialog(null, textPane, "Saving to multiple items", JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE, null, options, options[0]);
                if (retval == 0) {
                    saveToAll = true;
                } else if (retval == 1) {
                    saveToSelection = true;
                } else if (retval == 2) {
                    cancel = true;
                }
            } else {
                Object[] options = {"Save to all", "Discard edits"};
                int retval = JOptionPane.showOptionDialog(null, textPane, "Saving to multiple items", JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE, null, options, options[0]);
                if (retval == 0) {
                    saveToAll = true;
                } else if (retval == 1) {
                    cancel = true;
                }
            }
            if (cancel) {
                _Comment.setText(_curNote.getComment());
                _curNote.setDirty(false);
                return;
            } else if (saveToSelection) {
                EditorNote newNote = new EditorNote();
                for (URIWithType path : selectedPaths) {
                    _curNote.getPaths().remove(path);
                }
                for (NoteNode noteNode : selectedNoteNodes) {
                    noteNode.setNote(newNote);
                }
                newNote.setPaths(selectedPaths);
                _curNote.setDirty(false); // old note will retain old values except for paths
                _curNote = newNote;
            }
        }
        _curNote.setNamespace(_Namespace.getText());
        _curNote.setName(_Name.getText());
        _curNote.setAuthor(author);
        _curNote.setTimeStamp(new DateTime());
        _curNote.setValue(_Value.getText());
        _curNote.setComment(_Comment.getText());
        _curNote.setEdited(true);
        _curNote.setDirty(false);
        setDirty(false);
        setEditable(false);
        checkPrivs();
    }

    private void changedNote(boolean force) {
        Collection<? extends NoteCollectorNode> selectedNodeList = _nodeSelectionResult.allInstances();
        if (selectedNodeList != null && !selectedNodeList.isEmpty()) {
            boolean newSelectionIsSubset = false;
            newSelectionIsSubset = true;
            for (NoteCollectorNode node : selectedNodeList) {
                if (!_curNodes.contains(node)) {
                    newSelectionIsSubset = false;
                    break;
                }
            }
            if (!force && newSelectionIsSubset) {
                // don't need to be concerned
                return;
            }
            EditorNote note = null;
            for (NoteCollectorNode node : selectedNodeList) {
                if (node instanceof NoteNode) {
                    EditorNote newNote = ((NoteNode) node).getNote();
                    if (note != null && newNote != note) {
                        // found two different notes
                        note = null;
                        break;
                    }
                    note = newNote;
                }
            }
            if (force || note != _curNote) {
                if (_dirty) {
                    while (true) {
                        String addmsg = "";
                        int opt = JOptionPane.showOptionDialog(this,
                                addmsg + "You are currently editing this note.  What do you want to do?",
                                "Oops... editing!",
                                JOptionPane.NO_OPTION,
                                JOptionPane.QUESTION_MESSAGE,
                                null,
                                new Object[]{"Ignore new selection and\ncontinue editing this note", "Save edits and move to new note", "Discard edits"},
                                "Continue editing this note");
                        if (opt == 0) {
                            ForceSelectionNodeList oldNodeList = _gcont.getLookup().lookup(ForceSelectionNodeList.class);
                            if (oldNodeList != null) {
                                _gcont.getContent().remove(oldNodeList);
                            }
                            _gcont.getContent().add(_curNodes);
                            return;
                        } else if (opt == 1) {
                            try {
                                saveCurrentNote();
                                break;
                            } catch (NoteException e) {
                                addmsg = e.getMessage();
                            }
                        } else if (opt == 2) {
                            break;
                        }
                    }
                }
                setEditable(false); // will also turn off text area listeners (good thing)
                if (note == null) {
                    _ID.setText("");
                    _Namespace.setText("");
                    _Name.setText("");
                    _Date.setText("");
                    _Time.setText("");
                    _Author.setText("");
                    _Value.setText("");
                    _Comment.setText("");
                    _Paths.setText("");
                } else {
                    _ID.setText(note.getID());
                    _Namespace.setText(note.getNamespace());
                    _Name.setText(note.getName());
                    ISOChronology chron = ISOChronology.getInstance(); // default (local) time zone
                    DateTime dt = note.getTimeStamp();
                    _Date.setText(new LocalDate(dt.getMillis(), chron).toString());
                    _Time.setText(new LocalTime(dt.getMillis(), chron).toString());
                    _Author.setText(note.getAuthor());
                    _Value.setText(note.getValue());
                    _Comment.setText(note.getComment());
                    StringBuilder pathText = new StringBuilder();
                    boolean first = true;
                    for (URIWithType path : note.getPaths()) {
                        if (!first) {
                            pathText.append("\n");
                        }
                        pathText.append(path.toString());
                        first = false;
                    }
                    _Paths.setText(pathText.toString());
                }
                _curNote = note;
                setDirty((_curNote == null ? false : _curNote.isDirty()));
            }
        }
    }

    private void checkPrivs() {
        if (_curNote != null && _credKeeper != null) {
            try {
                GSSCredential cred = _credKeeper.getCredential();
                try {
                    String user = cred.getName().toString();
                    if (user.equals(_curNote.getAuthor())) {
                        setEditable(true);
                    } else {
                        setEditable(false);
                    }
                } catch (GSSException e) {
                    exceptionDialog(e);
                    return;
                }
            } catch (CanceledException e) {
                _EditorMessageLabel.setText("Error getting current user: " + e.toString());
                setEditable(false);
            } catch (NoteException e) {
                _EditorMessageLabel.setText("Error getting current user: " + e.toString());
                setEditable(false);
            }
        } else if (_curNote != null) {
            setEditable(true);
        }
    }

    @Override
    public void resultChanged(LookupEvent lookupEvent) {
        setEditable(false); // so that we don't get document notifications when we change value field
        if (lookupEvent.getSource() == _nodeSelectionResult) {
            changedNote(false);
        }
        if (lookupEvent.getSource() == _panelResult) {
            Collection<? extends NoteTreePanel> c = _panelResult.allInstances();
            if (!c.isEmpty()) {
                _nodeSelectionLookup.setType(c.iterator().next().getNodeType());
            }
        }
        checkPrivs();
    }

    private void exceptionDialog(Exception e) {
        ExceptionDialog.show(this, e);
    }

    void writeProperties(java.util.Properties p) {
        // better to version settings since initial version as advocated at
        // http://wiki.apidesign.org/wiki/PropertyFiles
        p.setProperty("version", "1.0");
        // TODO store your settings
    }

    Object readProperties(java.util.Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(java.util.Properties p) {
        String version = p.getProperty("version");
        // TODO read your settings according to their version
    }

    @Override
    protected String preferredID() {
        return PREFERRED_ID;
    }
}
