/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.gui.io;

import java.awt.Dimension;
import javax.swing.JComboBox;

/**
 * This is a JComboBox whose preferred size is the non-editable preferred size.
 * @author gadde
 */
public class ComboBoxWithUneditableSize extends JComboBox {

    private boolean forceEditable = false;
    private boolean forceEditableState;

    public Dimension getPreferredSize() {
        forceEditable = true;
        forceEditableState = false;
        Dimension nonEditableSize = super.getPreferredSize();
        forceEditable = false;
//        return nonEditableSize;
        return new Dimension(200, nonEditableSize.height);
    }

    public boolean isEditable() {
        if (forceEditable) {
            return forceEditableState;
        }
        return super.isEditable();
    }
}
