/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.gui.io;

import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import org.openide.util.Exceptions;

/**
 *
 * @author gadde
 */
public class TextAreaHandler extends Handler {

    JTextArea _area = null;
    int _curOffset = 0;
    Queue<String> _queue = null;

    public TextAreaHandler() {
        this(null, new SimpleFormatter());
    }

    public TextAreaHandler(JTextArea area, Formatter formatter) {
        _area = area;
        this.setFormatter(formatter);
        _queue = new LinkedBlockingQueue<String>();
        Executors.newSingleThreadExecutor().execute(new Runnable() {

            public void run() {
                while (true) {
                    StringBuilder sb = new StringBuilder();
                    if (!_queue.isEmpty()) {
                        synchronized (_queue) {
                            while (!_queue.isEmpty()) {
                                sb.append(_queue.poll());
                            }
                        }
                        Document doc = _area.getDocument();
                        _area.append(sb.toString());
                        _curOffset += sb.length();
                    }
                    try {
                        Thread.sleep(100);
                    } catch (InterruptedException ex) {
                        return;
                    }
                }
            }
        });
    }

    @Override
    public void publish(LogRecord record) {
        if (_area != null) {
            String str = getFormatter().format(record);
            synchronized (_queue) {
                _queue.offer(str);
            }
        }
    }

    @Override
    public void flush() {
        // nothing to do
    }

    @Override
    public void close() throws SecurityException {
        // nothing to do
    }
}
