/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.gui.io;

import java.awt.Rectangle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.util.Exceptions;

/**
 *
 * @author gadde
 */
public class TextPaneHandler extends Handler {

    JTextPane _pane = null;
    int _curOffset = 0;

    public TextPaneHandler() {
        this(null, new SimpleFormatter());
    }

    public TextPaneHandler(JTextPane area, Formatter formatter) {
        _pane = area;
        this.setFormatter(formatter);
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (_pane != null) {
            String str = getFormatter().format(record);
            //try {
                Document doc = _pane.getDocument();
                _pane.setCaretPosition(doc.getLength());
                _pane.setEditable(true);
                _pane.replaceSelection(str);
                _pane.setEditable(false);
                //Rectangle r = _pane.modelToView(doc.getLength());
                //if (r != null) {
                //    _pane.scrollRectToVisible(r);
                //}
            //} catch (BadLocationException ex) {
            //    Exceptions.printStackTrace(ex);
            //}
            _curOffset += str.length();
        }
    }

    @Override
    public void flush() {
        // nothing to do
    }

    @Override
    public void close() throws SecurityException {
        // nothing to do
    }
}
