/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.nodes;

import java.util.ArrayList;
import org.joda.time.DateTime;
import org.nbirn.fbirn.notes.Note;
import org.nbirn.fbirn.notes.URIWithType;

/**
 *
 * @author gadde
 */
public class EditorNote extends Note implements EditorNotePublisher {

    ArrayList<EditorNoteListener> _listeners = new ArrayList<EditorNoteListener>();
    private boolean _edited = false;
    private boolean _dirty = false;

    public EditorNote(String ID, String namespace, String name, String value, String comment, String author, DateTime timeStamp, ArrayList<URIWithType> files) {
	super(ID, namespace, name, value, comment, author, timeStamp, files);
    }

    public EditorNote(String ID, String namespace, String name, String value, String comment, String author, DateTime timeStamp, URIWithType file) {
	super(ID, namespace, name, value, comment, author, timeStamp, file);
    }

    public EditorNote() {
	super();
    }

    public EditorNote(Note note) {
	super(note.getID(), note.getNamespace(), note.getName(), note.getValue(), note.getComment(), note.getAuthor(), note.getTimeStamp(), note.getPaths());
    }

    public boolean isEdited() {
	return _edited;
    }

    public void setEdited(boolean edited) {
        boolean doPublish = (_edited != edited);
	_edited = edited;
        if (doPublish) {
            publishNote();
        }
    }

    public boolean isDirty() {
	return _dirty;
    }

    public void setDirty(boolean dirty) {
        boolean doPublish = (_dirty != dirty);
	_dirty = dirty;
        if (doPublish) {
            publishNote();
        }
    }

    @Override
    public void publishNote() {
        for (EditorNoteListener listener : _listeners) {
            listener.changedNote(this);
        }
    }

    @Override
    public void addNoteListener(EditorNoteListener listener) {
        _listeners.add(listener);
    }

    @Override
    public void removeNoteListener(EditorNoteListener listener) {
        _listeners.remove(listener);
    }

    @Override
    public void removeAllNoteListeners() {
        _listeners.clear();
    }
}
