/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.nodes;

import org.nbirn.fbirn.notecollector.nodes.lists.EditorNoteList;
import org.nbirn.fbirn.notecollector.nodes.hierarchy.HierarchyLevelNode;
import org.nbirn.fbirn.notecollector.nodes.hierarchy.HierarchyNoteLevel;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.nbirn.fbirn.notecollector.gui.shared.CredentialKeeper;
import org.nbirn.fbirn.notecollector.gui.shared.GlobalContainer;
import org.nbirn.fbirn.notecollector.nodes.lists.ForceSelectionNodeList;
import org.nbirn.fbirn.notes.ExperimentHierarchyModel;
import org.nbirn.fbirn.notes.NoteException;
import org.nbirn.fbirn.notes.NotePrivileges;
import org.nbirn.fbirn.notes.URIWithType;
import org.nbirn.fbirn.utilities.CanceledException;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.actions.NodeAction;

/**
 *
 * @author gadde
 */
public class NewNoteAction extends NodeAction implements LookupListener {

    NewNotePanel _panel = null;
    private CredentialKeeper _credKeeper = null;
    private ExperimentHierarchyModel _model = null;
    private GlobalContainer _gcont = null;
    private ExplorerManager _explorerManager = null;
    private Lookup.Result<NodeByTypeStickyLookup> _nodeSelectorResult = null;
    private NodeByTypeStickyLookup _nodeSelectionLookup = null;

    public NewNoteAction() {
        super();
        getPanel();
        _credKeeper = Lookup.getDefault().lookup(CredentialKeeper.class);
        _model = Lookup.getDefault().lookup(ExperimentHierarchyModel.class);
        _gcont = Lookup.getDefault().lookup(GlobalContainer.class);
        _nodeSelectorResult = _gcont.getLookup().lookupResult(NodeByTypeStickyLookup.class);
        getNodeSelector();
    }

    private void getNodeSelector() {
        Collection<? extends NodeByTypeStickyLookup> c = _nodeSelectorResult.allInstances();
        if (!c.isEmpty()) {
            _nodeSelectionLookup = c.iterator().next();
        }
    }

    private void getPanel() {
        _panel = Lookup.getDefault().lookup(NewNotePanel.class);
    }

    @Override
    protected void performAction(Node[] nodes) {
        Collection<? extends HierarchyLevelNode> hierNodeList = getSelectedHierarchyLevelNodes();
        if (hierNodeList == null || hierNodeList.isEmpty()) {
            return;
        }
        int retval = JOptionPane.showConfirmDialog(null, _panel, "Creating new note", JOptionPane.OK_CANCEL_OPTION);
        if (retval == JOptionPane.CANCEL_OPTION) {
            return;
        }
        String ns = _panel.getNoteNamespace();
        String name = _panel.getNoteName();
        String author = null;
        GSSCredential cred = null;
        try {
            if (_credKeeper != null) {
                cred = _credKeeper.getCredential();
            }
        } catch (CanceledException e) {
            return;
        } catch (NoteException e) {
            JOptionPane.showMessageDialog(null, "Error getting credential: " + e.toString(), "Error", JOptionPane.ERROR_MESSAGE);
            return;
        }
        if (cred != null) {
            try {
                author = cred.getName().toString();
            } catch (GSSException e) {
                JOptionPane.showMessageDialog(null, "Error getting current user: " + e.toString(), "Error", JOptionPane.ERROR_MESSAGE);
                return;
            }
        }
        NotePrivileges privs = _gcont.getLookup().lookup(NotePrivileges.class);
        boolean allow = false;
        int numRejectMsgs = 0;
        String rejectMsg = "";
        if (privs == null) {
            allow = true;
        } else {
            int priv = privs.getPrivilege(ns, name, author);
            if (priv == NotePrivileges.PRIV_ALLOW_ONE) {
                for (HierarchyLevelNode levelNode : hierNodeList) {
                    HierarchyNoteLevel level = levelNode.getLevel();
                    EditorNoteList otherNotes = level.getNotes();
                    for (EditorNote note : otherNotes) {
                        if (ns.equals(note.getNamespace()) && name.equals(note.getName())) {
                            allow = false;
                            numRejectMsgs++;
                            rejectMsg += "(" + numRejectMsgs + ") You only have privileges to create one note with namespace '" + ns + "' and name '" + name + "', but there is already one in this context: " + _model.itemToPath(level.getItem()) + "\n";
                        }
                    }
                }
            } else if (priv == NotePrivileges.PRIV_REJECT) {
                allow = false;
                rejectMsg += "You do not have privileges to create a note with namespace '" + ns + "' and name '" + name + "'.\n";
            } else {
                allow = true;
            }
        }
        if (allow) {
            ArrayList<URIWithType> paths = new ArrayList<URIWithType>();
            EditorNote newNote = new EditorNote();
            newNote.setNamespace(ns);
            newNote.setName(name);
            newNote.setAuthor(author);
            for (HierarchyLevelNode levelNode : hierNodeList) {
                HierarchyNoteLevel level = levelNode.getLevel();
                paths.add(_model.itemToPath(level.getItem()));
                levelNode.getChildFactory().addNote(newNote);
            }
            newNote.setPaths(paths);
            EditorNoteList baseList = _gcont.getLookup().lookup(EditorNoteList.class);
            if (baseList != null) {
                baseList.add(newNote);
            }
            ForceSelectionNodeList newSelectedNodes = new ForceSelectionNodeList();
            for (LevelNode levelNode : hierNodeList) {
                for (Node childNode : levelNode.getChildren().getNodes()) {
                    if (childNode instanceof NoteNode) {
                        NoteNode noteNode = (NoteNode) childNode;
                        if (noteNode.getNote() == newNote) {
                            newSelectedNodes.add(noteNode);
                        }
                    }
                }
            }
            newNote.setEdited(true);
            newNote.setDirty(true);
            ForceSelectionNodeList oldSelectedNodes = _gcont.getLookup().lookup(ForceSelectionNodeList.class);
            if (oldSelectedNodes != null) {
                _gcont.getContent().remove(oldSelectedNodes);
            }
            if (newSelectedNodes.size() > 0) {
                _gcont.getContent().add(newSelectedNodes);
            }
        } else {
            JOptionPane.showMessageDialog(null, rejectMsg, "Not allowed", JOptionPane.ERROR_MESSAGE);
        }
    }

    private Collection<? extends HierarchyLevelNode> getSelectedHierarchyLevelNodes() {
        if (_nodeSelectionLookup == null) {
            return null;
        }
        return _nodeSelectionLookup.lookupAll(HierarchyLevelNode.class);
    }

    @Override
    protected boolean enable(Node[] nodes) {
        if (_panel == null) {
            getPanel();
        }
        if (_panel == null) {
            return false;
        }
        Collection<? extends HierarchyLevelNode> c = getSelectedHierarchyLevelNodes();
        if (c == null || c.isEmpty()) {
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "Create new note";
    }

    @Override
    public HelpCtx getHelpCtx() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void resultChanged(LookupEvent ev) {
        if (ev.getSource() == _nodeSelectorResult) {
            getNodeSelector();
        }
    }

    @Override
    protected boolean asynchronous() {
        return false;
    }

}
