/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.nodes;

import java.util.ArrayList;
import org.nbirn.fbirn.notecollector.nodes.lists.NoteCollectorNodeList;
import java.util.Collection;
import org.nbirn.fbirn.notecollector.nodes.hierarchy.HierarchyNoteLevel;
import org.nbirn.fbirn.notecollector.nodes.namebased.NameBasedNoteLevel;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/**
 * Derived from http://hugoheden.wordpress.com/2010/12/23/stickylookup-for-netbeans/
 *
 * This class monitors changes to NoteCollectorNodes within the given lookup,
 * and if a new node is chosen,
 * @author gadde
 */
public class NodeByTypeStickyLookup extends ProxyLookup implements LookupListener {

    public static final Class LEVELTYPE_UNKNOWN = null;
    public static final Class LEVELTYPE_HIER = HierarchyNoteLevel.class;
    public static final Class LEVELTYPE_NAME = NameBasedNoteLevel.class;
    private final Lookup.Result<NoteCollectorNode> _result;
    private final InstanceContent _ic;
    private Class _lastType = LEVELTYPE_UNKNOWN;
    Collection<? extends NoteCollectorNode> _lastSelectedNodes = new ArrayList<NoteCollectorNode>();

    public NodeByTypeStickyLookup(final Lookup lookup) {
        this(lookup, new InstanceContent());
    }

    private NodeByTypeStickyLookup(final Lookup lookup, InstanceContent ic) {
        super(Lookups.exclude(lookup, NoteCollectorNode.class), new AbstractLookup(ic));
        _ic = ic;

        _result = lookup.lookupResult(NoteCollectorNode.class);
        _ic.set(_result.allInstances(), null);
        _result.addLookupListener(this);
    }

    public void setType(Class type) {
        _lastType = type;
        resultChanged(null);
    }

    @Override
    public void resultChanged(LookupEvent ev) {
        Collection<? extends NoteCollectorNode> curSelection = _result.allInstances();
        if (curSelection.isEmpty()) {
            // no selected nodes -- act as if nothing happened
            return;
        }
        // look through old selection to see what were the new nodes selected (if any)
        NoteCollectorNodeList newNodes = new NoteCollectorNodeList();
        NoteCollectorNodeList retainedNodes = new NoteCollectorNodeList();
        for (NoteCollectorNode node : curSelection) {
            if (_lastSelectedNodes.contains(node)) {
                retainedNodes.add(node);
            } else {
                newNodes.add(node);
            }
        }
        NoteCollectorNodeList candidateNodeList = new NoteCollectorNodeList();
        // if there were any new nodes selected, we want to find out what type
        // they are, and add them to the candidate list if they are all the
        // same type.
        Class newType = LEVELTYPE_UNKNOWN;
        for (NoteCollectorNode node : newNodes) {
            Class curType = LEVELTYPE_UNKNOWN;
            if (LEVELTYPE_HIER.isInstance(node.getLevel())) {
                curType = LEVELTYPE_HIER;
            } else if (LEVELTYPE_NAME.isInstance(node.getLevel())) {
                curType = LEVELTYPE_NAME;
            }
            if (newType == LEVELTYPE_UNKNOWN) {
                newType = curType;
            }
            if (newType == curType) {
                candidateNodeList.add(node);
            } else {
                newType = LEVELTYPE_UNKNOWN;
                candidateNodeList.clear();
                break;
            }
        }
        if (newNodes.isEmpty()) {
            // no new nodes (maybe some nodes were removed), so reuse the
            // type determined last time
            newType = _lastType;
        }
        // add to the candidate list the nodes from the current selection that
        // match the currently selected type
        if (newType != LEVELTYPE_UNKNOWN) {
            for (NoteCollectorNode node : retainedNodes) {
                Class curType = LEVELTYPE_UNKNOWN;
                if (LEVELTYPE_HIER.isInstance(node.getLevel())) {
                    curType = LEVELTYPE_HIER;
                } else if (LEVELTYPE_NAME.isInstance(node.getLevel())) {
                    curType = LEVELTYPE_NAME;
                }
                if (curType == newType) {
                    candidateNodeList.add(node);
                }
            }
        }
        // before we return, cache current wrapped lookup for future calls
        _lastSelectedNodes = curSelection;
        if (newType == LEVELTYPE_UNKNOWN) {
            // don't know type, so just pass the results of the wrapped lookup
            _ic.set(curSelection, null);
            return;
        }
        _ic.set(candidateNodeList, null);
        _lastType = newType;
    }
}
