/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.nodes;

import java.awt.Image;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

/**
 *
 * @author gadde
 */
public class NoteCollectorNode extends BeanNode<NoteCollectorNodeBean> implements PropertyChangeListener, NodeListener {

    private static final Logger _logger = Logger.getLogger(NoteCollectorNode.class.getName());
    private NoteLevel _level = null;
    boolean _gotNodes = false;
    HashMap<Node, PropertyChangeListener> _listenerRefs = new HashMap<Node, PropertyChangeListener>();

    protected NoteCollectorNode(Children children, Lookup lookup, NoteLevel level) throws IntrospectionException {
        super(new NoteCollectorNodeBean(), children, lookup);
        _level = level;
        addNodeListener(this);
    }

    protected NoteCollectorNode(Children children, NoteLevel level) throws IntrospectionException {
        super(new NoteCollectorNodeBean(), children);
        _level = level;
        addNodeListener(this);
    }

    public NoteLevel getLevel() {
        return _level;
    }

    private void getChildNodes() {
        if (!_gotNodes) {
            Node[] nodes = getChildren().getNodes();
            _gotNodes = true;
        }
    }

    @Override
    public String getHtmlDisplayName() {
        // trigger node update events, if any
        getChildNodes();
        if (getBean().getNumEdited() <= 0) {
            return null;
        }
        return "<b>" + getName() + "</b>";
    }

    protected Image getBaseIcon(int type) {
        return super.getIcon(type);
    }

    @Override
    public Image getIcon(int type) {
        // trigger node update events, if any
        getChildNodes();
        Image base = getBaseIcon(type);
        NoteCollectorNodeBean bean = getBean();
        if (bean.getNumDirty() > 0) {
            Image badge = ImageUtilities.loadImage("org/nbirn/fbirn/notecollector/nodes/icons/fingerprint.png");
            return ImageUtilities.mergeImages(base, badge, 0, 0);
        } else {
            return base;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        Integer newIntValue = null;
        Integer oldIntValue = null;
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        NoteCollectorNodeBean bean = getBean();
        if (!(newValue instanceof Integer)) {
            return;
        }
        if (oldValue != null && !(oldValue instanceof Integer)) {
            return;
        }
        if (oldValue == null) {
            oldIntValue = 0;
        } else {
            oldIntValue = (Integer) oldValue;
        }
        newIntValue = (Integer) newValue;
        _logger.log(Level.FINE, "{0}: propertyChange() name=''{1}'' old=''{2}'' new=''{3}''", new Object[]{toString(), name, oldIntValue, newIntValue});
        if (NoteCollectorNodeBean.PROP_NUMDIRTY.equals(name)) {
            int numDirty = bean.getNumDirty();
            if (oldIntValue == 0 && newIntValue != 0) {
                bean.setNumDirty(numDirty + 1);
            } else if (oldIntValue != 0 && newIntValue == 0) {
                bean.setNumDirty(numDirty - 1);
            }
            fireIconChange();
        } else if (NoteCollectorNodeBean.PROP_NUMEDITED.equals(name)) {
            int numEdited = bean.getNumEdited();
            if (oldIntValue == 0 && newIntValue != 0) {
                bean.setNumEdited(numEdited + 1);
            } else if (oldIntValue != 0 && newIntValue == 0) {
                bean.setNumEdited(numEdited - 1);
            }
            fireDisplayNameChange(null, getDisplayName());
        }
    }

    @Override
    public void childrenAdded(NodeMemberEvent nme) {
        Node[] nodeList = nme.getDelta();
        for (Node node : nodeList) {
            if (node instanceof NoteCollectorNode) {
                _logger.log(Level.FINE, "{0}: adding as listener to {1}", new Object[]{toString(), node.toString()});
                ((NoteCollectorNode) node).addPropertyChangeListener(this);
                NoteCollectorNodeBean bean = ((NoteCollectorNode) node).getBean();
                propertyChange(new PropertyChangeEvent(bean, NoteCollectorNodeBean.PROP_NUMDIRTY, null, bean.getNumDirty()));
                propertyChange(new PropertyChangeEvent(bean, NoteCollectorNodeBean.PROP_NUMEDITED, null, bean.getNumEdited()));
            }
        }
    }

    @Override
    public void childrenRemoved(NodeMemberEvent nme) {
        Node[] nodeList = nme.getDelta();
        for (Node node : nodeList) {
            if (node instanceof NoteCollectorNode) {
                ((NoteCollectorNode) node).removePropertyChangeListener(this);
                NoteCollectorNodeBean removedBean = ((NoteCollectorNode) node).getBean();
                NoteCollectorNodeBean bean = getBean();
                bean.setNumDirty(bean.getNumDirty() - ((removedBean.getNumDirty() == 0) ? 0 : 1));
                bean.setNumEdited(bean.getNumEdited() - ((removedBean.getNumEdited() == 0) ? 0 : 1));
            }
        }
        return;
    }

    @Override
    public void childrenReordered(NodeReorderEvent nre) {
        // we don't care
        return;
    }

    @Override
    public void nodeDestroyed(NodeEvent ne) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
