/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.nodes.hierarchy;

import java.awt.Image;
import java.beans.IntrospectionException;
import javax.swing.Action;
import org.nbirn.fbirn.notecollector.nodes.LevelChildFactory;
import org.nbirn.fbirn.notecollector.nodes.LevelNode;
import org.nbirn.fbirn.notecollector.nodes.NewNoteAction;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;

/**
 *
 * @author gadde
 */
public class HierarchyLevelNode extends LevelNode {

    public HierarchyLevelNode(HierarchyNoteLevel level, LevelChildFactory childFactory) throws IntrospectionException {
	super(level, childFactory);
    }

    @Override
    public HierarchyNoteLevel getLevel() {
	return (HierarchyNoteLevel)super.getLevel();
    }

    @Override
    public Action[] getActions(boolean context) {
	return new Action[]{SystemAction.get(NewNoteAction.class)};
    }

    @Override
    public Image getBaseIcon(int type) {
	if (getLevel() instanceof HierarchyLevels.Subject) {
	    return ImageUtilities.loadImage("org/nbirn/fbirn/notecollector/nodes/icons/subject.png");
	}
	return super.getBaseIcon(type);
    }
}
