/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.nodes.hierarchy;

import org.nbirn.fbirn.notes.ExperimentHierarchyItem;

/**
 *
 * @author gadde
 */
public class HierarchyLevels {

    public static class Series extends HierarchyNoteLevel<Integer, Void> {

	public Series(HierarchyNoteLevel parent, Integer ID, String name, String key) {
	    super(parent, ID, name, key);
	}

	@Override
	public ExperimentHierarchyItem getItem() {
	    ExperimentHierarchyItem item = null;
	    if (getParent() == null) {
		item = new ExperimentHierarchyItem();
	    } else {
		item = getParent().getItem();
	    }
	    item.seriesID = getID();
	    item.seriesName = getName();
	    return item;
	}
    }

    public static class Study extends HierarchyNoteLevel<Integer, Series> {

	public Study(HierarchyNoteLevel parent, Integer ID, String name, String key) {
	    super(parent, ID, name, key);
	}

	@Override
	public ExperimentHierarchyItem getItem() {
	    ExperimentHierarchyItem item = null;
	    if (getParent() == null) {
		item = new ExperimentHierarchyItem();
	    } else {
		item = getParent().getItem();
	    }
	    item.studyID = getID();
	    item.studyName = getName();
	    return item;
	}
    }

    public static class Visit extends HierarchyNoteLevel<Integer, Study> {

	public Visit(HierarchyNoteLevel parent, Integer ID, String name, String key) {
	    super(parent, ID, name, key);
	}

	@Override
	public ExperimentHierarchyItem getItem() {
	    ExperimentHierarchyItem item = null;
	    if (getParent() == null) {
		item = new ExperimentHierarchyItem();
	    } else {
		item = getParent().getItem();
	    }
	    item.visitID = getID();
	    item.visitName = getName();
	    return item;
	}
    }

    public static class Subject extends HierarchyNoteLevel<String, Visit> {

	public Subject(HierarchyNoteLevel parent, String ID, String name, String key) {
	    super(parent, ID, name, key);
	}

	@Override
	public ExperimentHierarchyItem getItem() {
	    ExperimentHierarchyItem item = null;
	    if (getParent() == null) {
		item = new ExperimentHierarchyItem();
	    } else {
		item = getParent().getItem();
	    }
	    item.subjID = getID();
	    item.subjName = getName();
	    return item;
	}
    }

    public static class Project extends HierarchyNoteLevel<Integer, Subject> {

	public Project(HierarchyNoteLevel parent, Integer ID, String name, String key) {
	    super(parent, ID, name, key);
	}

	@Override
	public ExperimentHierarchyItem getItem() {
	    ExperimentHierarchyItem item = null;
	    if (getParent() == null) {
		item = new ExperimentHierarchyItem();
	    } else {
		item = getParent().getItem();
	    }
	    item.expID = getID();
	    item.expName = getName();
	    return item;
	}
    }

    public static class Root extends HierarchyNoteLevel<Void, Project> {

	public Root() {
	    super(null, null, null, "");
	}

	@Override
	public ExperimentHierarchyItem getItem() {
	    return new ExperimentHierarchyItem();
	}
    }
}
