/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.nodes.namebased;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.nbirn.fbirn.notecollector.nodes.EditorNote;
import org.nbirn.fbirn.notecollector.nodes.lists.EditorNoteList;
import org.nbirn.fbirn.notecollector.nodes.LevelChildFactory;
import org.nbirn.fbirn.notecollector.nodes.NoteLevel;
import org.nbirn.fbirn.notes.Note;
import org.nbirn.fbirn.notes.URIWithType;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

/**
 *
 * @author gadde
 */
public class NameBasedNodeFactories {

    private static class NameChildFactory extends NameBasedLevelChildFactory {

        public NameChildFactory(NameBasedLevels.Name level) {
            super(level);
        }

        @Override
        protected boolean createKeys(List<String> keys) {
            NoteLevel<?, ? extends Comparable, ? extends Comparable, ?> level = getLevel();
            ArrayList<Comparable> sortedKeys = new ArrayList<Comparable>(level.keySet());
            Collections.<Comparable>sort(sortedKeys);
            for (Object s : sortedKeys) {
                keys.add("S" + s.toString());
            }
            return true;
        }

        @Override
        protected Node createNodeForKey(String t) {
            NameBasedLevels.Name level = (NameBasedLevels.Name) getLevel();
            String keyStr = t.substring(1);
            if (t.startsWith("S")) {
                NameBasedLevels.Path sublevel = level.get(keyStr);
                try {
                    return new NameBasedNoteNode(keyStr, sublevel.getNote(), sublevel);
                } catch (IntrospectionException e) {
                    // skip
                }
            }
            return null;
        }

        @Override
        protected LevelChildFactory getSubChildFactory(NoteLevel sublevel) {
            return null;
        }
    }

    private static class NamespaceChildFactory extends NameBasedLevelChildFactory {

        public NamespaceChildFactory(NameBasedLevels.Namespace level) {
            super(level);
        }

        @Override
        protected LevelChildFactory getSubChildFactory(NoteLevel sublevel) {
            return new NameChildFactory((NameBasedLevels.Name) sublevel);
        }
    }

    private static class NameBasedRootChildFactory extends NameBasedLevelChildFactory {

        public NameBasedRootChildFactory(NameBasedLevels.Root level) {
            super(level);
        }

        @Override
        protected LevelChildFactory getSubChildFactory(NoteLevel sublevel) {
            return new NamespaceChildFactory((NameBasedLevels.Namespace) sublevel);
        }
    }

    public static Children createEmptyChildren() {
        return Children.LEAF;
    }

    public static Children createNameBasedRootChildren(EditorNoteList notelist) {
        NameBasedLevels.Root top = new NameBasedLevels.Root();
        for (EditorNote note : notelist) {
            if (note.getName() == Note.NULLVALUE) {
                continue;
            }
            NameBasedLevels.Namespace nslevel = null;
            NameBasedLevels.Name namelevel = null;
            String ns = note.getNamespace();
            String name = note.getName();
            if (top.containsKey(ns)) {
                nslevel = top.get(ns);
            } else {
                nslevel = new NameBasedLevels.Namespace(top, ns);
                top.put(ns, nslevel);
            }
            if (nslevel.containsKey(name)) {
                namelevel = nslevel.get(name);
            } else {
                namelevel = new NameBasedLevels.Name(nslevel, name);
                nslevel.put(name, namelevel);
            }
            Iterator<URIWithType> pathiter = note.getPaths().iterator();
            while (pathiter.hasNext()) {
                URIWithType uriwt = pathiter.next();
                String uriwtstr = uriwt.toString();
                NameBasedLevels.Path pathlevel = null;
                if (namelevel.containsKey(uriwtstr)) {
                    pathlevel = namelevel.get(uriwtstr);
                } else {
                    pathlevel = new NameBasedLevels.Path(namelevel, uriwt);
                    namelevel.put(uriwtstr, pathlevel);
                }
                pathlevel.setNote(note);
            }
        }
        return Children.create(new NameBasedRootChildFactory(top), false);
    }
}
