/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.gui.shared;

import java.util.Collection;
import org.globus.myproxy.MyProxyException;
import org.ietf.jgss.GSSCredential;
import org.nbirn.fbirn.notes.NoteException;
import org.nbirn.fbirn.utilities.CanceledException;
import org.nbirn.fbirn.utilities.CredentialManager;
import org.nbirn.fbirn.utilities.CredentialManagerException;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.ServiceProvider;

/**
 *
 * @author gadde
 */
@ServiceProvider(service=CredentialKeeper.class)
public class CredentialKeeper implements LookupListener {

    private CredentialManager _credMan = null;
    private Lookup.Result _credResult = null;

    public CredentialKeeper() {
	initCredResult();
    }

    private void initCredResult() {
	_credResult = Lookup.getDefault().lookupResult(CredentialManager.class);
	changedCred();
	_credResult.addLookupListener(this);
    }

    private void changedCred() {
	Collection c = _credResult.allInstances();
	if (!c.isEmpty()) {
	    _credMan = (CredentialManager) c.iterator().next();
	}
    }

    @Override
    public void resultChanged(LookupEvent lookupEvent) {
	if (lookupEvent.getSource() == _credResult) {
	    changedCred();
	}
    }

    public GSSCredential getCredential() throws CanceledException, NoteException {
	GSSCredential cred = null;
	if (_credMan == null) {
	    return null;
	}
	synchronized (_credMan) {
	    _credMan.resetCanceled();
	    Exception retval = null;
	    cred = _credMan.getCredential();
	    String msg = "Please enter MyProxy and GridFTP connection parameters";
	    while (cred == null) {
		if (_credMan.wasCanceled()) {
		    throw new CanceledException("Operation canceled by user.");
		}
		cred = _credMan.getLocalCredential();
		if (cred == null) {
		    try {
			_credMan.getNewCredential(msg);
			cred = _credMan.getCredential();
			if (cred == null) {
			    if (_credMan.canGetUserInput()) {
				msg = "Error in connection parameters.  Try again:";
				continue;
			    } else {
				throw new NoteException("Can't get valid credential (try getting one by running myproxy-logon)");
			    }
			}
		    } catch (CredentialManagerException e) {
			throw new NoteException("Error getting new credential", e);
		    } catch (MyProxyException e) {
			if (_credMan.canGetUserInput()) {
			    msg = e.toString();
			    continue;
			} else {
			    throw new NoteException("Can't get valid credential (" + e.toString() + ").  Alternative: get one by running myproxy-logon.");
			}
		    }
		}
	    }
	}
	return cred;
    }
}
