/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notecollector.gui.shared;

import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/**
 * Copied from http://hugoheden.wordpress.com/2010/12/23/stickylookup-for-netbeans/
 * @author gadde
 */
public class StickyLookup extends ProxyLookup implements LookupListener {

    private final Lookup.Result _result;
    private final InstanceContent _ic;

    public StickyLookup(final Lookup lookup, final Class<?> clazz) {
	this(lookup, clazz, new InstanceContent());
    }

    private StickyLookup(final Lookup lookup, final Class<?> clazz, InstanceContent ic) {
	super(Lookups.exclude(lookup, clazz), new AbstractLookup(ic));
	_ic = ic;

	_result = lookup.lookupResult(clazz);
	_ic.set(_result.allInstances(), null);
	_result.addLookupListener(this);
    }

    @Override
    public void resultChanged(LookupEvent ev) {
	if (_result.allInstances().isEmpty()) {
	    // Wrapped lookup is empty. We pretend like nothing happened and keep
	    // exposing the same instances as before.
	    return;
	} else {
	    // Just copy whatever the wrapped instance has
	    _ic.set(_result.allInstances(), null);
	}
    }
}
