#!/bin/bash

# ===PROLOG START===
echo "This script won't run as is -- it must be installed into another"
echo "directory using Install.sh."
exit 1
# ===PROLOG END===

ConfigFile="$ScriptInstallDir/ConfigureSite"
if [ ! -e "$ConfigFile" ]
then
    echo -e "\n##########################################################################\n"
    echo "Cannot find the configuration file for the site, ConfigureSite."
    echo "Please run Install.sh before running AddExperiment2HID.sh"
    echo -e "\n##########################################################################"
    exit 1
fi
source $ConfigFile

addopts=()
addargs=()
argnum=1
while [ $# -gt 0 ] ; do
    param=$1
    shift
    case "${param}" in
	-*)
	    addopts=("${addopts[@]}" "${param}")
	    ;;
	*)
	    if [ $argnum -eq 1 ] ; then
		GridFTPHost="${param}"
	    elif [ $argnum -eq 2 ] ; then
		GridFTPPort="${param}"
	    else
		addargs=("${addargs[@]}" "${param}")
	    fi
	    (( argnum++ ))
	    ;;
    esac
done

if [ ${#addargs} -gt 0 ] ; then
    echo "Usage: $0 [opts...] [GridFTPHost [GridFTPPort]]"
    echo ""
    echo "Default values for this installation are:"
    echo " GridFTPHost=${GridFTPHost}"
    echo " GridFTPPort=${GridFTPPort}"
    echo "opts can be any options supported by GridFTPCommand.java"
    exit 1
fi

#java -DMYPROXY_SOCKET_TIMEOUT=120 -cp ${ScriptInstallDir}/java:${ScriptInstallDir}/java/cog-jglobus-1.8.0-birnfix.jar:${ScriptInstallDir}/java/birn-gridftp-tar-1.0.3.jar:${ScriptInstallDir}/java/birn-sample-1.0.0.jar:${ScriptInstallDir}/java/birn-util-1.0.0.jar:${ScriptInstallDir}/java/commons-compress-1.0.jar GridFTPCommand "${addopts[@]}" "${MyProxyHost}" "${MyProxyPort}" "${GridFTPHost}" "${GridFTPPort}"
java -DMYPROXY_SOCKET_TIMEOUT=120 -cp ${ScriptInstallDir}/java:${ScriptInstallDir}/java/cog-jglobus-1.8.0-lowdelay.jar:${ScriptInstallDir}/java/birn-gridftp-tar-1.0.3.jar:${ScriptInstallDir}/java/birn-sample-1.0.0.jar:${ScriptInstallDir}/java/birn-util-1.0.0.jar:${ScriptInstallDir}/java/commons-compress-1.0.jar GridFTPCommand "${addopts[@]}" "${MyProxyHost}" "${MyProxyPort}" "${GridFTPHost}" "${GridFTPPort}"
