#!/bin/bash 

###############################################################################################################
#	This script will install the fBIRN Human upload scripts.  It will collect some
#	basic site specific metadata and create configuration files for each local scanner you
#	will use to upload phantom data.
#
#	The script will check for binary dependencies based on what type of <Native> format data
#	you have.  You need not have the same data format for each of your scanners.  
#
###############################################################################################################

Usage () {
	echo 
	echo "$0 Release ver. " `cat RELEASE_VERSION`
	echo "Usage: $0 [install directory]"
	echo 
        echo "This shell script will set up all site specific information for data importing into the BIRN data hierarchy appropriate for FIPS analysis"
        echo "This installation will allow you to specify the types and formats for MRI scanners at your site, installation directories, and output directories used to store images once imported"
        echo
	echo "See the Readme.html file for help."
	echo; }


if [ ! -f Install.sh -o ! -f ReInstall.sh ] ; then
        echo "ERROR: Can't find Install.sh or ReInstall.sh in the current directory."
	echo "This script needs to be run from the checked-out or released upload"
	echo "script directory!"
	exit 1
fi

############################################
#Set up Installation Directories...
############################################
INSTALLDIR=$1
if [ x"$INSTALLDIR" = x ] ; then
	read -p "Please Enter Directory to Install Scripts: " INSTALLDIR
fi
if [ ! -d $INSTALLDIR ]
then
        echo "ERROR: $INSTALLDIR does not exist!"
	exit 1
fi
srcinode=`ls -i -d . | awk '{print $1}'`
tgtinode=`ls -i -d ${INSTALLDIR} | awk '{print $1}'`
if [ x$srcinode = x$tgtinode ] ; then
	echo "ERROR: source and target directories are the same!"
	echo "Please specify a different installation directory."
	exit 1
fi
if [ ! -f "$INSTALLDIR/ConfigureSite" ]
then
        echo "ERROR: $INSTALLDIR does not have the file ConfigureSite!"
	echo "You need to run Install.sh first!"
	exit 1
fi

# Grab SVN version number (if svnversion is available)
if builtin type -P svnversion &> /dev/null ; then
  svnversion > SVNVERSION
fi

echo "Copying files to ${INSTALLDIR} ..."

RSYNC=`which rsync 2>/dev/null`
if [ x"${RSYNC}" = x ] ; then
	tar --exclude 'Install.sh' --exclude 'ReInstall.sh' --exclude '.svn' -cf - * | (cd ${INSTALLDIR} ; tar xf -)
else
	${RSYNC} -a --exclude 'Install.sh' --exclude 'ReInstall.sh' --exclude '.svn' * ${INSTALLDIR}
fi
for script in AddVisit2HID.sh CleanupTemp.sh ScannerInfo.sh AddExperiment2HID.sh GridFTPCommand.sh bin/3dAutomask bin/3dDetrend bin/3dFWHMx bin/3dToutcount bin/3dTstat bin/3dcalc bin/3dvolreg bin/runProjectQA.sh ; do
	# states: 0 == before prolog; 1 == in prolog; 2 == after prolog
	perl -e 'open(FH,"'"${script}"'"); while(<FH>){if ($state==2){print;next}; if (/^# ===PROLOG END===/) {$state=2;next} if (/^# ===PROLOG START===/) {$state=1;print <>;next}; print if ($state==0)}' > ${INSTALLDIR}/${script} <<EOF
# ===PROLOG START (filled in)===
export PATH=\${PATH}:${INSTALLDIR}:${INSTALLDIR}/bin
export ScriptInstallDir=${INSTALLDIR}
# ===PROLOG END (filled in)===
EOF
done
for script in XMLUploadGUI.py FirstPassValidator UpdateRLS ; do
	# states: 0 == before prolog; 1 == in prolog; 2 == after prolog
	perl -e 'open(FH,"'"${script}"'"); while(<FH>){if ($state==2){print;next}; if (/^# ===PROLOG END===/) {$state=2;next} if (/^# ===PROLOG START===/) {$state=1;print <>;next}; print if ($state==0)}' > ${INSTALLDIR}/${script} <<EOF
# ===PROLOG START (filled in)===
os.environ['PATH'] = '${INSTALLDIR}/bin:' + os.environ['PATH']
os.environ['ScriptInstallDir'] = '${INSTALLDIR}'
# ===PROLOG END (filled in)===
EOF
done
for script in bin/QAForDashboard.pl ; do
	# states: 0 == before prolog; 1 == in prolog; 2 == after prolog
	perl -e 'open(FH,"'"${script}"'"); while(<FH>){if ($state==2){print;next}; if (/^# ===PROLOG END===/) {$state=2;next} if (/^# ===PROLOG START===/) {$state=1;print <>;next}; print if ($state==0)}' > ${INSTALLDIR}/${script} <<EOF
# ===PROLOG START (filled in)===
use lib '${INSTALLDIR}/bin';
\$ENV{'PATH'} = '${INSTALLDIR}/bin:' . \$ENV{'PATH'};
my \$ScriptInstallDir = '${INSTALLDIR}';
# ===PROLOG END (filled in)===
EOF
done
chmod -R a+x ${INSTALLDIR}/*

echo "Installation successful!"
exit 0
