#!/bin/bash 

# ===PROLOG START===
echo "This script won't run as is -- it must be installed into another"
echo "directory using Install.sh."
exit 1
# ===PROLOG END===

###############################################################################################################
#	This script will install the fBIRN Human upload scripts.  It will collect some
#	basic site specific metadata and create configuration files for each local scanner you
#	will use to upload phantom data.
#
#	The script will check for binary dependencies based on what type of <Native> format data
#	you have.  You need not have the same data format for each of your scanners.  
#
#
###############################################################################################################

Usage () {
	echo 
	echo "$0 Release ver. " `cat RELEASE_VERSION`
	echo "Usage: $0"
	echo 
	echo "This shell script will set up scanner specific information for the fBIRN Local Human Data (LOCAL/NON-SRB Uploads)"
	echo "upload script: Install.sh"
	echo; }


echo
echo "###################################################"
echo "#Local Human Data Script Installation Utility    #"
echo "###################################################"
echo

############################################
#Init some vars
############################################

DICOMPathSet=0
PFilePathSet=0
FFilePathSet=0
IowaSignaPathSet=0
SignaPathSet=0
BXHAnalyzePathSet=0
Behavioral=1

# Make sure ConfigueSite exists
if [ `which Upload.sh 2>/dev/null` ]
then
        SCANNER_DIR=`which Upload.sh | sed -e 's%/[^/]*$%%'`
else
        SCANNER_DIR=`pwd`
fi

ConfigFile="$SCANNER_DIR/ConfigureSite"
if [ ! -e "$ConfigFile" ]
then
        echo -e "\n##########################################################################\n"
        echo "Cannot find the configuration file for the site, ConfigureSite."
        echo "Please run Install.sh before running ScannerInfo.sh"
        echo -e "\n##########################################################################"
        exit 1
fi
source $ConfigFile

fBIRN_ScriptInstallDir=`cat $ConfigFile | grep "ScriptInstallDir" | cut -d"=" -f2 | tr -d '"'`
fBIRN_Institution=`cat $ConfigFile | grep "ScriptInstallDir" | cut -d"=" -f2 | tr -d '"'`
fBIRN_InstitutionID=`cat $ConfigFile | grep "ScriptInstallDir" | cut -d"=" -f2 | tr -d '"'`
fBIRN_TempDIR=`cat $ConfigFile | grep "TempDIR" | cut -d"=" -f2 | tr -d '"'`
DBHost=`cat $ConfigFile | grep "DBHost" | cut -d"=" -f2 | tr -d '"'`
DBPort=`cat $ConfigFile | grep "DBPort" | cut -d"=" -f2 | tr -d '"'`
DBInstance=`cat $ConfigFile | grep "DBInstance" | cut -d"=" -f2 | tr -d '"'`
DBUser=`cat $ConfigFile | grep "DBUser" | cut -d"=" -f2 | tr -d '"'`
DBPass=`cat $ConfigFile | grep "DBPass" | cut -d"=" -f2 | tr -d '"'`
DBType=`cat $ConfigFile | grep "DBType" | cut -d"=" -f2 | tr -d '"'`
UserName=`cat $ConfigFile | grep "User" | cut -d"=" -f2 | tr -d '"'`
Use_cx_Oracle=`cat $ConfigFile | grep "UseCXOracle" | cut -d"=" -f2 | tr -d '"'`

if [ $Use_cx_Oracle -eq 1 ]; then
    if [ x"$ORACLE_HOME" = x ]; then
	echo "ERROR: Cannot find ORACLE_HOME!"
	exit 1
    else
	ORACLE_LIBDIR="$ORACLE_HOME/lib/"
    fi

    export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$ORACLE_LIBDIR
fi


############################################
#Remove Previous Configuration File
############################################
temp=`ls . | egrep "Configure_*" | wc | awk '{print $1}'`

if [ "${temp}" -gt 0 ]
then
	echo "Removing previous configuration file..."
	rm Configure_*
fi

############################################
#Set up Installation Directories...
############################################
INSTALLDIR=$SCANNER_DIR
InstitutionID=$fBIRN_InstitutionID
TempDIR=$fBIRN_TempDIR
if [ -d $TempDIR ]
then
	read -p "$TempDIR exists.  Would you like to remove it? [y/n] " REMOVE_IT
        if [ "$REMOVE_IT" = "y" ]
        then
            echo "Removing ${TempDIR}..."
            rm -rf $TempDIR
            mkdir $TempDIR
        else
            echo "WARNING: Some information in $TempDIR may be overwritten during uploads!"
            
        fi
else
	echo "Making $TempDIR directory...."
	mkdir $TempDIR
fi

#############################################################################
#Sets up Database information
#############################################################################
if [ -z "$DBInstance" ]
then
        echo ""
        echo "Please input the value for the instance of HID, eg. HIDPRD:"
        read DBHost
fi

if [ -z "$DBType" ]
then
	echo "Please input the database type (postgres/oracle):"
	read DBType 
fi

if [ -z "$UserName" ]
then
        # UserName="BIRNWEB"
	echo "Please input the user name to connect to the database (e.g. BIRNWEB):"
	read username
fi

if [ -z "$DBUser" ]
then
        DBUser=$UserName
fi

if [ -z "$DBPass" ]
then
        echo ""
        echo "Please input the password for the HID user:"
        read DBHost
fi

if [ ! -d $fBIRN_TempDIR ]
then
        mkdir -p $fBIRN_TempDIR
fi

if [ $Use_cx_Oracle -eq 1 ]; then
	result=`./dbtest.py ${fBIRN_ScriptInstallDir} 1 $DBUser $DBPass $DBInstance $DBType $DBHost $DBPort`
	echo $result

	if [ x$result != x1 ];
	then
		echo "WARNING: cx_Oracle connection test failed.  Reverting to (slower) Java method."
		Use_cx_Oracle=0
	else
		echo "Connection test successful!"
	fi
fi
	
if [ $Use_cx_Oracle -eq 0 ]; then
	result=`./dbtest.py ${fBIRN_ScriptInstallDir} 0 $DBUser $DBPass $DBInstance $DBType $DBHost $DBPort`

	if [ x$result != x1 ];
	then
		echo "Please update your database before running upload"
		exit 1
	else
		echo "Connection test successful!"
	fi
fi
	
#############################################################################
#Sets up scanner specific information 
#############################################################################
echo "###################################################"
echo "#Querying database for equipment information..."
echo "###################################################"

ScannersStr=`./list_scanners.py ${fBIRN_ScriptInstallDir} $Use_cx_Oracle $DBUser $DBPass $DBInstance $DBType $DBHost $DBPort`

OIFS=$IFS
IFS='
'
count=1
for line in $ScannersStr; do
	EquipID[$count]=`echo $line | cut -d"|" -f1`
	fEquipID[$count]=${EquipID[$count]}
	Manufacturer[$count]=`echo $line | cut -d"|" -f2`
	fManufacturer[$count]=${Manufacturer[$count]}
	LocalScannerName[$count]=`echo $line | cut -d"|" -f3`
	count=`expr $count + 1`
done
IFS=$OIFS

if [ $count -eq 1 ]; then
	echo -e "\n###################################################"
	echo "No scanner found in database. " 
	echo "Please run AddExperiment2HID.sh before running this program."
	exit 1
fi

count=`expr $count - 1`
NumScanners=$count
i1=0
#i=0
############################################
#Collect format specifier of NATIVE_DIR
############################################
while [ $i1 -lt $count ]
do
 	ii=`expr $i1 + 1`
	#echo $ii ${line[$ii]}
	
	#seline=${line[$ii]}
	#EquipID[$ii]=`echo $seline|cut -d';'  -f1`
	#Manufacturer[$ii]=`echo $seline|cut -d';'  -f2`
	#LocalScannerName[$ii]=`echo $seline|cut -d';'  -f3`
	echo 
	echo "#########################################################"
	echo "#Attempting to make sense of devices"
	echo "#########################################################"
	echo
	echo No.$ii Device: ${EquipID[$ii]} Manufacturer is ${Manufacturer[$ii]} and Scanner name is ${LocalScannerName[$ii]}
       	echo 
        read -p "Is this device an MRI scanner you want to configure for data uploads (y/n)?" Ans
        if [ "$Ans" = "y" ]
        then
			###################################################
			#Collect format specifier of the geometric phantom data
			###################################################
			echo
			echo "Please Specify your Native Format for geometric phantoms: "
			echo "          Auto detect    =         0"
			echo "                DICOM    =         1"
			echo "             GE PFile    =         2"
			echo "  Stanford F/MAG File    =         3"
			echo "              UCI RAW    =         4"
			echo "      Iowa GE5.x/Sign    =         5"
			echo "          Analyze 7.5    =         6"
		 	echo "                 MINC    =         7"
			echo "  Normal GE Signa 5.x    =         8"
			read -p "Format Specifier: " GeometricImageFormat[$ii]
		
			if ( [ ${GeometricImageFormat[$ii]} -lt 0 ] || [ ${GeometricImageFormat[$ii]} -gt 8 ]  )
			then
				echo "Error, Please Enter a Valid ${GeometricImageFormat[$ii]}"
				echo 'Installation Aborted!'
				exit 1
			fi
		
			###################################################
			#Collect format specifier of the stability phantom data
			###################################################
			echo
			echo "Please Specify your Native Format for stability phantoms: "
			echo "          Auto detect    =         0"
			echo "                DICOM    =         1"
			echo "             GE PFile    =         2"
			echo "  Stanford F/MAG File    =         3"
			echo "              UCI RAW    =         4"
			echo "      Iowa GE5.x/Sign    =         5"
			echo "          Analyze 7.5    =         6"
		 	echo "                 MINC    =         7"
			echo "  Normal GE Signa 5.x    =         8"
			read -p "Format Specifier: " StabilityImageFormat[$ii]
		
			if ( [ ${StabilityImageFormat[$ii]} -lt 0 ] || [ ${StabilityImageFormat[$ii]} -gt 8 ]  )
			then
				echo "Error, Please Enter a Valid ${StabilityImageFormat[$ii]}"
				echo 'Installation Aborted!'
				exit 1
			fi
	
        		#fEquipID[$i]=${EquipID[$ii]}
        		#fManufacturer[$ii]=${Manufacturer[$ii]}
			###################################################
			#Collect format specifier of the EPI Images
			###################################################
			echo
			echo "Please Specify your Native Format for EPI Data: "
			echo "          Auto detect    =         0"
			echo "                DICOM    =         1"
			echo "             GE PFile    =         2"
			echo "  Stanford F/MAG File    =         3"
			echo "              UCI RAW    =         4"
			echo "     Iowa GE5.x/Signa    =         5"
			echo "          Analyze 7.5    =         6"
	                echo "                 MINC    =         7"
			echo "  Normal GE Signa 5.x    =         8"
			read -p "Format Specifier: " GImageFormat[$ii]
		
			if ( [ ${GImageFormat[$ii]} -lt 0 ] || [ ${GImageFormat[$ii]} -gt 8 ]  )
			then
				echo "Error, Please Enter a Valid ${GImageFormat[$ii]}"
				echo 'Installation Aborted!'
				exit 1
			fi

			####################################################
			#Collect format specifier of the Structural Images
			####################################################
			echo
			echo "Please Specify your Native Format for Structural Data: "
			echo "          Auto detect    =         0"
			echo "                DICOM    =         1"
			echo "             GE PFile    =         2"
			echo "  Stanford F/MAG File    =         3"
			echo "              UCI RAW    =         4"
			echo "     Iowa GE5.x/Signa    =         5"
			echo "          Analyze 7.5    =         6"
	                echo "                 MINC    =         7"
			echo "  Normal GE Signa 5.x    =         8"
			read -p "Format Specifier: " SImageFormat[$ii]

			if ( [ ${SImageFormat[$ii]} -lt 0 ] || [ ${SImageFormat[$ii]} -gt 8 ] )
			then
				echo "Error, Please Enter a Valid ${SImageFormat[$ii]}"
				echo 'Installation Aborted!'
				exit 1
			fi
			
			
			#################################################################
			#Collect format specifier of the Anonymized Structural Images
			#################################################################
			echo
			echo "Please Specify your Native Format for Anonymized Structural Data: "
			echo "          Auto detect    =         0"
			echo "                DICOM    =         1"
			echo "             GE PFile    =         2"
			echo "  Stanford F/MAG File    =         3"
			echo "              UCI RAW    =         4"
			echo "     Iowa GE5.x/Signa    =         5"
			echo "          Analyze 7.5    =         6"
	                echo "                 MINC    =         7"
			echo "  Normal GE Signa 5.x    =         8"
			read -p "Format Specifier: " SAnonImageFormat[$ii]

			if ( [ ${SAnonImageFormat[$ii]} -lt 0 ] || [ ${SAnonImageFormat[$ii]} -gt 8 ] )
			then
				echo "Error, Please Enter a Valid ${SAnonImageFormat[$ii]}"
				echo 'Installation Aborted!'
				exit 1
			fi
			
		read -p "Will you be uploading image segmentations?: " segment
		if [ "$segment" = "y" ] 
		then 
			
			#################################################################
			#Collect format specifier of the Structural Image Segmentations
			#################################################################
			echo
			echo "Please Specify your Native Format for Structural Data Segmentations: "
			echo "          Auto detect    =         0"
			echo "                DICOM    =         1"
			echo "             GE PFile    =         2"
			echo "  Stanford F/MAG File    =         3"
			echo "              UCI RAW    =         4"
			echo "     Iowa GE5.x/Signa    =         5"
			echo "          Analyze 7.5    =         6"
			echo "                 MINC    =         7"
			echo "  Normal GE Signa 5.x    =         8"
			read -p "Format Specifier: " SSegmentImageFormat[$ii]
		
			if ( [ ${SSegmentImageFormat[$ii]} -lt 0 ] || [ ${SSegmentImageFormat[$ii]} -gt 8 ] )
			then
				echo "Error, Please Enter a Valid ${SSegmentImageFormat[$ii]}"
				echo 'Installation Aborted!'
				exit 1
			fi
		fi
			
			
			
			
		echo ""
		echo "##############################################################################"
		echo "#Attempting to find behavioral data collection equipment for this scanner...."
		echo "##############################################################################"
			
		jj1=0
		while [ $jj1 -lt $count ]
 		do
 			ct1=`expr $jj1 + 1`
			
			if [ $ii -eq $ct1 ]
			then
			       jj1=`expr $jj1 + 1`
			       continue	
			fi
			
			echo $ct1 : ${EquipID[$ct1]} Manufacturer is ${Manufacturer[$ct1]} 
			
 			jj1=`expr $jj1 + 1`
 		done
 	
		echo	
 		read -p "Enter the behavioral data collection equipment used for this MRI scanner : " Behavior[$ii]
 		if ( [ ${Behavior[$ii]} -lt 1 ] || [ ${Behavior[$ii]} -gt $count ]  )
		then
				echo "No valid behavior data collection equipment is specified."
				Behavioral=0
				
				#echo "Error, Please Enter a Valid Behavior Data Collection Equip ${Behavior[$ii]}"
				#echo 'Installation Aborted!'
				#exit 1
		fi
		#################################################################
		#Collect format specifier of the Behavioral data
		#################################################################

		echo
		echo "Please Specify your Behavioral data format: "
		echo "                EPRIME   =         9"
		echo "                CIGAL    =        10"
		read -p "Format Specifier: " BehavioralFormat[$ii]

		if ( [ ${BehavioralFormat[$ii]} -lt 9 ] || [ ${BehavioralFormat[$ii]} -gt 10 ]  )
		then
			echo "Error, Please Enter a Valid ${BehavioralFormat[$ii]}"
			echo 'Installation Aborted!'
			exit 1
		fi
			
	else
		#if the answer is no
		# set to 10 means no selection
		SImageFormat[$ii]=10
	fi
	i1=`expr $i1 + 1`
 	   
done	 



################################################################################
##Create Configuration.sh script which will assign ENV variables based on system
################################################################################

echo
echo "Creating Configuration Files...."

for ((i=1; i <= NumScanners; i+=1)); 
do

		if [ ${SImageFormat[$i]} -eq 10 ]
		then
			continue
		fi
		LocalScannerName[$i]=`echo ${LocalScannerName[$i]}|sed 's/ /_/g'`

		cat $ConfigFile > Configure_${LocalScannerName[$i]}
		echo "NativeFormat=${GImageFormat[$i]}" >> Configure_${LocalScannerName[$i]}
		echo "GeometricNativeFormat=${GeometricImageFormat[$i]}" >> Configure_${LocalScannerName[$i]}
		echo "StabilityNativeFormat=${StabilityImageFormat[$i]}" >> Configure_${LocalScannerName[$i]}
		echo "StructFormat=${SImageFormat[$i]}" >> Configure_${LocalScannerName[$i]}
		echo "StructAnonFormat=${SAnonImageFormat[$i]}" >> Configure_${LocalScannerName[$i]}
		if [ "$segment" = "y" ]
		then	
			echo "SegmentFormat=${SSegmentImageFormat[$i]}" >> Configure_${LocalScannerName[$i]}
		fi
		Manufacturer[$i]=`echo ${Manufacturer[$i]} | tr '[a-z]' '[A-Z]'`
		echo "ScannerManufacturer=\"${Manufacturer[$i]}\"" >> Configure_${LocalScannerName[$i]}
		echo "ScannerID=${EquipID[$i]}" >> Configure_${LocalScannerName[$i]}
		
		if [ $Behavioral -eq 1 ]
		then
			echo "BehavioralFormat=${BehavioralFormat[$i]}" >> Configure_${LocalScannerName[$i]}
			p=${Behavior[$i]}
			Manufacturer[$p]=`echo ${Manufacturer[$p]} | tr '[a-z]' '[A-Z]'`
			echo "BehavioralEquipment=\"${Manufacturer[$p]}\"" >> Configure_${LocalScannerName[$i]}
			echo "BehavioralEquipmentID=${EquipID[$p]}" >> Configure_${LocalScannerName[$i]}
		fi
	
done

echo "Copying Scripts to ${INSTALLDIR}.."

mv Configure_* ${INSTALLDIR}

echo "Scanner configuration is successful!"
exit 0
