#!/usr/bin/perl

use FindBin;
use lib "$FindBin::Bin";

use File::Path;
use Sys::Hostname;
use Config;

use XML::SAX;
use XML::SAX::PurePerl;

use strict;

package main;

# ===PROLOG START===
print STDERR "This script won't run as is -- it must be installed into another\ndirectory using Install.sh.\n";
my $ScriptInstallDir = undef;
exit 1;
# ===PROLOG END===

package QAMetadata;
use base qw(XML::SAX::Base);
sub new {
  my ($outfh, $copyregexp) = @_;
  my $self =
  {
    'curlevel' => 0,
    'characters' => '',
    'attstack' => [],
    'cmasszlist' => [],
    'outfh' => $outfh,
    'copyregexp' => $copyregexp,
  };
  bless $self;
}
sub start_element {
  my ($self, $el) = @_;
  my $localname = $el->{'LocalName'};
  $self->{'curlevel'}++;
  $self->{'characters'} = '';
  # save attributes for end_element
  push @{$self->{'attstack'}}, $el->{'Attributes'};
  if (!$self->{'inevents'}) {
    if ($localname eq 'events') {
      $self->{'inevents'} = $self->{'curlevel'};
    }
  } elsif (!$self->{'inevent'}) {
    if ($localname eq 'event') {
      $self->{'inevent'} = $self->{'curlevel'};
    }
  }
  return;
}
sub characters {
  my ($self, $el) = @_;
  $self->{'characters'} .= $el->{'Data'};
}
sub end_element {
  my ($self, $el) = @_;
  my $localname = $el->{'LocalName'};
  my $characters = $self->{'characters'};
  my $attrs = pop @{$self->{'attstack'}};
  $self->{'characters'} = '';
  if ($self->{'inevent'} && $localname eq 'value' && exists($attrs->{'{}name'})) {
    my $name = $attrs->{'{}name'}->{'Value'};
    if ($name =~ /^$self->{copyregexp}$/) {
    my $fh = $self->{'outfh'};
    # just copy the value
    print $fh <<EOM;
      <observation name="${name}" type="float">${characters}</observation>
EOM
      } elsif ($name eq 'cmassz') {
	push @{$self->{'cmasszlist'}}, $characters;
      }
}
if ($localname eq 'event' && $self->{'curlevel'} == $self->{'inevent'}) {
    $self->{'inevent'} = 0;
} elsif ($localname eq 'events' && $self->{'curlevel'} == $self->{'inevents'}) {
    $self->{'inevents'} = 0;
}
$self->{'curlevel'}--;
}
sub end_document {
  my ($self,) = @_;
  delete $self->{'characters'};
  delete $self->{'attstack'};
}

package main;

my $rev = '$LastChangedRevision: 664 $';
my (undef, $revnum, undef) = split(/\s+/, $rev);

my $pid = $$;

my $OPT_overwrite = 0;
my $OPT_debug = 0;
my $OPT_baseprojects = '/home/Projects';
my $OPT_outbaseprojects = undef;
my $OPT_qadir = 'QA_Data';
my $OPT_outqadir = undef;

my $usage = <<EOM;
Usage:
  $0 [--overwrite] PROJECTNAME...
EOM

my @origARGV = @ARGV;
my @oldARGV = @ARGV;
@ARGV = ();
while (scalar(@oldARGV)) {
  my $arg = shift @oldARGV;
  if ($arg =~ /^--$/) {
    push @ARGV, @oldARGV;
    last;
  }
  if ($arg !~ /^--/) {
    push @ARGV, $arg;
    next;
  }
  my ($opt, undef, $opteq, $optarg) = ($arg =~ /^--([^=]+)((=)?(.*))$/);
  if (defined($opteq)) {
    unshift @oldARGV, $optarg;
  }
  if (scalar(@oldARGV) > 0) {
    $optarg = $oldARGV[0]; # in case option takes argument
  }
  if ($opt eq 'debug' && !defined($opteq)) {
    $OPT_debug++;
  } elsif ($opt eq 'overwrite' && !defined($opteq)) {
    $OPT_overwrite++;
  } elsif ($opt eq 'baseprojects' && defined($optarg)) {
    $OPT_baseprojects = $optarg;
    shift @oldARGV;
  } elsif ($opt eq 'outbaseprojects' && defined($optarg)) {
    $OPT_outbaseprojects = $optarg;
    shift @oldARGV;
  } elsif ($opt eq 'qadir' && defined($optarg)) {
    $OPT_qadir = $optarg;
    shift @oldARGV;
  } elsif ($opt eq 'outqadir' && defined($optarg)) {
    $OPT_outqadir = $optarg;
    shift @oldARGV;
  } else {
    die "Unrecognized option '$opt' (or missing argument?)\nUse --help for options.\n";
  }
}

if (scalar(@ARGV) <= 0) {
  die $usage;
}

my $BASEPROJECTS = $OPT_baseprojects;
if (!defined($OPT_outbaseprojects)) {
  $OPT_outbaseprojects = $OPT_baseprojects;
}
if (!defined($OPT_outqadir)) {
  $OPT_outqadir = $OPT_qadir;
}

my $timestamp = '';
{
  my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime(time);
  $timestamp = sprintf("%04d-%02d-%02dT%02d:%02d:%02dZ", $year + 1900, $mon + 1, $mday, $hour, $min, $sec);
}
my $host = hostname();

print STDERR "Starting execution at time: $timestamp\n" if $OPT_debug;
print STDERR "Current revision: $revnum\n" if $OPT_debug;

my $xmlhead = <<EOM;
<?xml version="1.0" encoding="UTF-8" ?>
<XCEDE xmlns="http://www.xcede.org/xcede-2"
  xmlns:fbirn="http://www.xcede.org/xcede-2/extensions/fbirn"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  version="2.0">
EOM
my $xmlfoot = <<EOM;
</XCEDE>
EOM
my $provenance = <<EOM;
    <provenance>
      <processStep>
        <program>$0</program>
        <programArguments>$0 @ARGV</programArguments>
        <timeStamp>${timestamp}</timeStamp>
        <user>$ENV{USER}</user>
        <hostName>$host</hostName>
        <platform>$Config{osname}</platform>
      </processStep>
    </provenance>
EOM

for my $project (@ARGV) {
  my $baseqadir = "${BASEPROJECTS}/${project}/${OPT_outqadir}";
  my $outbaseqadir = "${OPT_outbaseprojects}/${project}/${OPT_outqadir}";
  chdir $baseqadir || do { print STDERR "Error changing directory to $baseqadir\n"; next; };
  for my $studydir (glob('*/*/*')) {
    print STDERR "${studydir}\n";
    next if ($studydir !~ m%^([^/]*)/([^/]*)__([^/]*)/([^/]*)__([^/]*)%);
    my ($subjectid, $visitname, $visitid, $studyname, $studyid) = ($1, $2, $3, $4, $5);
    my $studydatadir = "${BASEPROJECTS}/${project}/Data/${studydir}";
    # check version of QA run on this study
    my $qaversionfile = "${baseqadir}/${studydir}/Analysis/QAVERSION";
    my $outqaversionfile = "${outbaseqadir}/${studydir}/Analysis/QAVERSION";
    my $updateqaversionfile = 0;
    my $oldrevnum = 0;
    open(FH, '<', $qaversionfile) && do {
      local $/;
      my $oldrev = <FH>;
      close FH;
      $oldrev =~ s/\s+$//;
      (undef, $oldrevnum, undef) = split(/\s+/, $oldrev);
      print STDERR "Found old revision $oldrevnum\n" if $OPT_debug;
    };
    # check for behavioral data
    my $cigalfilesdir = "${studydatadir}/cigal_files/Native/Original__0001/UNKNOWN";
    my %bhvdirsscreening = ();
    my %bhvdirsprescan = ();
    my %bhvdirsscan = ();
    my %bhvdirspostscan = ();
    my @bhvfiles = glob("${cigalfilesdir}/s????????????_*/*");
    for my $bhvfile (@bhvfiles) {
      my ($vol, $dirs, $file) = File::Spec->splitpath($bhvfile);
      my $dirpath = File::Spec->catpath($vol, $dirs, '');
      if ($file =~ /^bhv_s(\d+).*/) {
	my $seriesnum = $1;
	if ($seriesnum >= 0 && $seriesnum <= 99) {
	  $bhvdirsscan{$dirpath} = 1;
	} elsif ($seriesnum >= 100 && $seriesnum <= 199) {
	  $bhvdirsscreening{$dirpath} = 1;
	}
      } elsif ($file =~ /^(PicRatings.txt|hallucquerylog.txt)$/) {
	$bhvdirspostscan{$dirpath} = 1;
      }
    }
    for my $hashref (\%bhvdirsscreening, \%bhvdirsscan, \%bhvdirspostscan) {
      for my $dirpath (keys %$hashref) {
	my ($vol, $dirs, undef) = File::Spec->splitpath($dirpath, 1);
	my $scannotes = File::Spec->catpath($vol, $dirs, 'scannotes.txt');
	if (-f $scannotes) {
  	  if (open(FH, '<', "${scannotes}")) {
	    local $/;
	    my $contents = <FH>;
	    close FH;
	    if ($contents =~ m%^(\d{1,2}/\d{1,2}/\d{4})\s%m) {
	      my $date = $1;
	      $hashref->{$dirpath} = $date;
	    }
	  }
	}
      }
    }
    while (my ($screendir, $date) = each %bhvdirsscreening) {
      # screening dirs that happen on the same day as the scan are
      # considered pre-scan dirs
      if (grep { $date eq $_ } values %bhvdirsscan) {
	$bhvdirsprescan{$screendir} = 1;
	delete $bhvdirsscreening{$screendir};
      }
    }
    my $ucdir = "${baseqadir}/${studydir}/Analysis/UploadChecks__0001";
    my $outucdir = "${outbaseqadir}/${studydir}/Analysis/UploadChecks__0001";
    mkdir $outucdir;
    my $outbhvcheckfile = "${outucdir}/BehavioralDirs.xml";
    my $bhvcheckoutofdate = $OPT_overwrite || ($oldrevnum <= 652);
    if (! -f $outbhvcheckfile) {
      $bhvcheckoutofdate = 1;
    } else {
      my $bhvcheckmtime = (stat($outbhvcheckfile))[9];
      map {
	my $mtime = (stat($_))[9];
	if ($bhvcheckmtime < $mtime) {
	  $bhvcheckoutofdate = 1;
	}
      } ($cigalfilesdir, keys %bhvdirsscreening, keys %bhvdirsprescan, keys %bhvdirsscan, keys %bhvdirspostscan);
    }
    if (!$bhvcheckoutofdate) {
      print STDERR " skipping up-to-date behavioral check...\n";
    } elsif ($project =~ /^fBIRNPhaseIII(|test|debug)__0090/) {
      $updateqaversionfile = 1;
      print STDERR " running behavioral check...\n";
      my $bhvscreening = 'missing';
      my $bhvprescan = 'missing';
      my $bhvscan = 'missing';
      my $bhvpostscan = 'missing';
      my $stimulusset = '?';
      if (%bhvdirsscreening) {
	$bhvscreening = 'exists';
      }
      if (%bhvdirsscan) {
	$bhvscan = 'exists';
        my %stimsets = ();
        for my $otdir (map { glob("${_}/bhv_s*ot_*") } (keys %bhvdirsscreening, keys %bhvdirsprescan, keys %bhvdirsscan, keys %bhvdirspostscan)) {
  	  if (open(FH, '<', "${otdir}/scannote.txt")) {
	    my @tasks = ();
	    local $/;
	    my $scannote = <FH>;
	    close FH;
	    map { $stimsets{$_} = 1 } map { ($_ =~ /StimSet (\d+)/) ? $1 : 1  } ($scannote =~ /^  Site.*/mg);
	  }
        }
        $stimulusset = join(',', keys %stimsets);
      }
      if (%bhvdirspostscan) {
	$bhvpostscan = 'exists';
      }
      if (%bhvdirsprescan) {
	$bhvprescan = 'exists';
      }
      my $curtime = time();
      open(FH, '>', ${outbhvcheckfile}) || die "Error opening ${outbhvcheckfile} for writing: $!\n";
      print FH <<EOM;
$xmlhead
  <analysis ID="${host}_${$}_${curtime}" level="episode" subjectID="${subjectid}" visitID="${visitid}" studyID="${studyid}">
$provenance
    <measurementGroup>
      <!-- fBIRN Upload Check -->
      <entity xsi:type="fbirn:labeledEntity_t">
        <label xmlns="http://www.xcede.org/xcede-2/extensions/fbirn" nomenclature="fbirnQA" termID="behavioral directory upload - fBIRNPhaseIII"/>
      </entity>
      <observation name="screening" type="varchar">${bhvscreening}</observation>
      <observation name="prescan" type="varchar">${bhvprescan}</observation>
      <observation name="scan" type="varchar">${bhvscan}</observation>
      <observation name="postscan" type="varchar">${bhvpostscan}</observation>
      <observation name="objtaskstimset" type="varchar">${stimulusset}</observation>
    </measurementGroup>
  </analysis>
$xmlfoot
EOM
      close FH;
    }
    for my $qagroup ("77degree", "") {
      my $qalabel = '';
      if ($qagroup eq "") {
        $qalabel = "Full";
      } elsif ($qagroup eq "77degree") {
        $qalabel = "Partial";
      }
      my $qadir = "${studydir}/Analysis/QA${qalabel}__0001";
      my $studymincmassz = undef;
      my $studymaxcmassz = undef;
      chdir "${outbaseqadir}/${qadir}";
      my $studyextractfile = "summaryQA.xml";
      my $studyextractmtime = (stat($studyextractfile))[9];
      my $studyoutofdate = $OPT_overwrite || ($oldrevnum == 0);
      print STDERR " ${qadir}\n";
      my @eventsfiles = glob('qa_events_*.xml');
      for (my $fileind = 0; $fileind < scalar(@eventsfiles); $fileind++) {
	my $eventsfile = @eventsfiles[$fileind];
	my ($seriesname,) = ($eventsfile =~ /^qa_events_(.*).xml$/);
	my $extractfile = "summaryQA_${seriesname}.xml";
	if (! -f $studyextractfile) {
	  $studyoutofdate = 1;
	}
	if (! -f $extractfile) {
	  $studyoutofdate = 1;
	}
	if (!$OPT_overwrite && -f $studyextractfile && -f $extractfile) {
	  my $extractmtime = (stat($extractfile))[9];
	  my $eventsmtime = (stat($eventsfile))[9];
	  if ($eventsmtime < $extractmtime) {
	    next;
	  }
	  $studyoutofdate = 1;
	}
      }
      if (!$studyoutofdate) {
	print STDERR " study image QA already up-to-date, skipping...\n";
	next;
      }
      $updateqaversionfile = 1;
      for (my $fileind = 0; $fileind < scalar(@eventsfiles); $fileind++) {
	my $eventsfile = @eventsfiles[$fileind];
	my ($seriesname,) = ($eventsfile =~ /^qa_events_(.*).xml$/);
	print STDERR "  ${seriesname}\n";
	my $extractfile = "summaryQA_${seriesname}.xml";
	unlink "${extractfile}";
	open(FH, '>', $extractfile) || die "Error opening ${extractfile}: $!\n";
	my $curtime = time();
	print FH <<EOM;
$xmlhead
  <analysis ID="${host}_${$}_${curtime}" level="episode" subjectID="${subjectid}" visitID="${visitid}" studyID="${studyid}" episodeID="${seriesname}">
$provenance
    <measurementGroup>
      <!-- fBIRN QA summary statistics -->
      <entity xsi:type="fbirn:labeledEntity_t">
        <label xmlns="http://www.xcede.org/xcede-2/extensions/fbirn" nomenclature="fbirnQA" termID="summarystats"/>
      </entity>
EOM
        my $seriesmincmassz = undef;
	my $seriesmaxcmassz = undef;
	my $seriesmaxdeltacmassz = undef;
	my $lastcmassz = undef;
        my @copynamesfull =
	    (
	     'count_volmean_indiv_z3',
	     'count_volmean_indiv_z4',
	     'count_volmean_indiv_masked_z3',
	     'count_volmean_indiv_masked_z4',
	     'mean_middle_slice',
	     'mean_snr_middle_slice',
	     'mean_sfnr_middle_slice',
	     'count_outliers_1percent',
	     'count_outliers_2percent',
	     'mean_masked_fwhmx',
	     'mean_masked_fwhmy',
	     'mean_masked_fwhmz',
            );
        my @copynamespartial =
	    (
	     'count_volmean_grand_z3',
	     'count_volmean_grand_z4',
	     'count_volmean_grand_masked_z3',
	     'count_volmean_grand_masked_z4',
	     'count_masked_velocity_1percent',
	     'count_masked_velocity_2percent',
	     'threshmin_masked_velocity_1percent',
	     'threshmax_masked_velocity_1percent',
	     'threshmin_masked_velocity_2percent',
	     'threshmax_masked_velocity_2percent',
	     'count_mean_difference_1percent',
	     'count_mean_difference_2percent',
	     'threshmin_mean_difference_1percent',
	     'threshmax_mean_difference_1percent',
	     'threshmin_mean_difference_2percent',
	     'threshmax_mean_difference_2percent',
             @copynamesfull
            );
        my $copyregexp = '';
        if ($qagroup eq '') {
	  $copyregexp = join('|', @copynamesfull);
        } elsif ($qagroup eq '77degree') {
	  $copyregexp = join('|', @copynamespartial);
        }
	my $dataref = QAMetadata::new(\*FH, $copyregexp);
	my $parser = XML::SAX::ParserFactory->parser(Handler=>$dataref);
	$parser->parse_uri($eventsfile);
	# do cmassz
	my @cmassz = @{$dataref->{'cmasszlist'}};
	my @deltacmassz = map { abs($cmassz[$_+1] - $cmassz[$_]) } (0..$#cmassz-1);
	@cmassz = sort { $a <=> $b } @cmassz;
	@deltacmassz = sort { $a <=> $b } @deltacmassz;
	$seriesmincmassz = $cmassz[0];
	$seriesmaxcmassz = $cmassz[$#cmassz];
	$seriesmaxdeltacmassz = $deltacmassz[$#deltacmassz];
	if (defined($seriesmincmassz) && defined($seriesmaxcmassz)) {
	  my $maxdispcmassz = $seriesmaxcmassz - $seriesmincmassz;
	  print FH <<EOM;
      <observation name="total_displacement_cmassz" type="float">${maxdispcmassz}</observation>
EOM
        }
	if (defined($seriesmaxdeltacmassz)) {
	  print FH <<EOM;
      <observation name="max_delta_displacement_cmassz" type="float">${seriesmaxdeltacmassz}</observation>
EOM
        }
	my @spikelines = `${ScriptInstallDir}/bin/fmriqa_count --granularity=voxel qa_slicevardata_${seriesname}.bxh`;
	my $numspiky = 0;
	map {
	  chomp $_;
	  if (! /^\#/) {
	    my @fields = split(/\s+/, $_);
	    if (scalar(@fields) != 5) {
	      die "ERROR: output of fmriqa_count does not have expected number of fields (5) in this line: $_\n";
	    }
	    if ($fields[4] >= 20) {
	      $numspiky++;
	    }
	  }
	} @spikelines;
	print FH <<EOM;
      <!-- num_spiky_slices refers to the number of slices that have a per-slice variation value greater than 20 -->
      <observation name="num_spiky_slices" type="integer">${numspiky}</observation>
EOM
        print FH <<EOM;
    </measurementGroup>
  </analysis>
$xmlfoot
EOM
        if (defined($seriesmincmassz) && (!defined($studymincmassz) || $seriesmincmassz < $studymincmassz)) {
          $studymincmassz = $seriesmincmassz;
        }
	if (defined($seriesmaxcmassz) && (!defined($studymaxcmassz) || $seriesmaxcmassz > $studymaxcmassz)) {
	  $studymaxcmassz = $seriesmaxcmassz;
	}
	close FH;
      }
      chdir "${outbaseqadir}/${qadir}";
      print STDERR " study summary stats\n";
      print STDERR "  max study displacement\n";
      open(FH, '>', 'summaryQA.xml') || die "Error opening 'summaryQA.xml': $!\n";
      my $curtime = time();
      print FH <<EOM;
$xmlhead
  <analysis ID="${host}_${$}_${curtime}" level="study" subjectID="${subjectid}" visitID="${visitid}" studyID="${studyid}">
$provenance
EOM
      if ($qagroup eq '77degree') {
        print FH <<EOM;
    <measurementGroup>
      <!-- fBIRN QA summary statistics -->
      <entity xsi:type="fbirn:labeledEntity_t">
        <label xmlns="http://www.xcede.org/xcede-2/extensions/fbirn" nomenclature="fbirnQA" termID="summarystats"/>
      </entity>
EOM
        if (defined($studymincmassz) && defined($studymaxcmassz)) {
          my $maxdispcmassz = $studymaxcmassz - $studymincmassz;
	  print FH <<EOM;
      <observation name="total_displacement_cmassz" type="float">${maxdispcmassz}</observation>
EOM
        }
        print FH <<EOM;
    </measurementGroup>
EOM
      }
      my $mean77 = undef;
      my $var77 = undef;
      my $mean10 = undef;
      my $var10 = undef;
      my ($restFA77input, $restFA10input) = map { "${BASEPROJECTS}/${project}/Data/${studydir}/$_/Native/Original__0001/NIFTI4D/f.nii.gz" } ('restFA77', 'restFA10');
      if (-f 'qa_events_restFA10.xml' && -f 'qa_events_restFA77.xml' && -f $restFA77input && -f $restFA10input) {
	print STDERR "  dual flip angle\n";
	for my $seriesname ('restFA10', 'restFA77') {
	  my $eventsfile = "qa_events_${seriesname}.xml";
	  my $inputimage = undef;
	  if ($seriesname eq 'restFA10') {
	    $inputimage = $restFA10input;
	  } elsif ($seriesname eq 'restFA77') {
	    $inputimage = $restFA77input;
	  }
	  my $maskfile = "tmp_${pid}_mask.nii";
	  if ($OPT_debug) {
	    print STDERR "Running: ${ScriptInstallDir}/bin/3dAutomask -q -erode 5 -prefix $maskfile $inputimage\n";
	    system("${ScriptInstallDir}/bin/3dAutomask -q -erode 5 -prefix $maskfile $inputimage");
	  } else {
	    system("${ScriptInstallDir}/bin/3dAutomask -q -erode 5 -prefix $maskfile $inputimage 2>/dev/null");
	  }
	  if ($? == -1) {
	    die "Failed to execute 3dAutomask: $!\n";
	  } elsif ($? & 127 || ($? >> 8 != 0)) {
	    die "Error running 3dAutomask: child exited" .
		(($? & 127) ? (' with signal ' . ($? & 127)) : (' with exit status ' . ($? >> 8))) .
		(($? & 128) ? ', core dumped' : '') .
		"\n";
	  }
	  my $rawmean = undef;
	  my @rawmeanlines = `${ScriptInstallDir}/bin/fmriqa_volmeasures --maskfile ${maskfile} ${inputimage}`;
	  @rawmeanlines = grep { ! /^\#/ } @rawmeanlines;
	  (undef, $rawmean, undef, undef, undef, undef) = split(/\s+/, $rawmeanlines[0]);
	  my $volregfile = "tmp_${pid}_volreg.nii";
	  system("${ScriptInstallDir}/bin/3dvolreg -prefix $volregfile $inputimage 2>/dev/null");
	  if ($? == -1 || $? & 127 || $? >> 8) {
	    die "Error running 3dvolreg\n";
	  }
	  my $detrendauxfile = "tmp_${pid}_detrendaux.nii";
	  system("${ScriptInstallDir}/bin/3dDetrend -polort 2 -prefix $detrendauxfile $volregfile 2>/dev/null");
	  if ($? == -1 || $? & 127 || $? >> 8) {
	    die "Error running 3dDetrend\n";
	  }
	  my $detrendfile = "tmp_${pid}_detrend.bxh";
	  system("${ScriptInstallDir}/bin/bxh_binop --mask $maskfile --add $detrendauxfile --scalar $rawmean $detrendfile 2>/dev/null");
	  if ($? == -1 || $? & 127 || $? >> 8) {
	    die "Error running bxh_binop\n";
	  }
	  my $meanfile = "tmp_${pid}_mean.bxh";
	  my $stddevfile = "tmp_${pid}_stddev.bxh";
	  system("${ScriptInstallDir}/bin/bxh_mean", '--stddev', $stddevfile, $detrendfile, $meanfile);
	  if ($? == -1 || $? & 127 || $? >> 8) {
	    die "Error running bxh_mean\n";
	  }
	  my @meanlines = `${ScriptInstallDir}/bin/fmriqa_volmeasures --maskfile ${maskfile} ${meanfile}`;
	  my @stddevlines = `${ScriptInstallDir}/bin/fmriqa_volmeasures --maskfile ${maskfile} ${stddevfile}`;
	  unlink glob("tmp_${pid}_*");
#	  my ($seriesname,) = ($eventsfile =~ /^qa_events_(.*).xml$/);
#	  my $maskfile = "qa_maskdata_${seriesname}.bxh";
#	  my $meanfile = "qa_meandata_${seriesname}.bxh";
#	  my $stddevfile = "qa_stddevdata_${seriesname}.bxh";
#	  my @meanlines = `${ScriptInstallDir}/bin/fmriqa_volmeasures --maskfile ${maskfile} ${meanfile}`;
#	  my @stddevlines = `${ScriptInstallDir}/bin/fmriqa_volmeasures --maskfile ${maskfile} ${stddevfile}`;
	  @meanlines = grep { ! /^\#/ } @meanlines;
	  @stddevlines = grep { ! /^\#/ } @stddevlines;
	  my $mean = undef;
	  my $var = undef;
	  my $stddev = undef;
	  (undef, $mean, undef, undef, undef, undef) = split(/\s+/, $meanlines[0]);
	  (undef, $stddev, undef, undef, undef, undef) = split(/\s+/, $stddevlines[0]);
	  $var = $stddev * $stddev;
	  if ($seriesname eq 'restFA77') {
	    $mean77 = $mean;
	    $var77 = $var;
	  } elsif ($seriesname eq 'restFA10') {
	    $mean10 = $mean;
	    $var10 = $var;
	  }
	}
      }
      if (defined($mean77) && defined($var77) && defined($mean10) && defined($var10)) {
	$updateqaversionfile = 1;
	my $M = ($mean77 / $mean10);
	$M = $M * $M;
	my $thermalvar = (($M * $var10) - $var77) / ($M - 1);
	my $signalweightedvar = ($var77 - $thermalvar);
	if ($signalweightedvar < 0) {
	  $thermalvar = $var10;
	  $signalweightedvar = $var77 - $var10;
	}
        if ($thermalvar < 0 || $signalweightedvar < 0) {
          warn "   skipping due to negative variance!\n";
        } else {
          my $thermalfsnr = $mean77 / sqrt($thermalvar);
          my $signalweightedfsnr = $mean77 / sqrt($signalweightedvar);
          print FH <<EOM;
    <measurementGroup>
      <!-- "fBIRN QA summary statistics (f sub doug)" -->
      <entity xsi:type="fbirn:labeledEntity_t">
        <label xmlns="http://www.xcede.org/xcede-2/extensions/fbirn" nomenclature="fbirnQA" termID="dual flip angle stats"/>
      </entity>
      <observation name="mean77" type="float">${mean77}</observation>
      <observation name="var77" type="float">${var77}</observation>
      <observation name="mean10" type="float">${mean10}</observation>
      <observation name="var10" type="float">${var10}</observation>
      <observation name="M" type="float">${M}</observation>
      <observation name="thermalvar" type="float">${thermalvar}</observation>
      <observation name="signalweightedvar" type="float">${signalweightedvar}</observation>
      <observation name="thermalFSNR" type="float">${thermalfsnr}</observation>
      <observation name="signalweightedFSNR" type="float">${signalweightedfsnr}</observation>
    </measurementGroup>
EOM
        }
      }
      print FH <<EOM;
  </analysis>
$xmlfoot
EOM
    }
    if ($updateqaversionfile && $oldrevnum != $revnum) {
      open(FH, '>', "${outqaversionfile}") || die "Error opening ${outqaversionfile}\n";
      print FH "${rev}\n";
      close FH;
    }
  }
}
