#!/usr/bin/perl

use FindBin;
use lib "$FindBin::Bin";

use XML::XPath;
use XML::XPath::XMLParser;

my $nodesonly = 0;
if ($ARGV[0] eq '--nodesonly') {
  $nodesonly = 1;
  shift;
}

my $parser = XML::XPath->new(filename => shift);

while ($#ARGV >= 0) {
  if ($nodesonly) {
    print join("\n", map { "/" . join("/", map { $_->getName() } $parser->findnodes("ancestor-or-self::*", $_)) } $parser->findnodes(shift)), "\n";
  } else {
    print join("\n", map { $_->string_value() } $parser->findnodes(shift)), "\n";
  }
}
