//exitCode=0 sucessful, 
//exitCode=3 problem with database
//exitCode=2 xml file not found
//exitCode=1 xml parder failed

import javax.xml.parsers.*;       // JAXP classes for obtaining a SAX Parser
import org.xml.sax.*;             // The main SAX package
import org.xml.sax.helpers.*;     // SAX helper classes
import java.io.*;                 // For reading the input file
import java.sql.*;

public class SetProject extends org.xml.sax.helpers.DefaultHandler {

    static int exitCode=0;
    StringBuffer accumulator;                   
    String stringLocation, stringMaker, stringModel; 
    String stringName, stringDesc, stringType, stringID;
    String subjectGroupType;
    String contactFirstName, contactLastName, contactEmail, baseURI;
    int contactPersonID = -1;
    int subjectGroupTypeID = -1;
    int paradigmVersion = -1;
    int experimentID = -1; 
    String dbType;

    static Statement s = null;
    static Connection conn = null;

    static void usage() {
      System.err.println("Usage: SetProject <xml-config-file> <user> <pwd> <dbURL-suffix> <db-type (postgres|oracle) > ");
      System.exit(-1);
    }

    public static void main(String[] args) 
    {
        if (args.length != 5) 
          usage();
	try {
		SAXParserFactory factory = SAXParserFactory.newInstance();
		factory.setValidating(false);  
		factory.setNamespaceAware(false);
		SAXParser parser = factory.newSAXParser();
                String dbType = args[4]; 
  		String dbURL = "jdbc:oracle:thin:@";
		if (dbType.equalsIgnoreCase("postgres"))
		   dbURL = "jdbc:postgresql://";
    		dbURL = dbURL + args[3];
		SetProject handler = new SetProject(dbURL, args[1], args[2], dbType); 
		parser.parse(new File(args[0]), handler);
        } catch (SAXException se) {
                se.printStackTrace();
                exitCode = 1;
        } catch (IOException ioe) {
                ioe.printStackTrace();
                exitCode = 2;
        } catch (SQLException sqle) {
                sqle.printStackTrace();
                exitCode = 3;
        } catch (Exception e) {
                e.printStackTrace();
                exitCode = 4;
        } finally {
            try {
                if (exitCode != 0)
                        conn.rollback();
                else
                        conn.commit();
                s.close( );
                conn.close( );
            } catch (Exception e) {  }
        }
        System.exit(exitCode);
    }


    SetProject(String dbURL, String user, String pwd, String dbType)
                throws SQLException
    {
        this.dbType = dbType;
        String driver = "oracle.jdbc.driver.OracleDriver";
	if (dbType.equalsIgnoreCase("postgres"))
	  driver = "org.postgresql.Driver"; 
        try {
                Class.forName(driver);
                conn = DriverManager.getConnection(dbURL, user, pwd);
                conn.setAutoCommit(false);
                s = conn.createStatement( );
        }
        catch (Exception e) {
            if (e instanceof SQLException)
            {
                System.out.println("SQL State: " +
                                   ((SQLException)e).getSQLState( ));
                exitCode=3;
                throw new SQLException("SQL error");
            }
            System.out.println(e);
            System.out.println("Usage: java SetProject configuration_xml username password db_hoststring");
        }

    }

    private int runSql(String sqlStatement, String tName)
                throws SAXException
    {
        boolean status;
        int rc = -999999;

        System.out.println("\n");
        System.out.println(tName + " sql: ");
        System.out.println(sqlStatement);

        try {
            status = s.execute(sqlStatement);
            if (status) {
                ResultSet rs = s.getResultSet();
                if (rs.next()) {
                   rc = rs.getInt(1);
                }
            }

        }
        catch (SQLException e) {
                e.printStackTrace();
                System.out.println("SetProject: " + e.getMessage( )+ ":" +
                               e.getSQLState( ));
            exitCode=3;
            throw new SAXException("SQL error");
        }
        return rc;
    }

    public void startDocument() {
	accumulator = new StringBuffer();
    }

    public void characters(char[] buffer, int start, int length) {
	accumulator.append(buffer, start, length);
    }

    public void startElement(String namespaceURL, String localName,
			     String qname, Attributes attributes) {
	accumulator.setLength(0);
	if (qname.equals("ID")) {
		stringID = "-1";
	}
	else if (qname.equals("name")) {
		stringName = "";
	}
	else if (qname.equals("seriesParadigm")) {
		stringDesc= "";
	}
	else if (qname.equals("type")) {
		stringType = "";
	}
    }

    protected String getInsertProtocolSql() {
	if (dbType.equalsIgnoreCase("postgres")) {
	  return  "insert into nc_protocol(protocolversion, protocolid, uniqueid, tableid, " +
			   "owner, modtime,moduser, name, description)" +
			   "select " + paradigmVersion + ", '" + stringName + 
                           "', nextval('uid_seq'), tableID, owner, now(), moduser, '" + stringName +
                           "', '' from " +
			   "nc_tableid where tablename = 'NC_PROTOCOL'";

	} else {
	 return  "insert into nc_protocol(PROTOCOLVERSION, PROTOCOLID, UNIQUEID, TABLEID, " +
			   "OWNER, MODTIME,MODUSER, NAME, DESCRIPTION)" +
			   "select " + paradigmVersion + ", '" + stringName + 
                           "', uid_seq.nextval, tableID, owner, sysdate, moduser, '" + stringName +
                           "', '' from " +
			   "nc_tableID where tableName = 'NC_PROTOCOL'";
	}
    }

    protected String getInsertResearchGroupTypeSql() {
	if (dbType.equalsIgnoreCase("postgres")) {
	       return "insert into nc_researchgrouptype(uniqueid, tableid, owner, modtime,moduser, name, " + 
                      "description) select  " +
                      "nextval('uid_seq'), tableid, owner, now(), moduser, '" + subjectGroupType +  
                      "', '' from nc_tableid where tablename = 'NC_RESEARCHGROUPTYPE'";

	} else {
	         return "insert into nc_researchGroupType(UNIQUEID, TABLEID, OWNER, MODTIME,MODUSER, NAME, " + 
                      "DESCRIPTION) select  " +
                      "uid_seq.nextval, tableid, owner, sysdate, moduser, '" + subjectGroupType +  
                      "', '' from nc_tableID where tableName = 'NC_RESEARCHGROUPTYPE'";

	}
    }

    protected String getInsertResearchGroupSql() {
	if (dbType.equalsIgnoreCase("postgres")) {
		return "insert into nc_researchgroup(uniqueid, tableid, owner, modtime,moduser, name, " + 
		      "description, nc_researchgrouptype_uniqueid, nc_experiment_uniqueid) " +
		      "select nextval('uid_seq'), tableid, owner, now(), moduser, '" + stringName + "', '', " +
		      subjectGroupTypeID + ", " + experimentID + " from nc_tableid where tablename = 'NC_RESEARCHGROUP'";

	} else {
     	  return "insert into nc_researchgroup(UNIQUEID, TABLEID, OWNER, MODTIME,MODUSER, NAME, " + 
		      "DESCRIPTION, NC_RESEARCHGROUPTYPE_UNIQUEID, NC_EXPERIMENT_UNIQUEID) " +
		      "select uid_seq.nextval, tableid, owner, sysdate, moduser, '" + stringName + "', '', " +
		      subjectGroupTypeID + ", " + experimentID + " from nc_tableID where tableName = 'NC_RESEARCHGROUP'";

	}
    }

    protected String getInsertCollectionEqSql() {
	if (dbType.equalsIgnoreCase("postgres")) {
	 return  "insert into nc_collectionequipment(uniqueid, tableid, owner, modtime,moduser, make, model)" +
		      "select nextval('uid_seq'), tableid, owner, now(), moduser, '" + stringMaker +
		      "', '" + stringModel + "' from nc_tableid where tablename = 'NC_COLLECTIONEQUIPMENT'";
	} else {
	   return "insert into nc_collectionEquipment(UNIQUEID, TABLEID, OWNER, MODTIME,MODUSER, MAKE, MODEL)" +
		      "select uid_seq.nextval, tableid, owner, sysdate, moduser, '" + stringMaker +
		      "', '" + stringModel + "' from nc_tableid where tableName = 'NC_COLLECTIONEQUIPMENT'";

	}
    }

    protected String getInsertVisitTypeSql() {
	if (dbType.equalsIgnoreCase("postgres")) {
	   return "insert into nc_visittype(visittype, uniqueid, tableid, owner, modtime,moduser, description) " +
		    "select '" + stringName + "', nextval('uid_seq'), tableid, owner, modtime,moduser, '" +
		    stringDesc + "' from nc_tableid where tablename = 'NC_VISITTYPE'";

	} else {
		return "insert into nc_visitType(VISITTYPE, UNIQUEID, TABLEID, OWNER, MODTIME,MODUSER, DESCRIPTION) " +
		    "select '" + stringName + "', uid_seq.nextval, TABLEID, OWNER, MODTIME,MODUSER, '" +
		    stringDesc + "' from nc_tableID where tableName = 'NC_VISITTYPE'";

	}
    }

    protected String getNextSeqSql() {
       	if (dbType.equalsIgnoreCase("postgres")) {
            return  "select nextval('uid_seq')";
	} else {
            return  "select uid_seq.nextval from nc_tableID where tablename = 'NC_PERSON'";
	}
    }

    protected String getInsertPersonSql(int contactPersonID) {
	if (dbType.equalsIgnoreCase("postgres")) {
          return "insert into nc_person select " + contactPersonID + ", tableid, owner, now(), moduser, '" +
		          contactFirstName + "', '" + contactLastName + "', '" + contactEmail + 
			  "' from nc_tableid where tablename = 'NC_PERSON'";	
	} else {
	    return "insert into nc_person select " + contactPersonID + ", tableID, owner, sysdate, moduser, '" +
		          contactFirstName + "', '" + contactLastName + "', '" + contactEmail + 
			  "' from nc_tableID where tableName = 'NC_PERSON'";	

	}
    }

    protected String getInsertExperimentSql(int experimentID, int contactPersonID) {
	if (dbType.equalsIgnoreCase("postgres")) {
	       return "insert into nc_experiment(uniqueid, tableid, owner, modtime,moduser, name, " + 
                         "description, contactperson, baseuri, isregressiondata) select  " +
                         experimentID + ", tableid, owner, now(), moduser, '" + stringName + "__" + stringID + 
			 "', '', " + contactPersonID + ", '" + baseURI + 
			 "', false from nc_tableid where tablename = 'NC_EXPERIMENT'";

	} else {
	     return "insert into nc_experiment(UNIQUEID, TABLEID, OWNER, MODTIME,MODUSER, NAME, " + 
                         "DESCRIPTION, CONTACTPERSON, BASEURI, ISREGRESSIONDATA) select  " +
                         experimentID + ", tableid, owner, sysdate, moduser, '" + stringName + "__" + stringID + 
			 "', '', " + contactPersonID + ", '" + baseURI + 
			 "', 0 from nc_tableID where tableName = 'NC_EXPERIMENT'";

	}
    }

    public void endElement(String namespaceURL, String localName, String qname)
		throws SAXException
    {
	String sql, stringTemp;
	if (qname.equals("description")) {
		stringDesc = accumulator.toString().trim();
	}
	else if (qname.equals("ID")) {   
		stringID = accumulator.toString().trim();
	}
	else if (qname.equals("paradigm")) {   
		stringName = accumulator.toString().trim();
	}
	else if (qname.equals("paradigmVersion")) {   
		stringTemp = accumulator.toString().trim();
                try {
                        paradigmVersion = Integer.parseInt(stringTemp);
                }
                catch (NumberFormatException e) {
                        throw new SAXException("Incorrect paradigmVersion, " + stringTemp);
                }
	}
	else if (qname.equals("seriesParadigm")) {
		sql = "select uniqueid from nc_protocol where protocolversion = " + paradigmVersion +
		   " and protocolid = '" + stringName + "'";
		if (runSql(sql, "paradigm") < 0)
		{
			sql = "insert into nc_protocol(PROTOCOLVERSION, PROTOCOLID, UNIQUEID, TABLEID, " +
			   "OWNER, MODTIME,MODUSER, NAME, DESCRIPTION)" +
			   "select " + paradigmVersion + ", '" + stringName + 
                           "', uid_seq.nextval, tableID, owner, sysdate, moduser, '" + stringName +
                           "', '' from " +
			   "nc_tableID where tableName = 'NC_PROTOCOL'";
                        sql = getInsertProtocolSql();
		        runSql(sql, "protocol");
		} 
	}
	else if (qname.equals("subjectGroupType")) {
		subjectGroupType = accumulator.toString().trim();
	}
	else if (qname.equals("subjectGroup")) {
		sql = "select max(uniqueid) from nc_researchgrouptype where name = '" +
		   subjectGroupType + "'";
		subjectGroupTypeID = runSql(sql, "subjectGroupType");
		if (subjectGroupTypeID < 1 ) {
	           sql = "insert into nc_researchGroupType(UNIQUEID, TABLEID, OWNER, MODTIME,MODUSER, NAME, " + 
                      "DESCRIPTION) select  " +
                      "uid_seq.nextval, tableid, owner, sysdate, moduser, '" + subjectGroupType +  
                      "', '' from nc_tableID where tableName = 'NC_RESEARCHGROUPTYPE'";
		   sql = getInsertResearchGroupTypeSql();
    		   runSql(sql, "subjectGroupType");
		}
		sql = "select count(*) from nc_researchgroup where name = '" + stringName + 
		   "' and NC_EXPERIMENT_UNIQUEID =" + experimentID; 
		if (runSql(sql, "subjectGroup") < 1 ) {
		   sql = "insert into nc_researchgroup(UNIQUEID, TABLEID, OWNER, MODTIME,MODUSER, NAME, " + 
		      "DESCRIPTION, NC_RESEARCHGROUPTYPE_UNIQUEID, NC_EXPERIMENT_UNIQUEID) " +
		      "select uid_seq.nextval, tableid, owner, sysdate, moduser, '" + stringName + "', '', " +
		      subjectGroupTypeID + ", " + experimentID + " from nc_tableID where tableName = 'NC_RESEARCHGROUP'";
		   sql = getInsertResearchGroupSql();   
		   runSql(sql, "subjectGroup");
		}
	}
	else if (qname.equals("name")) {
		stringName = accumulator.toString().trim();
	}
	else if (qname.equals("location")) {
		stringLocation = accumulator.toString().trim();
	}
	else if (qname.equals("maker")) {
		stringMaker = accumulator.toString().trim();
	}
	else if (qname.equals("model")) {
		stringModel = accumulator.toString().trim();
	}
	else if (qname.equals("collectionEquipment")) {
		sql = "select max(uniqueid) from nc_collectionEquipment where make = '" + stringMaker +
		   "' and model = '" + stringModel + "'";
    		if (runSql(sql, "collectionEquipment") < 1 )
		{
		   sql = "insert into nc_collectionEquipment(UNIQUEID, TABLEID, OWNER, MODTIME,MODUSER, MAKE, MODEL)" +
		      "select uid_seq.nextval, tableid, owner, sysdate, moduser, '" + stringMaker +
		      "', '" + stringModel + "' from nc_tableid where tableName = 'NC_COLLECTIONEQUIPMENT'";
                   sql = getInsertCollectionEqSql();
    		   runSql(sql, "subjectGroupType");
		}
	}
	else if (qname.equals("contactFirstName")) {
		contactFirstName = accumulator.toString().trim();
	}
	else if (qname.equals("contactLastName")) {
		contactLastName = accumulator.toString().trim();
	}
	else if (qname.equals("contactEmail")) {
		contactEmail = accumulator.toString().trim();
	}
	else if (qname.equals("visitType")) {
	    	sql = "select count(*) from nc_visittype where visittype = '" + stringName + "'";
    	    	if (runSql(sql, "visitType") < 1 )
	    	{
		   sql = "insert into nc_visitType(VISITTYPE, UNIQUEID, TABLEID, OWNER, MODTIME,MODUSER, DESCRIPTION) " +
		    "select '" + stringName + "', UNIQUEID, TABLEID, OWNER, MODTIME,MODUSER, '" +
		    stringDesc + "' from nc_tableID where tableName = 'NC_VISITTYPE'";
                   sql = getInsertVisitTypeSql();
    	           runSql(sql, "visitType");
	    	}
	}
	else if (qname.equals("baseURI")) {
		baseURI = accumulator.toString().trim();
	}
	else if (qname.equals("project")) { 
	    	sql = "select uniqueid from nc_experiment where name = '" + stringName + "__" + stringID + "'";
    		experimentID = runSql(sql, "project");
		if (experimentID < 1) {
		   sql = "select max(uniqueid) from nc_person where first_name = '" + contactFirstName +
			"' and last_name = '" + contactLastName + "'";
    		   contactPersonID = runSql(sql, "project");
		   if (contactPersonID < 1) {
		      sql = "select uid_seq.nextval from nc_tableID where tablename = 'NC_PERSON'";
		      sql = getNextSeqSql();
    		      contactPersonID = runSql(sql, "project");
		      sql = "insert into nc_person select " + contactPersonID + ", tableID, owner, sysdate, moduser, '" +
		          contactFirstName + "', '" + contactLastName + "', '" + contactEmail + 
			  "' from nc_tableID where tableName = 'NC_PERSON'";	
                      sql = getInsertPersonSql(contactPersonID);
    		      runSql(sql, "project");
                   }
		   sql = "select uid_seq.nextval from nc_tableID where tableName = 'NC_EXPERIMENT'";
		   sql = getNextSeqSql();
		   experimentID = runSql(sql, "project");
	           sql = "insert into nc_experiment(UNIQUEID, TABLEID, OWNER, MODTIME,MODUSER, NAME, " + 
                         "DESCRIPTION, CONTACTPERSON, BASEURI, ISREGRESSIONDATA) select  " +
                         experimentID + ", tableid, owner, sysdate, moduser, '" + stringName + "__" + stringID + 
			 "', '', " + contactPersonID + ", '" + baseURI + 
			 "', 0 from nc_tableID where tableName = 'NC_EXPERIMENT'";
                   sql = getInsertExperimentSql(experimentID, contactPersonID);
    		   runSql(sql, "project");
		}
	}
    }

    public void endDocument() {
	System.out.println("Project has been added to the database successfully!");
	
    }

    public void warning(SAXParseException exception) {
	System.out.println("WARNING: line " + exception.getLineNumber() + ": "+
			   exception.getMessage());
    }

    public void error(SAXParseException exception) {
	System.out.println("ERROR: line " + exception.getLineNumber() + ": " +
			   exception.getMessage());
    }

    public void fatalError(SAXParseException exception) throws SAXException {
	System.out.println("FATAL: line " + exception.getLineNumber() + ": " +
			   exception.getMessage());
	throw(exception);
    }
}
