import javax.xml.parsers.*;       // JAXP classes for obtaining a SAX Parser
import org.xml.sax.*;             // The main SAX package
import org.xml.sax.helpers.*;     // SAX helper classes
import java.io.*;                 // For reading the input file
import java.sql.*;

public class SubjectVisit extends org.xml.sax.helpers.DefaultHandler {

    static int exitCode=0;
    StringBuffer accumulator;                   
    String seriesName;
    String seriesTime, studyTime, visitType, visitDate, subjectGroup, subjectID; 
    String stringName, stringDesc, stringType, stringID, stringParadigmVersion, stringParadigm;
    int experimentID = -1; 
    int visitID = -1; 
    int studyID = -1; 
    int segmentID = -1; 
    int addSubject = 0;
    String dbType;

    static Statement s = null;
    static Connection conn = null;

     static void usage() {
      System.err.println("Usage: SubjectVisit <xml-config-file> <user> <pwd> <dbURL-suffix> <db-type (postgres|oracle) > ");
      System.exit(-1);
    }

    public static void main(String[] args) 
    {
        if (args.length != 5)
           usage();
        try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(false);
                SAXParser parser = factory.newSAXParser();
                String dbType = args[4];
                String dbURL = "jdbc:oracle:thin:@";
                if (dbType.equalsIgnoreCase("postgres"))
                  dbURL = "jdbc:postgresql://";
                dbURL = dbURL + args[3];
                SubjectVisit handler = new SubjectVisit(dbURL, args[1], args[2], dbType);
                parser.parse(new File(args[0]), handler);
        } catch (SAXException se) {
                se.printStackTrace();
                exitCode = 1;
        } catch (IOException ioe) {
                ioe.printStackTrace();
                exitCode = 2;
        } catch (SQLException sqle) {
                sqle.printStackTrace();
                exitCode = 3;
        } catch (Exception e) {
                e.printStackTrace();
                exitCode = 4;
        } finally {
	    try {
                if (exitCode != 0)
                        conn.rollback();
                else
                        conn.commit();
                s.close( );
                conn.close( );
            } catch (Exception e) {  }
        }
        System.exit(exitCode);
    }

    SubjectVisit(String dbURL, String user, String pwd, String dbType)
		throws SQLException
    {
        this.dbType = dbType;

	String driver = "oracle.jdbc.driver.OracleDriver";
        if (dbType.equalsIgnoreCase("postgres"))
          driver = "org.postgresql.Driver";

        try {
		Class.forName(driver);
		conn = DriverManager.getConnection(dbURL, user, pwd);
        	conn.setAutoCommit(false);
		s = conn.createStatement( );
	}
        catch (Exception e) {
            if (e instanceof SQLException)
	    {
                System.out.println("SQL State: " +
                                   ((SQLException)e).getSQLState( ));
    	        exitCode=3;
		throw new SQLException("SQL error");
	    }
            System.out.println(e);
            System.out.println("Usage: java SubjectVisit configuration_xml username password db_hoststring");
        }

    }

    private int runSql(String sqlStatement, String tName) 
		throws SAXException
    {
	boolean status;
  	int rc = -999999;
	
	System.out.println("\n");
	System.out.println(tName + " sql: ");
	System.out.println(sqlStatement);

	try {
	    status = s.execute(sqlStatement);
	    if (status) {
		ResultSet rs = s.getResultSet();  
		if (rs.next()) {
		   rc = rs.getInt(1);
		}
            }

       	}
       	catch (SQLException e) {
            System.out.println("SubjectVisit: " + e.getMessage( )+ ":" +
                               e.getSQLState( ));
    	    exitCode=3;
	    throw new SAXException("SQL error");
        }
	return rc;
    }


    // Called at the beginning of parsing.  We use it as an init() method
    public void startDocument() {
	accumulator = new StringBuffer();
    }

    public void characters(char[] buffer, int start, int length) {
	accumulator.append(buffer, start, length);
    }

    public void startElement(String namespaceURL, String localName,
			     String qname, Attributes attributes) {
	accumulator.setLength(0);
	if (qname.equals("ID")) {
		stringID = "-1";
	}
	else if (qname.equals("name")) {
		stringName = "";
	}
	else if (qname.equals("type")) {
		stringType = "";
	}
	else if (qname.equals("series")) {
		stringType = "";
		stringID = "";
		seriesName = "";
		stringParadigm = "";
		stringParadigmVersion = "";
		stringDesc = "";
		seriesTime = "";
	}
    }

    private String escapeString(String in) {
	if (in == null) {
	    return null;
	}
	return in.replace("'", "''");
    }

    protected String getInsertSegmentSql(int segmentID) {
      if (dbType.equalsIgnoreCase("postgres")) {
	  return "insert into nc_expsegment(segmentid, componentid, nc_experiment_uniqueid, subjectid, uniqueid, tableid, owner, modtime, moduser, time_stamp, description, studyid, protocolversion, protocolid, name, timeinterval, istimeinterval, isbad) select " + segmentID + ", " + visitID + "," + experimentID + ", '" + escapeString(subjectID) + "', nextval('uid_seq'), tableid, owner, now(), moduser, to_timestamp('" + escapeString(visitDate) + " " + escapeString(seriesTime) + "', 'YYYY-MM-DD HH24:MI:SS'),'" + escapeString(stringDesc) + "', " + studyID + ", " + stringParadigmVersion + ", '" + escapeString(stringParadigm) + "', '" + escapeString(seriesName) + "', null, false, false from nc_tableid where tablename = 'NC_EXPSEGMENT'";

       } else {
	  return "insert into nc_expSegment(segmentid, COMPONENTID, NC_EXPERIMENT_UNIQUEID, SUBJECTID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP, DESCRIPTION, studyid, protocolversion, protocolid, NAME, TIMEINTERVAL, ISTIMEINTERVAL, isbad) select " + segmentID + ", " + visitID + "," + experimentID + ", '" + escapeString(subjectID) + "', uid_seq.nextval, tableid, owner, sysdate, moduser, to_timestamp('" + escapeString(visitDate) + " " + escapeString(seriesTime) + "', 'YYYY-MM-DD HH24:MI:SS'),'" + escapeString(stringDesc) + "', " + studyID + ", " + stringParadigmVersion + ", '" + escapeString(stringParadigm) + "', '" + escapeString(seriesName) + "', null, 0, 0 from nc_tableid where tableName = 'NC_EXPSEGMENT'";
       }
    }

    protected String getUpdateSegmentSql(int segmentID) {
      if (dbType.equalsIgnoreCase("postgres")) {
	  return "UPDATE nc_expsegment SET modtime=now(), time_stamp=to_timestamp('" + escapeString(visitDate) + " " + escapeString(seriesTime) + "', 'YYYY-MM-DD HH24:MI:SS'), description='" + escapeString(stringDesc) + "', protocolversion='" + stringParadigmVersion + "', protocolid='" + escapeString(stringParadigm) + "', name='" + escapeString(seriesName) + "' WHERE segmentid=" + segmentID + " AND componentid=" + visitID + " AND nc_experiment_uniqueid=" + experimentID + " AND subjectid='" + escapeString(subjectID) + "'";
       } else {
	  return "UPDATE nc_expsegment SET modtime=sysdate, time_stamp=to_timestamp('" + escapeString(visitDate) + " " + escapeString(seriesTime) + "', 'YYYY-MM-DD HH24:MI:SS'), description='" + escapeString(stringDesc) + "', protocolversion='" + stringParadigmVersion + "', protocolid='" + escapeString(stringParadigm) + "', name='" + escapeString(seriesName) + "' WHERE segmentid=" + segmentID + " AND componentid=" + visitID + " AND nc_experiment_uniqueid=" + experimentID + " AND subjectid='" + escapeString(subjectID) + "'";
       }
    }

    protected String getInsertSubjectSql() {
	if (dbType.equalsIgnoreCase("postgres")) {
	    return "insert into nc_humansubject(subjectid,uniqueid, tableid, owner, modtime,moduser, extensionname,nc_animalspecies_uniqueid) select '" + escapeString(subjectID) + "', nextval('uid_seq'), tableid, owner, now(), owner, 'humanSubject', (select max(uniqueid) from nc_animalspecies where name = 'researchSubject') from nc_tableid where tablename = 'NC_HUMANSUBJECT'";
	} else {
	    return "insert into nc_humansubject(SUBJECTID,UNIQUEID, TABLEID, OWNER, MODTIME,MODUSER, EXTENSIONNAME,NC_ANIMALSPECIES_UNIQUEID) select '" + escapeString(subjectID) + "', uid_seq.nextval, tableid, owner, sysdate, owner, 'humanSubject', (select max(uniqueid) from nc_animalspecies where name = 'researchSubject') from nc_tableID where tableName = 'NC_HUMANSUBJECT'";
	}
    }

    protected String getInsertSubjExpSql() {
	if (dbType.equalsIgnoreCase("postgres")) {
	    return  "insert into nc_subjexperiment (uniqueid, tableid, owner, modtime,moduser, nc_experiment_uniqueid, subjectid, nc_researchgroup_uniqueid ) select nextval('uid_seq'), tableid, owner, modtime, moduser, " + experimentID + ", '" + escapeString(subjectID) + "', (select max(uniqueid) from nc_researchgroup where name = '" + escapeString(subjectGroup) + "' and nc_experiment_uniqueid = " + experimentID + ") from nc_tableid where tablename = 'NC_SUBJEXPERIMENT'";
	} else {
	    return "insert into NC_SUBJEXPERIMENT (UNIQUEID, TABLEID, OWNER, MODTIME,MODUSER, NC_EXPERIMENT_UNIQUEID, SUBJECTID, NC_RESEARCHGROUP_UNIQUEID ) select uid_seq.nextval, tableid, owner, modtime, moduser, " + experimentID + ", '" + escapeString(subjectID) + "', (select max(uniqueid) from nc_researchgroup where name = '" + escapeString(subjectGroup) + "' and NC_EXPERIMENT_UNIQUEID = " + experimentID + ") from nc_tableid where tableName = 'NC_SUBJEXPERIMENT'";
	}
    }

    protected String getInsertVisitSql() {
	if (dbType.equalsIgnoreCase("postgres")) {
	    return "insert into nc_expcomponent(componentid, nc_experiment_uniqueid, subjectid, uniqueid, tableid, owner, modtime, moduser, time_stamp, description, visittype, name, timeinterval, istimeinterval) select " + visitID + "," + experimentID + ", '" + escapeString(subjectID) + "', nextval('uid_seq'), tableid, owner, now(), moduser, to_timestamp('" + escapeString(visitDate) + "', 'YYYY-MM-DD HH24:MI:SS'),'" + escapeString(stringDesc) + "', '" + escapeString(visitType) + "', '" + escapeString(stringName) + "', null, false from nc_tableid where tablename = 'NC_EXPCOMPONENT'";
	} else {
	    return "insert into nc_expComponent(COMPONENTID, NC_EXPERIMENT_UNIQUEID, SUBJECTID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP, DESCRIPTION, VISITTYPE, NAME, TIMEINTERVAL, ISTIMEINTERVAL) select " + visitID + "," + experimentID + ", '" + escapeString(subjectID) + "', uid_seq.nextval, tableid, owner, sysdate, moduser, to_timestamp('" + escapeString(visitDate) + "', 'YYYY-MM-DD HH24:MI:SS'),'" + escapeString(stringDesc) + "', '" + escapeString(visitType) + "', '" + escapeString(stringName) + "', null, 0 from nc_tableid where tableName = 'NC_EXPCOMPONENT'";
	}
    }

    protected String getInsertStudySql() {
	if (dbType.equalsIgnoreCase("postgres")) {
	    return  "insert into nc_expstudy(studyid, componentid, experimentid, subjectid, uniqueid, tableid, owner, modtime, moduser, time_stamp, description, name, timeinterval, istimeinterval) select " + studyID + ","  + visitID + "," + experimentID + ", '" + escapeString(subjectID) + "', nextval('uid_seq'), tableid, owner, now(), moduser, to_timestamp('" + escapeString(visitDate) + " " + escapeString(studyTime) + "', 'YYYY-MM-DD HH24:MI:SS'),'" + escapeString(stringDesc) + "', '" + escapeString(stringName) + "', null, false from nc_tableid where tablename = 'NC_EXPSTUDY'";
	} else {
	    return "insert into nc_expStudy(studyid, COMPONENTID, EXPERIMENTID, SUBJECTID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP, DESCRIPTION, NAME, TIMEINTERVAL, ISTIMEINTERVAL) select " + studyID + ","  + visitID + "," + experimentID + ", '" + escapeString(subjectID) + "', uid_seq.nextval, tableid, owner, sysdate, moduser, to_timestamp('" + escapeString(visitDate) + " " + escapeString(studyTime) + "', 'YYYY-MM-DD HH24:MI:SS'),'" + escapeString(stringDesc) + "', '" + escapeString(stringName) + "', null, 0 from nc_tableid where tableName = 'NC_EXPSTUDY'";
	}
    }

    public void endElement(String namespaceURL, String localName, String qname)
		throws SAXException
    {
	String sql;
	int rowCount = -1; 
	int tempInt = -1; 
        int segmentID = -1; 
	if (qname.equals("series")) {   
	   //only series of these types are added to expsegment
	   if ( stringType.equals("functional-with-behavioral") || stringType.equals("functional") || stringType.equals("behavioral") 
		|| stringType.equals("structural") ||  stringType.equals("clinical") ) { 
		//get segmentID
		try {
			segmentID = Integer.parseInt(stringID);
		}
		catch (NumberFormatException e) {
		    // Check if there is a segment with the same name
		    sql = "select count(*) from nc_expsegment where subjectid = '" + escapeString(subjectID) + "' and nc_experiment_uniqueid = " + experimentID + " and componentid = " + visitID + " and studyid = " +studyID + " and name = '" + escapeString(seriesName) + "'"; 
		    int matchingSegments = runSql(sql, "series");
		    // If found, use that segment ID
		    sql = "select max(segmentid) from nc_expsegment where subjectid = '" + escapeString(subjectID) + "' and nc_experiment_uniqueid = " + experimentID + " and componentid = " + visitID + " and studyid = " +studyID + " and name = '" + escapeString(seriesName) + "'";
		    segmentID = runSql(sql , "series");
		    System.out.println("segmentID='" + segmentID + "'");
		    if (segmentID < 1) {
			// Otherwise, use a new segment ID
			sql = "select max(segmentid) + 1 from nc_expsegment where subjectid = '" + escapeString(subjectID) + "' and nc_experiment_uniqueid = " + experimentID + " and componentid = " + visitID;
			segmentID = runSql(sql , "series");
		    }
		    if (segmentID < 1) segmentID = 1;
		    //throw new SAXException("Incorrect segmentID, " + stringID + ", for series, " + seriesName );
		}
	        sql = "select count(*) from nc_expsegment where subjectid = '" + escapeString(subjectID) + "' and nc_experiment_uniqueid = " + experimentID + " and componentid = " + visitID + " and studyid = " +studyID + " and segmentid = " + segmentID;
		  //" and studyid = " +studyID + " and name = '" + escapeString(seriesName) + "'"; 
    		rowCount = runSql(sql, "series");

		//check if the series is in the database already
		if (rowCount >= 1) {
		    // Update the series
		    sql = getUpdateSegmentSql(segmentID);
		} else {
		    //add the series
		    sql = getInsertSegmentSql(segmentID);
		}
		runSql(sql, "series");
		return;
	   }
	}
	else if (qname.equals("ID")) {
		stringID = accumulator.toString().trim();
	}
	else if (qname.equals("paradigm")) {
		stringParadigm = accumulator.toString().trim();
	}
	else if (qname.equals("paradigmVersion")) {
		stringParadigmVersion = accumulator.toString().trim();
		try {
		   if (Integer.parseInt(stringParadigmVersion)<1) throw new SAXException("Incorrect paradigmVersion");
		}
		catch (NumberFormatException e) {
	             	throw new SAXException("Incorrect paradigmVersion");
		}
	}
	else if (qname.equals("type")) {
		stringType = accumulator.toString().trim();
	}
	else if (qname.equals("description")) {
		stringDesc = accumulator.toString().trim();
	}
	if (qname.equals("seriesTime")) {   
		seriesTime = accumulator.toString().trim();
	}
	else if (qname.equals("nameStandard")) {
			seriesName = accumulator.toString().trim();
	}
	else if (qname.equals("BIRNID")) { 
	    	subjectID = accumulator.toString().trim();
	}
	else if (qname.equals("subjectGroup")) {
		subjectGroup = accumulator.toString().trim();
		sql = "select count(*) from nc_researchgroup where name = '" + escapeString(subjectGroup) + "'"; 
		if (runSql(sql, "subjectGroup") < 1 ) {
		   System.out.println("Cannot find the the subjectGroup, "  + subjectGroup + ", from HID.");
		   throw new SAXException("Incorrect subjectGroup, "  + subjectGroup);
		}
	}
	else if (qname.equals("name")) {
		stringName = accumulator.toString().trim();
	}
	else if (qname.equals("studyTime")) {
		studyTime = accumulator.toString().trim();
	}
	else if (qname.equals("visitDate")) {
		visitDate = accumulator.toString().trim();
	}
	else if (qname.equals("project")) { 
	        sql = "select uniqueid from nc_experiment where name = '" + escapeString(stringName) + "__" + escapeString(stringID) + "'";
    		experimentID = runSql(sql, "project");
		if (experimentID < 1) {
		   System.out.println("Cannot find the experiment, "  + stringName + "__" + stringID + ", from HID.");
	           throw new SAXException("The project " + stringName + "__" + stringID + "is not in HID");
		}
	    	sql = "select count(*) from nc_humanSubject where subjectid = '" + escapeString(subjectID) + "'";
		if (runSql(sql, "BIRNID") < 1 ) {
		    sql = "insert into nc_humansubject(SUBJECTID,UNIQUEID, TABLEID, OWNER, MODTIME,MODUSER, EXTENSIONNAME,NC_ANIMALSPECIES_UNIQUEID) select '" + escapeString(subjectID) + "', uid_seq.nextval, tableid, owner, sysdate, owner, 'humanSubject', (select max(uniqueid) from nc_animalspecies where name = 'researchSubject') from nc_tableID where tableName = 'NC_HUMANSUBJECT'";
		    sql = getInsertSubjectSql();
		    runSql(sql, "BIRNID");
		}
		sql = "select count(*) from nc_subjexperiment where nc_experiment_uniqueid = " + experimentID + " and subjectid = '" + escapeString(subjectID) + "'";
		if (runSql(sql, "enroll BIRNID") < 1)
		{
		    sql = "insert into NC_SUBJEXPERIMENT (UNIQUEID, TABLEID, OWNER, MODTIME,MODUSER, NC_EXPERIMENT_UNIQUEID, SUBJECTID, NC_RESEARCHGROUP_UNIQUEID ) select uid_seq.nextval, tableid, owner, modtime, moduser, " + experimentID + ", '" + escapeString(subjectID) + "', (select max(uniqueid) from nc_researchgroup where name = '" + escapeString(subjectGroup) + "' and NC_EXPERIMENT_UNIQUEID = " + experimentID + ") from nc_tableid where tableName = 'NC_SUBJEXPERIMENT'";
		    sql = getInsertSubjExpSql();
		    runSql(sql, "enroll BIRNID");
		}
	}
	else if (qname.equals("visitType")) {
		visitType = accumulator.toString().trim();
	}
	else if (qname.equals("visit")) { 
		//make sure the subject is enrolled to the experiment
	    	sql = "select count(*) from nc_subjexperiment where subjectid = '" + subjectID  + "' and nc_experiment_uniqueid = " + experimentID;
		if (runSql(sql, "visit") < 1 ) {
		   System.out.println("The subject, "  + subjectID + 
                   		", has not been enrolled to the experiment yet");
		   System.out.println("Please use HID web application enroll the subject first");
	           throw new SAXException("Subject is not enrolled to the experiment");
		}
		//validate visitID
		try {
			visitID = Integer.parseInt(stringID);
			if ( visitID < 1 ) throw new SAXException("Incorrect visitId, " + stringID);
		}
		catch (NumberFormatException e) {
	             	throw new SAXException("Incorrect visitId, " + stringID);
		}

		//does the visit exist?
       		sql = "select count(*) from nc_expcomponent where subjectid = '" + escapeString(subjectID) + "' and nc_experiment_uniqueid = " + experimentID + " and componentid = " + visitID; 
		rowCount = runSql(sql, "visit");
		//add the visit
		if (rowCount < 1) {
		    sql = "insert into nc_expComponent(COMPONENTID, NC_EXPERIMENT_UNIQUEID, SUBJECTID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP, DESCRIPTION, VISITTYPE, NAME, TIMEINTERVAL, ISTIMEINTERVAL) select " + visitID + "," + experimentID + ", '" + escapeString(subjectID) + "', uid_seq.nextval, tableid, owner, sysdate, moduser, to_timestamp('" + escapeString(visitDate) + "', 'YYYY-MM-DD HH24:MI:SS'),'" + escapeString(stringDesc) + "', '" + escapeString(visitType) + "', '" + escapeString(stringName) + "', null, 0 from nc_tableid where tableName = 'NC_EXPCOMPONENT'";
		    sql = getInsertVisitSql();
		    runSql(sql, "visit");
              	}
	}
	else if (qname.equals("study")) { 
		//validate studyID
		try {
			studyID = Integer.parseInt(stringID);
			if (studyID < 1) throw new SAXException("Incorrect visitId, " + stringID);
		}
		catch (NumberFormatException e) {
	             	throw new SAXException("Incorrect studyId, " + stringID);
		}

	        sql = "select count(*) from nc_expstudy where subjectid = '" + escapeString(subjectID) + "' and experimentid = " + experimentID + " and componentid = " + visitID + " and studyid = " + studyID; 
    		rowCount = runSql(sql, "study");

		//add the study
		if (rowCount < 1) {
	            sql = "insert into nc_expStudy(studyid, COMPONENTID, EXPERIMENTID, SUBJECTID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, TIME_STAMP, DESCRIPTION, NAME, TIMEINTERVAL, ISTIMEINTERVAL) select " + studyID + ","  + visitID + "," + experimentID + ", '" + escapeString(subjectID) + "', uid_seq.nextval, tableid, owner, sysdate, moduser, to_timestamp('" + escapeString(visitDate) + " " + escapeString(studyTime) + "', 'YYYY-MM-DD HH24:MI:SS'),'" + escapeString(stringDesc) + "', '" + escapeString(stringName) + "', null, 0 from nc_tableid where tableName = 'NC_EXPSTUDY'";
                    sql = getInsertStudySql();
    		    runSql(sql, "study");
		}
	}
    }

    public void endDocument() {
    }

    // Issue a warning
    public void warning(SAXParseException exception) {
	System.out.println("WARNING: line " + exception.getLineNumber() + ": "+
			   exception.getMessage());
    }

    // Report a parsing error
    public void error(SAXParseException exception) {
	System.out.println("ERROR: line " + exception.getLineNumber() + ": " +
			   exception.getMessage());
    }

    // Report a non-recoverable error and exit
    public void fatalError(SAXParseException exception) throws SAXException {
	System.out.println("FATAL: line " + exception.getLineNumber() + ": " +
			   exception.getMessage());
	throw(exception);
    }
}
