#!/usr/bin/python2

import sys, string
from UploadClasses import _SiteInfo, _Database

try:
  import cx_Oracle
except:
  pass

SiteInfo = _SiteInfo()
Database = _Database()
Database.set_SiteInfo(SiteInfo)

if len(sys.argv) < 6:
  sys.stderr.write("ERROR: Wrong number of arguments.\n")
  sys.stderr.write("dbtest.py <ScriptInstallDir> <Use_cx_Oracle> <Username> <Password> <Instance> <DBType> <Host> <Port>\n")
  sys.exit(0)

SiteInfo.set_ScriptInstallDir(sys.argv[1])
SiteInfo.set_UseCXOracle(string.atoi(sys.argv[2]))
SiteInfo.set_dbUser(sys.argv[3])
SiteInfo.set_dbPass(sys.argv[4])
SiteInfo.set_dbInstance(sys.argv[5])
SiteInfo.set_dbType(sys.argv[6])
if len(sys.argv) >= 8:
  SiteInfo.set_dbHost(sys.argv[7])
if len(sys.argv) >= 9:
  SiteInfo.set_dbPort(string.atoi(sys.argv[8]))

query="select uniqueid, make, model from nc_collectionequipment";
Database.execute(query, True)
ret=Database.fetchall()

for row in ret:
  for col in row:
    try:
      sys.stdout.write(col + "|")
    except:
      sys.stdout.write("%d|" % col)
  sys.stdout.write("\n")
sys.exit(0)
