/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirndownloader;

import java.io.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TeeOutputStream
        extends OutputStream {

    private static Log _logger = LogFactory.getLog(MainFrame.class.getName());
    OutputStream tee = null, out = null;
    int bytesread = 0;

    public TeeOutputStream(OutputStream chainedStream,
            OutputStream teeStream) {
        out = chainedStream;

        if (teeStream == null) {
            tee = System.out;
        } else {
            tee = teeStream;
        }
        bytesread = 0;
    }

    /**
     * Implementation for parent's abstract write method.
     * This writes out the passed in character to the both,
     * the chained stream and "tee" stream.
     */
    public void write(int c) throws IOException {
        bytesread++;
        _logger.debug("Writing char " + c + " (bytesread=" + bytesread + ")");
        tee.write(c);
        out.write(c);
    }

    @Override
    public void write(byte [] b) throws IOException {
        bytesread += b.length;
        _logger.debug("Writing byte array of length " + b.length + " (bytesread=" + bytesread + ")");
        tee.write(b);
        out.write(b);
    }

    @Override
    public void write(byte [] b, int off, int len) throws IOException {
        bytesread += len;
        _logger.debug("Writing byte array, offset " + off + ", length " + len + " (bytesread=" + bytesread + ")");
        tee.write(b, off, len);
        out.write(b, off, len);
    }

    /**
     * Closes both, chained and tee, streams.
     */
    public void close() throws IOException {
        flush();

        tee.close();
        out.close();
    }

    /**
     * Flushes chained stream; the tee stream is flushed
     * each time a character is written to it.
     */
    public void flush() throws IOException {
        out.flush();
        tee.flush();
    }
}
