package org.nbirn.fbirn.notes;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.DateTime;
import org.nbirn.fbirn.utilities.ChainedSQLException;
import org.nbirn.fbirn.utilities.db.LogConnection;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
/**
 *
 * @author gadde
 */
public class HID {

    private static final Logger _logger = Logger.getLogger(HID.class.getName());
    private String _ns = null;
    private URI _jdbcurl = null;
    private String _username = null;
    private char[] _password = null;
    private Connection _conn = null;
    private static final String matchExp = "nc_experiment_uniqueid = (SELECT uniqueid FROM nc_experiment WHERE name = ? )";
    private static final String matchSubject = "subjectid = ?";
    private static final String matchVisit = "componentid = ?";
    private static final String matchStudy = "studyid = ?";
    private static final String matchSeries = "name = ?";
    private static final String whereExp = "WHERE name = ?";
    private static final String whereSubject = "WHERE " + matchSubject;
    private static final String whereVisit = "WHERE " + matchExp + " AND " + matchSubject + " AND " + matchVisit;
    private static final String whereStudy = "WHERE experimentid = (SELECT uniqueid FROM nc_experiment WHERE name = ? ) AND " + matchSubject + " AND " + matchVisit + " AND " + matchStudy;
    private static final String whereSeries = "WHERE " + matchExp + " AND " + matchSubject + " AND " + matchVisit + " AND " + matchStudy + " AND " + matchSeries;
    private static final String whereSeriesNoStudy = "WHERE " + matchExp + " AND " + matchSubject + " AND " + matchVisit + " AND " + matchSeries;

    /**
     *
     * @param url JDBC URL for connecting to database
     * @param username Database user name (can be null)
     * @param password Database password (can be null)
     */
    public HID(URI url, String username, char[] password) {
        _username = username;
        _password = Arrays.copyOf(password, password.length);
        _jdbcurl = url;
    }

    public URI getURL() {
        return _jdbcurl;
    }
    
    public String getDBID() {
        return getURL().toString();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        Arrays.fill(_password, '0');
    }

    public Connection connect() throws NoteException {
        Properties connectionProps = new Properties();
        if (_username != null) {
            connectionProps.put("user", _username);
        }
        if (_password != null) {
            connectionProps.put("password", new String(_password));
        }
        try {
            _conn = DriverManager.getConnection(_jdbcurl.toString(), connectionProps);
            Logger logger = _logger;
            while (logger != null) {
                if (logger.getLevel() == null) {
                    logger = logger.getParent();
                } else {
                    break;
                }
            }
            if (logger == null || logger.getLevel().intValue() > Level.FINE.intValue()) {
                return _conn;
            } else {
                return new LogConnection(_conn, _jdbcurl.toString(), _logger);
            }
        } catch (SQLException ex) {
            _logger.log(Level.SEVERE, "Error connecting to database: {0}", ex.toString());
            throw new NoteException("Error connecting to database", new ChainedSQLException(ex));
        }
    }

    /**
     *
     * @return a list of items from this HID.
     * @throws RuntimeException if any errors occur connecting to or retrieving data from the database.
     */
    public List<ExperimentHierarchyItem> getItems() throws NoteException {
        Integer globalSiteID = null;
        try {
            if (_conn == null) {
                connect();
            }
            Statement stmt = _conn.createStatement();
            try {
                ResultSet rs = stmt.executeQuery("SELECT siteid FROM nc_site WHERE isprimary=1");
                while (rs.next()) {
                    globalSiteID = rs.getInt(1);
                }
            } finally {
                stmt.close();
            }
            stmt = _conn.createStatement();
            List<ExperimentHierarchyItem> itemlist = new ArrayList<ExperimentHierarchyItem>();
            try {
                // component (visit)
                ResultSet rs = stmt.executeQuery("SELECT c.uniqueid, e.baseuri, e.name, e.modtime, e.description, c.subjectid, c.componentid, c.name, c.modtime, c.description FROM nc_experiment e, nc_expcomponent c WHERE e.uniqueid=c.nc_experiment_uniqueid");
                while (rs.next()) {
                    String expName = rs.getString(3);
                    int expID = -1;
                    int sep = -1;
                    if ((sep = expName.indexOf("__")) != -1) {
                        expID = Integer.parseInt(expName.substring(sep + 2));
                        expName = expName.substring(0, sep);
                    }
                    try {
                        itemlist.add(new ExperimentHierarchyItem(
                                getDBID() + "#" + rs.getInt(1),
                                (rs.getString(2) == null ? null : new URI(rs.getString(2))), expID, expName, new DateTime(rs.getTimestamp(4)), rs.getString(5), // experiment
                                rs.getString(6), null, null, null, // subject
                                globalSiteID, rs.getInt(7), rs.getString(8), new DateTime(rs.getTimestamp(9)), rs.getString(10), // visit
                                null, null, null, null, // study
                                null, null, null, null // series
                                ));
                    } catch (URISyntaxException e) {
                        // XXX skip this path for now
                    }
                }
            } finally {
                stmt.close();
            }
            stmt = _conn.createStatement();
            try {
                // study
                ResultSet rs = stmt.executeQuery("SELECT st.uniqueid, e.baseuri, e.name, e.modtime, e.description, c.subjectid, c.componentid, c.name, c.modtime, c.description, st.studyid, st.name, st.modtime, st.description FROM nc_experiment e, nc_expcomponent c, nc_expstudy st WHERE e.uniqueid=c.nc_experiment_uniqueid AND st.experimentid=c.nc_experiment_uniqueid AND st.subjectid=c.subjectid AND st.componentid=c.componentid");
                while (rs.next()) {
                    String expName = rs.getString(3);
                    int expID = -1;
                    int sep = -1;
                    if ((sep = expName.indexOf("__")) != -1) {
                        expID = Integer.parseInt(expName.substring(sep + 2));
                        expName = expName.substring(0, sep);
                    }
                    try {
                        itemlist.add(new ExperimentHierarchyItem(
                                getDBID() + "#" + rs.getInt(1),
                                (rs.getString(2) == null ? null : new URI(rs.getString(2))), expID, expName, new DateTime(rs.getTimestamp(4)), rs.getString(5), // experiment
                                rs.getString(6), null, null, null, // subject
                                globalSiteID, rs.getInt(7), rs.getString(8), new DateTime(rs.getTimestamp(9)), rs.getString(10), // visit
                                rs.getInt(11), rs.getString(12), new DateTime(rs.getTimestamp(13)), rs.getString(14), // study
                                null, null, null, null // series
                                ));
                    } catch (URISyntaxException e) {
                        // XXX skip this path for now
                    }
                }
            } finally {
                stmt.close();
            }
            stmt = _conn.createStatement();
            try {
                // segment (series)
                ResultSet rs = stmt.executeQuery("SELECT se.uniqueid, e.baseuri, e.name, e.modtime, e.description, c.subjectid, c.componentid, c.name, c.modtime, c.description, st.studyid, st.name, st.modtime, st.description, se.segmentid, se.name, se.modtime, se.description FROM nc_experiment e, nc_expcomponent c, nc_expsegment se LEFT JOIN nc_expstudy st ON (st.experimentid=se.nc_experiment_uniqueid AND st.subjectid=se.subjectid AND st.componentid=se.componentid AND st.studyid=se.studyid) WHERE e.uniqueid=c.nc_experiment_uniqueid AND e.uniqueid=se.nc_experiment_uniqueid AND c.subjectid = se.subjectid AND c.componentid=se.componentid");
                while (rs.next()) {
                    String expName = rs.getString(3);
                    int expID = -1;
                    int sep = -1;
                    if ((sep = expName.indexOf("__")) != -1) {
                        expID = Integer.parseInt(expName.substring(sep + 2));
                        expName = expName.substring(0, sep);
                    }
                    try {
                        itemlist.add(new ExperimentHierarchyItem(
                                getDBID() + "#" + rs.getInt(1),
                                (rs.getString(2) == null ? null : new URI(rs.getString(2))), expID, expName, new DateTime(rs.getTimestamp(4)), rs.getString(5), // experiment
                                rs.getString(6), null, null, null, // subject
                                globalSiteID, rs.getInt(7), rs.getString(8), new DateTime(rs.getTimestamp(9)), rs.getString(10), // visit
                                rs.getInt(11), rs.getString(12), new DateTime(rs.getTimestamp(13)), rs.getString(14), // study
                                rs.getInt(15), rs.getString(16), new DateTime(rs.getTimestamp(17)), rs.getString(18) // series
                                ));
                    } catch (URISyntaxException e) {
                        // XXX skip this path for now
                    }
                }
            } finally {
                stmt.close();
            }
            return itemlist;
        } catch (SQLException ex) {
            _logger.log(Level.SEVERE, "Error getting database items: {0}", ex.toString());
            throw new NoteException("Error connecting to or reading from database", new ChainedSQLException(ex));
        } finally {
            if (_conn != null) {
                try {
                    _conn.close();
                } catch (SQLException e) {
                    // oh well
                }
            }
        }
    }
}
