/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nbirn.fbirn.notes;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.nbirn.fbirn.xcede2.catalog.Catalog;
import org.nbirn.fbirn.xcede2.catalog.CatalogEntry;

/**
 *
 * @author gadde
 */
public class NoteSourceCatalog extends NoteSource {

    private Catalog _cat = null;
    private URI _baseURI = null;

    public NoteSourceCatalog(Catalog cat) {
        this(cat, null);
    }

    public NoteSourceCatalog(Catalog cat, URI baseURI) {
        _cat = cat;
        _baseURI = baseURI;
    }

    @Override
    protected List<Note> getNoteListInternal() throws NoteException {
        List<Note> retval = new NoteList();
        addNoteListFromCatalog(retval, _cat, null, null, null, null, null, null);
        return retval;
    }

    private void addNoteListFromCatalog(List<Note> notelist, Catalog cat, String ns, String name, String value, String comment, String author, DateTime timeStamp) throws NoteException {
        String catid = null;
        String catns = ns;
        String catname = name;
        String catvalue = value;
        String catcomment = comment;
        String catauthor = author;
        DateTime catts = timeStamp;
        if (cat.hasMetaField("noteID")) {
            catid = (String) cat.getMetaField("noteID");
        }
        if (cat.hasMetaField("noteNamespace")) {
            catns = (String) cat.getMetaField("noteNamespace");
        }
        if (cat.hasMetaField("noteName")) {
            catname = (String) cat.getMetaField("noteName");
        }
        if (cat.hasMetaField("noteValue")) {
            catvalue = (String) cat.getMetaField("noteValue");
        }
        if (cat.hasMetaField("noteComment")) {
            catcomment = (String) cat.getMetaField("noteComment");
        }
        if (cat.hasMetaField("noteAuthor")) {
            catauthor = (String) cat.getMetaField("noteAuthor");
        }
        if (cat.hasMetaField("noteTimeStamp")) {
            catts = ISODateTimeFormat.dateTimeParser().parseDateTime((String) cat.getMetaField("noteTimeStamp"));
        }
        ArrayList<URIWithType> paths = null;
        if (cat.getNumEntries() > 0) {
            checkInterrupts();
            paths = new ArrayList<URIWithType>();
            for (int i = 0; i < cat.getNumEntries(); i++) {
                CatalogEntry entry = cat.getEntry(i);
                int type = URIWithType.TYPE_UNKNOWN;
                if (entry.hasMetaField("fileType")) {
                    String typestr = (String) entry.getMetaField("fileType");
                    if ("file".equals(typestr)) {
                        type = URIWithType.TYPE_FILE;
                    } else if ("dir".equals(typestr)) {
                        type = URIWithType.TYPE_DIR;
                    }
                }
                String entryid = null;
                String entryns = catns;
                String entryname = catname;
                String entryvalue = catvalue;
                String entrycomment = catcomment;
                String entryauthor = catauthor;
                DateTime entryts = catts;
                if (entry.hasMetaField("noteID")) {
                    entryid = (String) entry.getMetaField("noteID");
                }
                if (entry.hasMetaField("noteNamespace")) {
                    entryns = (String) entry.getMetaField("noteNamespace");
                }
                if (entry.hasMetaField("noteName")) {
                    entryname = (String) entry.getMetaField("noteName");
                }
                if (entry.hasMetaField("noteValue")) {
                    entryvalue = (String) entry.getMetaField("noteValue");
                }
                if (entry.hasMetaField("noteComment")) {
                    entrycomment = (String) entry.getMetaField("noteComment");
                }
                if (entry.hasMetaField("noteAuthor")) {
                    entryauthor = (String) entry.getMetaField("noteAuthor");
                }
                if (entry.hasMetaField("noteTimeStamp")) {
                    entryts = ISODateTimeFormat.dateTimeParser().parseDateTime((String) entry.getMetaField("noteTimeStamp"));
                }
                // comparing using != below is OK, because we are checking whether the variable has been re-assigned
                if (entryns != catns || entryname != catname || entryvalue != catvalue || entrycomment != catcomment || entryauthor != catauthor || entryts != catts) {
                    // something has changed, so make our own note
                    notelist.add(new Note(entryid, entryns, entryname, entryvalue, entrycomment, entryauthor, entryts, new URIWithType(type, _baseURI, entry.getURI())));
                } else {
                    // leave it to the above catalog
                    paths.add(new URIWithType(type, entry.getURI()));
                }
            }
        }
        for (int i = 0; i < cat.getNumCatalogs(); i++) {
            addNoteListFromCatalog(notelist, cat.getCatalog(i), catns, catname, catvalue, catcomment, catauthor, catts);
        }
        if ((paths != null && !paths.isEmpty()) || (cat.getNumCatalogs() == 0 && cat.getNumEntries() == 0 && (catns != ns || catname != name || catvalue != value || catauthor != author || catts != timeStamp))) {
            // this is a leaf catalog (with no children) and some values have been set here, so create a note
            // something has changed, so make our own note
            notelist.add(new Note(catid, catns, catname, catvalue, catcomment, catauthor, catts, paths));
        }
    }
}
